/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.matroska;

import fm.icelink.ArrayExtensions;
import fm.icelink.ArrayListExtensions;
import fm.icelink.BitAssistant;
import fm.icelink.ByteOutputStream;
import fm.icelink.IntegerHolder;
import fm.icelink.Log;
import fm.icelink.StringExtensions;
import fm.icelink.matroska.Element;
import fm.icelink.matroska.TrackEntry;
import java.util.ArrayList;

public class Track
extends Element {
    private TrackEntry[] _trackEntries;

    public static byte[] getEbmlId() {
        return new byte[]{22, 84, -82, 107};
    }

    @Override
    public byte[] getId() {
        return Track.getEbmlId();
    }

    @Override
    protected byte[] getInnerBytes() {
        ByteOutputStream stream = new ByteOutputStream();
        if (this.getTrackEntries() != null) {
            for (TrackEntry entry : this.getTrackEntries()) {
                stream.writeBuffer(entry.getBytes());
            }
        }
        return stream.toArray();
    }

    public TrackEntry[] getTrackEntries() {
        return this._trackEntries;
    }

    public void merge(Track track) {
        if (track != null) {
            ArrayList list = new ArrayList();
            ArrayListExtensions.addRange(list, this.getTrackEntries());
            ArrayListExtensions.addRange(list, track.getTrackEntries());
            this.setTrackEntries(list.toArray(new TrackEntry[0]));
        }
    }

    public void setTrackEntries(TrackEntry[] value) {
        this._trackEntries = value;
    }

    public Track() {
    }

    public Track(byte[] bytes) {
        this();
        ArrayList<TrackEntry> list = new ArrayList<TrackEntry>();
        int offset = 0;
        while (offset < ArrayExtensions.getLength(bytes)) {
            IntegerHolder _var0 = new IntegerHolder(offset);
            byte[] _var1 = Element.readId(bytes, offset, _var0);
            offset = _var0.getValue();
            byte[] buffer = _var1;
            IntegerHolder _var2 = new IntegerHolder(offset);
            byte[] _var3 = Element.readValue(bytes, offset, _var2);
            offset = _var2.getValue();
            byte[] buffer2 = _var3;
            if (Element.compare(buffer, TrackEntry.getEbmlId())) {
                list.add(new TrackEntry(buffer2));
                continue;
            }
            Log.warn(StringExtensions.concat("Unrecognized ID in MatroskaTrack: ", BitAssistant.getHexString(buffer)));
        }
        if (ArrayListExtensions.getCount(list) > 0) {
            this.setTrackEntries(list.toArray(new TrackEntry[0]));
        }
    }
}

