/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.Asn1Any;
import fm.icelink.Asn1Sequence;
import fm.icelink.Asn1Set;
import fm.icelink.Global;
import fm.icelink.X501Attribute;
import fm.icelink.X501AttributeType;
import java.util.ArrayList;

class X501RelativeDistinguishedName {
    private X501Attribute[] _attributes;

    public static X501RelativeDistinguishedName fromAsn1(Asn1Any any) {
        Asn1Set set = Global.tryCast(any, Asn1Set.class);
        if (set == null) {
            return null;
        }
        X501RelativeDistinguishedName name = new X501RelativeDistinguishedName();
        ArrayList<X501Attribute> list = new ArrayList<X501Attribute>();
        for (Asn1Any any2 : set.getValues()) {
            list.add(X501Attribute.fromAsn1(any2));
        }
        name.setAttributes(list.toArray(new X501Attribute[0]));
        return name;
    }

    public X501Attribute getAttribute(long[] attributeType) {
        if (this.getAttributes() != null) {
            for (X501Attribute attribute : this.getAttributes()) {
                if (!X501AttributeType.areEqual(attributeType, attribute.getAttributeType())) continue;
                return attribute;
            }
        }
        return null;
    }

    public X501Attribute[] getAttributes() {
        return this._attributes;
    }

    public void setAttributes(X501Attribute[] value) {
        this._attributes = value;
    }

    public Asn1Set toAsn1() {
        ArrayList<Asn1Sequence> list = new ArrayList<Asn1Sequence>();
        for (X501Attribute attribute : this.getAttributes()) {
            list.add(attribute.toAsn1());
        }
        return new Asn1Set(list.toArray(new Asn1Any[0]));
    }

    public X501RelativeDistinguishedName(X501Attribute[] attributeTypeAndValues) {
        this.setAttributes(attributeTypeAndValues);
    }

    public X501RelativeDistinguishedName() {
    }
}

