/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.BandwidthAdaptationPolicy;
import fm.icelink.FirControlFrame;
import fm.icelink.FirEntry;
import fm.icelink.Global;
import fm.icelink.IElement;
import fm.icelink.IInput;
import fm.icelink.IMediaElement;
import fm.icelink.IMediaInput;
import fm.icelink.IMediaOutput;
import fm.icelink.IMediaStream;
import fm.icelink.IOutput;
import fm.icelink.IStream;
import fm.icelink.IVideoElement;
import fm.icelink.IVideoInput;
import fm.icelink.IVideoInputCollection;
import fm.icelink.IVideoOutput;
import fm.icelink.IVideoOutputCollection;
import fm.icelink.IVideoStream;
import fm.icelink.JitterConfig;
import fm.icelink.LocalMedia;
import fm.icelink.MediaHeaderExtensionPolicy;
import fm.icelink.MediaStream;
import fm.icelink.NackPolicy;
import fm.icelink.RedFecPolicy;
import fm.icelink.RembPolicy;
import fm.icelink.RemoteMedia;
import fm.icelink.StreamDirection;
import fm.icelink.StreamType;
import fm.icelink.VideoBuffer;
import fm.icelink.VideoBufferCollection;
import fm.icelink.VideoFormat;
import fm.icelink.VideoFormatCollection;
import fm.icelink.VideoFrame;
import fm.icelink.VideoTrack;
import fm.icelink.sdp.rtp.MapAttribute;

public class VideoStream
extends MediaStream<IVideoOutput, IVideoOutputCollection, IVideoInput, IVideoInputCollection, VideoFrame, VideoBuffer, VideoBufferCollection, VideoFormat, VideoFormatCollection>
implements IVideoStream,
IMediaStream,
IStream,
IVideoInput,
IMediaInput<IVideoOutput, IVideoInput, VideoFrame, VideoBuffer, VideoBufferCollection, VideoFormat>,
IInput<IVideoOutput, IVideoInput, VideoFrame, VideoBuffer, VideoBufferCollection, VideoFormat>,
IVideoOutput,
IMediaOutput<IVideoOutput, IVideoInput, VideoFrame, VideoBuffer, VideoBufferCollection, VideoFormat>,
IOutput<IVideoOutput, IVideoInput, VideoFrame, VideoBuffer, VideoBufferCollection, VideoFormat>,
IVideoElement,
IMediaElement,
IElement {
    private VideoTrack _localTrack;
    private volatile boolean _readyToSend;
    private VideoTrack _remoteTrack;

    @Override
    protected VideoFormat createFormat(MapAttribute attribute) {
        return this.createFormat(attribute.getFormatName(), attribute.getClockRate(), attribute.getFormatParameters(), attribute.getPayloadType());
    }

    @Override
    protected VideoFormat createFormat(String name, int clockRate, String parameters, int payloadType) {
        VideoFormat format = new VideoFormat(name, clockRate);
        format.setRegisteredPayloadType(payloadType);
        format.setIsPacketized(true);
        return format;
    }

    @Override
    protected IVideoInputCollection createInputCollection(IVideoOutput output) {
        return new IVideoInputCollection(output);
    }

    @Override
    protected VideoFormatCollection createMediaFormatCollection() {
        return new VideoFormatCollection();
    }

    @Override
    protected IVideoOutputCollection createOutputCollection(IVideoInput input) {
        return new IVideoOutputCollection(input);
    }

    public VideoTrack getLocalTrack() {
        return this._localTrack;
    }

    public VideoTrack getRemoteTrack() {
        return this._remoteTrack;
    }

    @Override
    protected void processBandwidthAdapatationPolicyChange(BandwidthAdaptationPolicy policy) {
        super.processBandwidthAdapatationPolicyChange(policy);
        if (Global.equals((Object)policy, (Object)BandwidthAdaptationPolicy.Enabled)) {
            super.setAbsoluteSenderTimeLocalDirection(StreamDirection.SendOnly);
            super.setAbsoluteSenderTimePolicy(MediaHeaderExtensionPolicy.Negotiated);
            super.setRembPolicy(RembPolicy.Negotiated);
        } else if (Global.equals((Object)policy, (Object)BandwidthAdaptationPolicy.Disabled)) {
            super.setAbsoluteSenderTimePolicy(MediaHeaderExtensionPolicy.Disabled);
            super.setRembPolicy(RembPolicy.Disabled);
        }
    }

    @Override
    public boolean processFrame(VideoFrame frame) {
        if (!this._readyToSend) {
            this._readyToSend = ((VideoBuffer)frame.getLastBuffer()).getIsKeyFrame();
        }
        if (!this._readyToSend) {
            super.raiseControlFrames(new FirControlFrame[]{new FirControlFrame(new FirEntry(super.getFirSequenceNumber()))});
            return false;
        }
        return super.processFrame(frame);
    }

    private void setLocalTrack(VideoTrack value) {
        this._localTrack = value;
    }

    private void setRemoteTrack(VideoTrack value) {
        this._remoteTrack = value;
    }

    public VideoStream(IVideoOutput[] inputs) {
        this(inputs, null);
    }

    public VideoStream(IVideoOutput[] inputs, IVideoInput[] outputs) {
        super(StreamType.Video, new JitterConfig());
        this._readyToSend = false;
        if (inputs == null && outputs == null) {
            throw new RuntimeException(new Exception("Cannot initialize video stream if no inputs and no outputs are provided."));
        }
        super.setRedFecPolicy(RedFecPolicy.Disabled);
        super.setNackPolicy(NackPolicy.Negotiated);
        if (inputs != null) {
            super.addInputs((IMediaOutput[])inputs);
        }
        if (outputs != null) {
            super.addOutputs((IMediaInput[])outputs);
        }
        super.setAbsoluteSenderTimePolicy(MediaHeaderExtensionPolicy.Disabled);
    }

    public VideoStream(IVideoOutput input) {
        IVideoOutput[] iVideoOutputArray;
        if (input == null) {
            iVideoOutputArray = null;
        } else {
            IVideoOutput[] iVideoOutputArray2 = new IVideoOutput[1];
            iVideoOutputArray = iVideoOutputArray2;
            iVideoOutputArray2[0] = input;
        }
        this(iVideoOutputArray);
    }

    public VideoStream(VideoTrack localTrack) {
        this(localTrack, null);
    }

    public VideoStream() {
        this(new IVideoOutput[0]);
    }

    public VideoStream(IVideoInput output) {
        IVideoInput[] iVideoInputArray;
        if (output == null) {
            iVideoInputArray = null;
        } else {
            IVideoInput[] iVideoInputArray2 = new IVideoInput[1];
            iVideoInputArray = iVideoInputArray2;
            iVideoInputArray2[0] = output;
        }
        this(iVideoInputArray);
    }

    public VideoStream(IVideoOutput input, IVideoInput output) {
        IVideoInput[] iVideoInputArray;
        IVideoOutput[] iVideoOutputArray;
        if (input == null) {
            iVideoOutputArray = null;
        } else {
            IVideoOutput[] iVideoOutputArray2 = new IVideoOutput[1];
            iVideoOutputArray = iVideoOutputArray2;
            iVideoOutputArray2[0] = input;
        }
        if (output == null) {
            iVideoInputArray = null;
        } else {
            IVideoInput[] iVideoInputArray2 = new IVideoInput[1];
            iVideoInputArray = iVideoInputArray2;
            iVideoInputArray2[0] = output;
        }
        this(iVideoOutputArray, iVideoInputArray);
    }

    public VideoStream(IVideoInput[] outputs) {
        this(null, outputs);
    }

    public VideoStream(VideoTrack localTrack, VideoTrack remoteTrack) {
        this(localTrack == null ? null : (IVideoOutput[])localTrack.getOutputs(), remoteTrack == null ? null : (IVideoInput[])remoteTrack.getInputs());
        this.setLocalTrack(localTrack);
        this.setRemoteTrack(remoteTrack);
    }

    public VideoStream(LocalMedia localMedia, RemoteMedia remoteMedia) {
        this(localMedia == null ? null : (VideoTrack)localMedia.getVideoTrack(), remoteMedia == null ? null : (VideoTrack)remoteMedia.getVideoTrack());
        super.setLocalMedia(localMedia);
        super.setRemoteMedia(remoteMedia);
    }

    public VideoStream(RemoteMedia remoteMedia) {
        this(null, remoteMedia);
    }

    public VideoStream(LocalMedia localMedia) {
        this(localMedia, null);
    }
}

