/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.AfbControlFrame;
import fm.icelink.AppControlFrame;
import fm.icelink.ArrayExtensions;
import fm.icelink.ArrayListExtensions;
import fm.icelink.AtomicLong;
import fm.icelink.AudioFormat;
import fm.icelink.Binary;
import fm.icelink.ByeControlFrame;
import fm.icelink.CodecStats;
import fm.icelink.Constants;
import fm.icelink.DataBuffer;
import fm.icelink.DateExtensions;
import fm.icelink.DoubleExtensions;
import fm.icelink.FecContext;
import fm.icelink.FecProducer;
import fm.icelink.FecReceiver;
import fm.icelink.FecRedPacket;
import fm.icelink.FeedbackControlFrame;
import fm.icelink.FirControlFrame;
import fm.icelink.FirEntry;
import fm.icelink.FloatExtensions;
import fm.icelink.GenericNack;
import fm.icelink.GenericNackControlFrame;
import fm.icelink.Global;
import fm.icelink.IAction1;
import fm.icelink.IActionDelegate1;
import fm.icelink.IFunction1;
import fm.icelink.IFunctionDelegate1;
import fm.icelink.ILog;
import fm.icelink.IceTransport;
import fm.icelink.IceTransportState;
import fm.icelink.IntegerExtensions;
import fm.icelink.JitterBuffer;
import fm.icelink.JitterConfig;
import fm.icelink.LinkedList;
import fm.icelink.LinkedListEnumerator;
import fm.icelink.LockedRandomizer;
import fm.icelink.Log;
import fm.icelink.LongExtensions;
import fm.icelink.LongHolder;
import fm.icelink.MathAssistant;
import fm.icelink.MediaBuffer;
import fm.icelink.MediaBufferCollection;
import fm.icelink.MediaControlFrame;
import fm.icelink.MediaFormat;
import fm.icelink.MediaFormatCollection;
import fm.icelink.MediaFrame;
import fm.icelink.MediaReceiverStats;
import fm.icelink.MediaSenderStats;
import fm.icelink.MediaTransport;
import fm.icelink.NackBuffer;
import fm.icelink.NackConfig;
import fm.icelink.NetworkTimeProtocol;
import fm.icelink.PliControlFrame;
import fm.icelink.RRControlFrame;
import fm.icelink.RedFecConfig;
import fm.icelink.RembControlFrame;
import fm.icelink.ReportBlock;
import fm.icelink.ReportControlFrame;
import fm.icelink.RpsiControlFrame;
import fm.icelink.RtpHeaderExtensionRegistry;
import fm.icelink.RtpPacket;
import fm.icelink.RtpSendBuffer;
import fm.icelink.SRControlFrame;
import fm.icelink.ScheduledItem;
import fm.icelink.Scheduler;
import fm.icelink.SdesChunk;
import fm.icelink.SdesControlFrame;
import fm.icelink.SdesItem;
import fm.icelink.SdesItemType;
import fm.icelink.SliControlFrame;
import fm.icelink.SrtpTransport;
import fm.icelink.StreamDirection;
import fm.icelink.StreamType;
import fm.icelink.StringExtensions;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

abstract class RtpTransport<TFrame extends MediaFrame<TBuffer, TBufferCollection, TFormat, TFrame>, TBuffer extends MediaBuffer<TFormat, TBuffer>, TBufferCollection extends MediaBufferCollection<TBuffer, TBufferCollection, TFormat>, TFormat extends MediaFormat<TFormat>, TFormatCollection extends MediaFormatCollection<TFormat, TFormatCollection>>
extends MediaTransport<TFrame, TBuffer, TBufferCollection, TFormat, TFormatCollection> {
    private StreamDirection __absoluteSenderTimeDirection;
    private long __actualLatestDownstreamBitRate = -1L;
    private long __actualLatestUpstreamBitRate = -1L;
    private long __baseFrameTimestamp = -1L;
    private int __currentFecSequenceNumber;
    private long __currentLocalSynchronizationSource = 0L;
    private int __currentMediaSequenceNumber = 0;
    private int __currentReceivePayloadType = -1;
    private long __currentRemoteSynchronizationSource = 0L;
    private int __currentRtpSequenceNumber;
    private int __currentSendPayloadType = -1;
    private int __delayToStartCollectingBWData = 3000;
    private StreamDirection __direction;
    private int __durationOfBWDataCollection = 10000;
    private long __estimatedDownstreamBitrate = -1L;
    private long __estimatedUpstreamBitrate = -1L;
    private LinkedList<DataBuffer> __fecBuffer;
    private long __firstSendRtpTimestamp = -1L;
    private long __firstSendTicks = -1L;
    private long __frameCount = 0L;
    private boolean __ignoreStats = true;
    private long __lastBWStatsCollectionStartTimestamp = -1L;
    private long __lastExpectedPacketCount = 0L;
    private int __lastFirReceiveSequenceNumber = -1;
    private long __lastFirReceiveTimestamp = 0L;
    private int __lastFirSendSequenceNumber = -1;
    private long __lastFirSendTimestamp = 0L;
    private long __lastNackNetworkConditionReportTicks = -1L;
    private long __lastNackReportTicks = -1L;
    private long __lastPliReceiveTimestamp = 0L;
    private long __lastPliSendTimestamp = 0L;
    private long __lastReceivedPacketCount = 0L;
    private long __lastReceiveTransit = 0L;
    private long __lastReportSent = -1L;
    private long __lastSenderReportNtpTimestamp = 0L;
    private long __lastSenderReportTicks = 0L;
    private long __maxReceivedPacketIndex = -1L;
    private long __minReceivedPacketIndex = -1L;
    private long __minReceivedRtpTimestamp = -1L;
    private long __minReceivedTicks = -1L;
    private int __nackNetworkConditionReportingInterval = 10000;
    private int __nackReportingInterval = 1000;
    private int __nacksReceivedDuringInterval = 0;
    private int __nacksReceivedDuringIntervalCriticalNetworkWarning = 1500;
    private int __nacksReceivedDuringIntervalPoorNetworkWarning = 200;
    private int __nacksReceivedDuringNetworkConditionInterval = 0;
    private int __nacksSentDuringInterval = 0;
    private int __nacksSentDuringIntervalCriticalNetworkWarning = 1500;
    private int __nacksSentDuringIntervalPoorNetworkWarning = 200;
    private int __nacksSentDuringNetworkConditionInterval = 0;
    private int __nextNackBufferRtpSequenceNumber = -1;
    private long __nextNackBufferSequenceNumber = -1L;
    private long __octotetsReceivedOnLastBWStatsCollectionStart = 0L;
    private long __octotetsSentOnLastBWStatsCollectionStart = 0L;
    private List<IAction1<MediaControlFrame[]>> __onSendControlFrames = new ArrayList<IAction1<MediaControlFrame[]>>();
    private Object __receiveCountsLock;
    private double __receiveJitter = 0.0;
    private double __receiveRtpCyclesPerTick = -1.0;
    private int __reportIntervalInTicks;
    private int __reportsReceived = 0;
    private static double __roundTripTimeAlpha;
    private int __roundTripTimeCriticalWarning = 750;
    private int __roundTripTimePoorWarning = 300;
    private int __roundTripTimeRR = -1;
    private double __sendRtpCyclesPerTick = -1.0;
    private Object __sentCountsLock;
    private double __smoothedDownlinkPacketLoss = -1.0;
    private long __smoothedUplinkBandwidthFromRemoteRemb = -1L;
    private double __smoothedUplinkPacketLoss = -1.0;
    private static float __smoothingFactor;
    private long __startTicks = -1L;
    private int __startTimeOffset;
    private boolean __videoBridgeMode = false;
    private boolean _disableAutomaticReports;
    ScheduledItem _dispatchRembSI;
    private FecProducer _fecProducer;
    private FecReceiver _fecReceiver;
    private AtomicLong _firsReceived;
    private AtomicLong _firsSent;
    private int _inboundPacketsLostRtp;
    private JitterBuffer<TFrame, TBuffer, TBufferCollection, TFormat> _jitterBuffer;
    private JitterConfig _jitterConfig;
    private static ILog _log;
    private NackBuffer<TFrame, TBuffer, TBufferCollection, TFormat> _nackBuffer;
    private NackConfig _nackConfig;
    private AtomicLong _nacksReceived;
    private AtomicLong _nacksSent;
    private AtomicLong _octetsReceivedRtcp;
    private AtomicLong _octetsReceivedRtp;
    private AtomicLong _octetsSentRtcp;
    private AtomicLong _octetsSentRtp;
    private IAction1<MediaControlFrame[]> _onSendControlFrames = null;
    private int _outboundPacketsLostRtp;
    private AtomicLong _packetsDiscarded;
    private AtomicLong _packetsReceivedRtcp;
    private AtomicLong _packetsReceivedRtp;
    private AtomicLong _packetsSentRtcp;
    private AtomicLong _packetsSentRtp;
    private AtomicLong _plisReceived;
    private AtomicLong _plisSent;
    ScheduledItem _processBandwidthStatsSI;
    private boolean _redFecActivated;
    private RedFecConfig _redFecConfig;
    private RtpHeaderExtensionRegistry _rtpHeaderExtensionRegistry;
    private RtpSendBuffer<TFrame, TBuffer, TBufferCollection, TFormat> _sendBuffer;
    private SrtpTransport<TFrame, TBuffer, TBufferCollection, TFormat, TFormatCollection> _srtpTransport;
    ScheduledItem _startCollectingBWStatsSI;
    private StreamType _type;

    public void addOnSendControlFrames(IAction1<MediaControlFrame[]> value) {
        if (value != null) {
            if (this._onSendControlFrames == null) {
                this._onSendControlFrames = new IAction1<MediaControlFrame[]>(){

                    @Override
                    public void invoke(MediaControlFrame[] p0) {
                        for (IAction1 action : new ArrayList(RtpTransport.this.__onSendControlFrames)) {
                            action.invoke(p0);
                        }
                    }
                };
            }
            this.__onSendControlFrames.add(value);
        }
    }

    private void attachTransportEvents() {
        this.getSrtpTransport().addOnReceiveFrame(new IActionDelegate1<TFrame>(){

            @Override
            public String getId() {
                return "fm.icelink.MediaTransport<TFrame,TBuffer,TBufferCollection,TFormat,TFormatCollection>.receiveFrame";
            }

            @Override
            public void invoke(TFrame frame) {
                RtpTransport.this.receiveFrame(frame);
            }
        });
        this.getSrtpTransport().addOnReceiveControlFrames((IAction1<MediaControlFrame[]>)new IActionDelegate1<MediaControlFrame[]>(){

            @Override
            public String getId() {
                return "fm.icelink.MediaTransport<TFrame,TBuffer,TBufferCollection,TFormat,TFormatCollection>.receiveControlFrames";
            }

            @Override
            public void invoke(MediaControlFrame[] controlFrames) {
                RtpTransport.this.receiveControlFrames(controlFrames);
            }
        });
    }

    public abstract TFrame[] createFormatArray(int var1);

    private void detachTransportEvents() {
        this.getSrtpTransport().removeOnReceiveFrame(new IActionDelegate1<TFrame>(){

            @Override
            public String getId() {
                return "fm.icelink.MediaTransport<TFrame,TBuffer,TBufferCollection,TFormat,TFormatCollection>.receiveFrame";
            }

            @Override
            public void invoke(TFrame frame) {
                RtpTransport.this.receiveFrame(frame);
            }
        });
        this.getSrtpTransport().removeOnReceiveControlFrames((IAction1<MediaControlFrame[]>)new IActionDelegate1<MediaControlFrame[]>(){

            @Override
            public String getId() {
                return "fm.icelink.MediaTransport<TFrame,TBuffer,TBufferCollection,TFormat,TFormatCollection>.receiveControlFrames";
            }

            @Override
            public void invoke(MediaControlFrame[] controlFrames) {
                RtpTransport.this.receiveControlFrames(controlFrames);
            }
        });
    }

    @Override
    public void doReceiveControlFrames(MediaControlFrame[] controlFrames) {
        this.updateRtcpReceiverStatistics(controlFrames);
        boolean filterPli = false;
        boolean filterFir = false;
        for (MediaControlFrame frame : controlFrames) {
            if (frame instanceof ByeControlFrame) {
                if (!_log.getIsVerboseEnabled()) continue;
                _log.verbose(StringExtensions.format("Received RTCP goodbye (BYE) for {0} stream.", this.getType().toString()));
                continue;
            }
            if (frame instanceof SRControlFrame) {
                if (_log.getIsVerboseEnabled()) {
                    _log.verbose(StringExtensions.format("Received RTCP sender report (SR) for {0} stream.", this.getType().toString()));
                }
                SRControlFrame frame2 = (SRControlFrame)frame;
                this.__lastSenderReportNtpTimestamp = frame2.getNtpTimestamp();
                this.__lastSenderReportTicks = DateExtensions.getTicks(DateExtensions.getUtcNow());
                ReportBlock reportBlock = frame2.getReportBlock();
                if (reportBlock == null) continue;
                this.processReportBlock(reportBlock);
                continue;
            }
            if (frame instanceof RRControlFrame) {
                RRControlFrame frame3;
                ReportBlock block;
                if (_log.getIsVerboseEnabled()) {
                    _log.verbose(StringExtensions.format("Received RTCP receiver report (RR) for {0} stream.", this.getType().toString()));
                }
                if ((block = (frame3 = (RRControlFrame)frame).getReportBlock()) == null) continue;
                this.processReportBlock(block);
                continue;
            }
            if (frame instanceof AppControlFrame) {
                if (!_log.getIsVerboseEnabled()) continue;
                _log.verbose(StringExtensions.format("Received RTCP application-specific message for {0} stream.", this.getType().toString()));
                continue;
            }
            if (frame instanceof SdesControlFrame) {
                if (!_log.getIsVerboseEnabled()) continue;
                _log.verbose(StringExtensions.format("Received RTCP source description (SDES) for {0} stream.", this.getType().toString()));
                continue;
            }
            if (frame instanceof AfbControlFrame) {
                if (!_log.getIsVerboseEnabled()) continue;
                _log.verbose(StringExtensions.format("Received RTCP application feedback (AFB) for {0} stream.", this.getType().toString()));
                continue;
            }
            if (frame instanceof PliControlFrame) {
                if (_log.getIsVerboseEnabled()) {
                    _log.verbose(StringExtensions.format("Received RTCP picture loss indication (PLI) for {0} stream.", this.getType().toString()));
                }
                this.getPlisReceived().increment();
                long ticks = DateExtensions.getTicks(DateExtensions.getUtcNow());
                if (this.__lastPliReceiveTimestamp == -1L || ticks - this.__lastPliReceiveTimestamp > (long)this.getKeyFrameDelayTicks()) {
                    this.__lastPliReceiveTimestamp = ticks;
                    continue;
                }
                filterPli = true;
                continue;
            }
            if (frame instanceof FirControlFrame) {
                if (_log.getIsVerboseEnabled()) {
                    _log.verbose(StringExtensions.format("Received RTCP full intra refresh (FIR) for {0} stream.", this.getType().toString()));
                }
                this.getFirsReceived().increment();
                FirControlFrame frame4 = (FirControlFrame)frame;
                int sequenceNumber = frame4.getEntry().getSequenceNumber();
                int firSequenceNumberDelta = 1;
                if (this.__lastFirReceiveSequenceNumber != -1) {
                    firSequenceNumberDelta = this.getFirSequenceNumberDelta(sequenceNumber, this.__lastFirReceiveSequenceNumber);
                }
                long ticks = DateExtensions.getTicks(DateExtensions.getUtcNow());
                if (firSequenceNumberDelta > 0 || firSequenceNumberDelta == 0 && ticks - this.__lastFirReceiveTimestamp > (long)this.getKeyFrameDelayTicks()) {
                    this.__lastFirReceiveTimestamp = ticks;
                    this.__lastFirReceiveSequenceNumber = sequenceNumber;
                    frame4.getEntry().setLastSequenceNumber(sequenceNumber);
                    continue;
                }
                filterFir = true;
                continue;
            }
            if (frame instanceof SliControlFrame) {
                if (!_log.getIsVerboseEnabled()) continue;
                _log.verbose(StringExtensions.format("Received RTCP slice loss indication (SLI) for {0} stream.", this.getType().toString()));
                continue;
            }
            if (frame instanceof RpsiControlFrame) {
                if (!_log.getIsVerboseEnabled()) continue;
                _log.verbose(StringExtensions.format("Received RTCP reference picture selection indication (RPSI) for {0} stream.", this.getType().toString()));
                continue;
            }
            if (frame instanceof GenericNackControlFrame) {
                this.processGenericNack((GenericNackControlFrame)frame);
                if (_log.getIsVerboseEnabled()) {
                    _log.verbose(StringExtensions.format("Received RTCP generic NACK for {0} stream.", this.getType().toString()));
                }
                this.updateNackReceiverStatistics();
                continue;
            }
            if (!(frame instanceof RembControlFrame)) continue;
            this.processRembControlFrame((RembControlFrame)frame);
        }
        controlFrames = this.filterInboundControlFrames(controlFrames, filterPli, filterFir);
        this.raiseReceiveControlFrames(controlFrames);
    }

    @Override
    public void doReceiveFrame(TFrame frame) {
        RtpPacket packet = RtpPacket.wrap(((MediaBuffer)((MediaFrame)frame).getBuffer()).getDataBuffer());
        this.updateRtpReceiverStatistics(packet, ((MediaBuffer)((MediaFrame)frame).getBuffer()).getSequenceNumber(), ((MediaFormat)((MediaBuffer)((MediaFrame)frame).getBuffer()).getFormat()).getClockRate());
        if (this.getNackEnabled()) {
            if (this.__nextNackBufferSequenceNumber == -1L) {
                this.__nextNackBufferSequenceNumber = ((MediaBuffer)((MediaFrame)frame).getBuffer()).getSequenceNumber();
                this.__nextNackBufferRtpSequenceNumber = ((MediaBuffer)((MediaFrame)frame).getBuffer()).getRtpSequenceNumber();
            }
            if (((MediaBuffer)((MediaFrame)frame).getBuffer()).getSequenceNumber() - this.__nextNackBufferSequenceNumber > (long)this.getNackBuffer().getLength()) {
                long sequenceNumber = this.__nextNackBufferSequenceNumber;
                int rtpSequenceNumber = this.__nextNackBufferRtpSequenceNumber;
                while (rtpSequenceNumber < ((MediaBuffer)((MediaFrame)frame).getBuffer()).getRtpSequenceNumber()) {
                    this.getNackBuffer().read(sequenceNumber, rtpSequenceNumber, -1L, new IActionDelegate1<TFrame>(){

                        @Override
                        public String getId() {
                            return "fm.icelink.RtpTransport<TFrame,TBuffer,TBufferCollection,TFormat,TFormatCollection>.processReceiveFec";
                        }

                        @Override
                        public void invoke(TFrame frame) {
                            RtpTransport.this.processReceiveFec(frame);
                        }
                    }, null);
                    ++rtpSequenceNumber;
                    ++sequenceNumber;
                }
                this.__nextNackBufferSequenceNumber = ((MediaBuffer)((MediaFrame)frame).getBuffer()).getSequenceNumber();
            }
            if (!this.getNackBuffer().write(frame)) {
                this.getPacketsDiscarded().increment();
                if (_log.getIsDebugEnabled()) {
                    _log.debug("NACK buffer is discarding stale/duplicate packet for video stream.");
                }
            }
            while (this.getNackBuffer().read(this.__nextNackBufferSequenceNumber, this.__nextNackBufferRtpSequenceNumber, ((MediaFrame)frame).getTimestamp(), new IActionDelegate1<TFrame>(){

                @Override
                public String getId() {
                    return "fm.icelink.RtpTransport<TFrame,TBuffer,TBufferCollection,TFormat,TFormatCollection>.nackBufferReadFrameCallback";
                }

                @Override
                public void invoke(TFrame frame) {
                    RtpTransport.this.nackBufferReadFrameCallback(frame);
                }
            }, (IAction1<GenericNackControlFrame>)new IActionDelegate1<GenericNackControlFrame>(){

                @Override
                public String getId() {
                    return "fm.icelink.RtpTransport<TFrame,TBuffer,TBufferCollection,TFormat,TFormatCollection>.nackBufferReadNackCallback";
                }

                @Override
                public void invoke(GenericNackControlFrame nack) {
                    RtpTransport.this.nackBufferReadNackCallback(nack);
                }
            })) {
            }
            return;
        }
        this.processReceiveFec(frame);
    }

    @Override
    public void doSendControlFrames(MediaControlFrame[] controlFrames) {
        SrtpTransport<TFrame, TBuffer, TBufferCollection, TFormat, TFormatCollection> srtpTransport;
        long[] localSynchronizationSources;
        if (this.__currentLocalSynchronizationSource == 0L && (localSynchronizationSources = super.getLocalSynchronizationSources()) != null && ArrayExtensions.getLength(localSynchronizationSources) > 0) {
            this.__currentLocalSynchronizationSource = localSynchronizationSources[0];
        }
        if (ArrayExtensions.getLength(controlFrames) > 0) {
            MediaControlFrame[] sdes;
            int n;
            ArrayList<MediaControlFrame> list;
            ReportControlFrame report;
            for (MediaControlFrame frame : controlFrames) {
                long ticks;
                if (frame instanceof PliControlFrame) {
                    ticks = DateExtensions.getTicks(DateExtensions.getUtcNow());
                    if (this.__lastPliSendTimestamp != -1L && ticks - this.__lastPliSendTimestamp <= (long)this.getKeyFrameDelayTicks()) {
                        return;
                    }
                    this.__lastPliSendTimestamp = ticks;
                    this.getPlisSent().increment();
                    if (!_log.getIsDebugEnabled()) continue;
                    _log.debug(StringExtensions.format("Sending RTCP picture loss indication (PLI) for {0} stream (RTT={1}).", this.getType().toString(), IntegerExtensions.toString(this.getRoundTripTime())));
                    continue;
                }
                if (!(frame instanceof FirControlFrame)) continue;
                int sequenceNumber = ((FirControlFrame)frame).getEntry().getSequenceNumber();
                int firSequenceNumberDelta = 1;
                if (this.__lastFirSendSequenceNumber != -1) {
                    firSequenceNumberDelta = this.getFirSequenceNumberDelta(sequenceNumber, this.__lastFirSendSequenceNumber);
                }
                ticks = DateExtensions.getTicks(DateExtensions.getUtcNow());
                if (firSequenceNumberDelta <= 0 && (firSequenceNumberDelta != 0 || ticks - this.__lastFirSendTimestamp <= (long)this.getKeyFrameDelayTicks())) {
                    return;
                }
                this.__lastFirSendTimestamp = ticks;
                this.__lastFirSendSequenceNumber = sequenceNumber;
                this.getFirsSent().increment();
                if (!_log.getIsDebugEnabled()) continue;
                _log.debug(StringExtensions.format("Sending RTCP full intra refresh (FIR) for {0} stream (RTT={1}, SN={2}).", this.getType().toString(), IntegerExtensions.toString(this.getRoundTripTime()), IntegerExtensions.toString(sequenceNumber)));
            }
            if ((ArrayExtensions.getLength(controlFrames) < 1 || !(controlFrames[0] instanceof SRControlFrame) && !(controlFrames[0] instanceof RRControlFrame)) && (report = this.getReport()) != null) {
                list = new ArrayList<MediaControlFrame>();
                MediaControlFrame[] mediaControlFrameArray = controlFrames;
                n = mediaControlFrameArray.length;
                for (int frame = 0; frame < n; ++frame) {
                    MediaControlFrame frame3 = mediaControlFrameArray[frame];
                    list.add(frame3);
                }
                ArrayListExtensions.insert(list, 0, report);
                controlFrames = list.toArray(new MediaControlFrame[0]);
            }
            if (!(ArrayExtensions.getLength(controlFrames) >= 2 && controlFrames[1] instanceof SdesControlFrame || (sdes = this.getSdes()) == null)) {
                list = new ArrayList();
                MediaControlFrame[] mediaControlFrameArray = controlFrames;
                n = mediaControlFrameArray.length;
                for (int frame = 0; frame < n; ++frame) {
                    MediaControlFrame frame3 = mediaControlFrameArray[frame];
                    list.add(frame3);
                }
                ArrayListExtensions.insert(list, 1, sdes);
                controlFrames = list.toArray(new MediaControlFrame[0]);
            }
            for (MediaControlFrame frame3 : controlFrames) {
                if (frame3 instanceof SRControlFrame) {
                    this.validateSRControlFrame((SRControlFrame)frame3);
                } else if (frame3 instanceof RRControlFrame) {
                    this.validateRRControlFrame((RRControlFrame)frame3);
                } else if (frame3 instanceof SdesControlFrame) {
                    this.validateSdesControlFrame((SdesControlFrame)frame3);
                } else if (frame3 instanceof FeedbackControlFrame) {
                    this.validateFeedbackControlFrame((FeedbackControlFrame)frame3);
                } else if (frame3 instanceof ByeControlFrame) {
                    this.validateByeControlFrame((ByeControlFrame)frame3);
                } else if (frame3 instanceof AppControlFrame) {
                    this.validateAppControlFrame((AppControlFrame)frame3);
                }
                this.updateRtcpSenderStatistics(frame3);
            }
        }
        if ((srtpTransport = this.getSrtpTransport()) != null) {
            IAction1<MediaControlFrame[]> onSendControlFrames = this._onSendControlFrames;
            if (onSendControlFrames != null) {
                onSendControlFrames.invoke(controlFrames);
            }
            srtpTransport.sendControlFrames(controlFrames);
        }
    }

    @Override
    public boolean doSendFrame(TFrame frame) {
        if (ArrayExtensions.getLength(frame.getBuffers()) == 0) {
            _log.error("Frame has no buffers to send!");
        }
        for (int i = ArrayExtensions.getLength(frame.getBuffers()) - 1; i >= 0; --i) {
            MediaBuffer buffer = frame.getBuffers()[i];
            if (!((MediaFormat)buffer.getFormat()).getIsPacketized()) continue;
            if (this.prepareBufferForSend(buffer, frame)) {
                if (this.getNackEnabled()) {
                    this.getSendBuffer().write(frame);
                }
                this.processSendFec(frame);
            }
            return true;
        }
        _log.error("Frame has no packetized buffers to send. Are you missing a packetizer?");
        return false;
    }

    @Override
    public boolean doStart() {
        if (super.getParameters() == null) {
            _log.error("Cannot start RTP transport. Rtp.Parameters must be set.");
            return false;
        }
        if (this.getSrtpTransport() == null) {
            _log.error("Cannot start RTP transport. Srtp.Transport must be set.");
            return false;
        }
        this.attachTransportEvents();
        return true;
    }

    @Override
    public boolean doStop() {
        this.detachTransportEvents();
        return true;
    }

    private MediaControlFrame[] filterInboundControlFrames(MediaControlFrame[] controlFrames, boolean filterPli, boolean filterFir) {
        ArrayList<MediaControlFrame> list = new ArrayList<MediaControlFrame>();
        for (MediaControlFrame frame : controlFrames) {
            if (filterPli && frame instanceof PliControlFrame) {
                if (!_log.getIsVerboseEnabled()) continue;
                _log.verbose(StringExtensions.format("Discarding inbound PLI control frame (too frequent, RTT={0}).", IntegerExtensions.toString(this.getRoundTripTime())));
                continue;
            }
            if (filterFir && frame instanceof FirControlFrame) {
                if (!_log.getIsVerboseEnabled()) continue;
                _log.verbose(StringExtensions.format("Discarding inbound FIR control frame (too frequent, RTT={0}).", IntegerExtensions.toString(this.getRoundTripTime())));
                continue;
            }
            list.add(frame);
        }
        return list.toArray(new MediaControlFrame[0]);
    }

    StreamDirection getAbsoluteSenderTimeDirection() {
        return this.__absoluteSenderTimeDirection;
    }

    public int getAverageFrameRate() {
        if (this.__frameCount == 0L) {
            return -1;
        }
        long num = DateExtensions.getTicks(DateExtensions.getUtcNow()) - this.__startTicks;
        if (num < (long)Constants.getTicksPerSecond()) {
            return -1;
        }
        return (int)(this.__frameCount * (long)Constants.getTicksPerSecond() / num);
    }

    private CodecStats getCodecStats(boolean receiver) {
        AudioFormat format;
        int payloadType;
        int n = payloadType = receiver ? this.__currentReceivePayloadType : this.__currentSendPayloadType;
        if (payloadType == -1) {
            return null;
        }
        Object local = super.getFormat(payloadType);
        if (local == null) {
            return null;
        }
        CodecStats stats2 = new CodecStats();
        stats2.setId(super.getId());
        stats2.setTimestamp(DateExtensions.getUtcNow());
        stats2.setName(((MediaFormat)local).getName());
        stats2.setClockRate(((MediaFormat)local).getClockRate());
        stats2.setParameters(((MediaFormat)local).getParameters());
        stats2.setPayloadType(payloadType);
        CodecStats stats = stats2;
        if (Global.equals((Object)this.getType(), (Object)StreamType.Audio) && (format = Global.tryCast(local, AudioFormat.class)) != null) {
            stats.setChannelCount(format.getChannelCount());
        }
        return stats;
    }

    public StreamDirection getDirection() {
        return this.__direction;
    }

    public boolean getDisableAutomaticReports() {
        return this._disableAutomaticReports;
    }

    private long getEstimatedDownstreamBitrate() {
        return this.__estimatedDownstreamBitrate;
    }

    long getEstimatedUpstreamBitrate() {
        return this.__estimatedUpstreamBitrate;
    }

    public boolean getFecEnabled() {
        RedFecConfig redFecConfig = this.getRedFecConfig();
        return redFecConfig != null && !redFecConfig.getDisabled();
    }

    private int getFirSequenceNumberDelta(int sequenceNumber, int lastSequenceNumber) {
        int num = sequenceNumber - lastSequenceNumber;
        if (num < -128) {
            return num + 256;
        }
        if (num > 128) {
            num -= 256;
        }
        return num;
    }

    public AtomicLong getFirsReceived() {
        return this._firsReceived;
    }

    public AtomicLong getFirsSent() {
        return this._firsSent;
    }

    public int getInboundPacketsLostRtp() {
        return this._inboundPacketsLostRtp;
    }

    public JitterBuffer<TFrame, TBuffer, TBufferCollection, TFormat> getJitterBuffer() {
        return this._jitterBuffer;
    }

    public JitterConfig getJitterConfig() {
        return this._jitterConfig;
    }

    public int getKeyFrameDelayTicks() {
        if (this.getRoundTripTime() > 0) {
            return 2 * this.getRoundTripTime() * Constants.getTicksPerMillisecond();
        }
        return 1000 * Constants.getTicksPerMillisecond();
    }

    public NackBuffer<TFrame, TBuffer, TBufferCollection, TFormat> getNackBuffer() {
        return this._nackBuffer;
    }

    public NackConfig getNackConfig() {
        return this._nackConfig;
    }

    public boolean getNackEnabled() {
        NackConfig nackConfig = this.getNackConfig();
        return nackConfig != null && !nackConfig.getDisableBuffering();
    }

    public AtomicLong getNacksReceived() {
        return this._nacksReceived;
    }

    public AtomicLong getNacksSent() {
        return this._nacksSent;
    }

    private int getNextRtpSequenceNumber(LongHolder nextMediaSequenceNumber) {
        int _var0 = this.incrementRtpSequenceNumber(nextMediaSequenceNumber);
        return _var0;
    }

    private long getNextTimestamp(long frameTimestamp) {
        if (this.__baseFrameTimestamp == -1L) {
            this.__baseFrameTimestamp = frameTimestamp;
        }
        return (frameTimestamp - this.__baseFrameTimestamp + (long)this.__startTimeOffset) % 0x100000000L;
    }

    public AtomicLong getOctetsReceivedRtcp() {
        return this._octetsReceivedRtcp;
    }

    public AtomicLong getOctetsReceivedRtp() {
        return this._octetsReceivedRtp;
    }

    public AtomicLong getOctetsSentRtcp() {
        return this._octetsSentRtcp;
    }

    public AtomicLong getOctetsSentRtp() {
        return this._octetsSentRtp;
    }

    public int getOutboundPacketsLostRtp() {
        return this._outboundPacketsLostRtp;
    }

    public AtomicLong getPacketsDiscarded() {
        return this._packetsDiscarded;
    }

    public AtomicLong getPacketsReceivedRtcp() {
        return this._packetsReceivedRtcp;
    }

    public AtomicLong getPacketsReceivedRtp() {
        return this._packetsReceivedRtp;
    }

    public AtomicLong getPacketsSentRtcp() {
        return this._packetsSentRtcp;
    }

    public AtomicLong getPacketsSentRtp() {
        return this._packetsSentRtp;
    }

    public AtomicLong getPlisReceived() {
        return this._plisReceived;
    }

    public AtomicLong getPlisSent() {
        return this._plisSent;
    }

    public MediaReceiverStats getReceiverStats() {
        MediaReceiverStats stats = new MediaReceiverStats();
        stats.setId(super.getId());
        stats.setTimestamp(DateExtensions.getUtcNow());
        stats.setSynchronizationSource(this.__currentRemoteSynchronizationSource);
        stats.setCodec(this.getCodecStats(true));
        stats.setNackCount(this.getNacksReceived().getValue());
        stats.setPliCount(this.getPlisReceived().getValue());
        stats.setFirCount(this.getFirsReceived().getValue());
        stats.setBytesReceived(this.getOctetsReceivedRtp().getValue());
        stats.setPacketsReceived(this.getPacketsReceivedRtp().getValue());
        stats.setPacketsLost(this.getInboundPacketsLostRtp());
        stats.setPacketsDiscarded(this.getPacketsDiscarded().getValue());
        stats.setJitter((int)this.__receiveJitter);
        return stats;
    }

    public boolean getRedFecActivated() {
        return this._redFecActivated;
    }

    public RedFecConfig getRedFecConfig() {
        return this._redFecConfig;
    }

    private ReportControlFrame getReport() {
        ReportControlFrame frame = null;
        ReportBlock reportBlock = null;
        if (this.__maxReceivedPacketIndex > -1L) {
            reportBlock = new ReportBlock();
        }
        if (Global.equals((Object)this.getDirection(), (Object)StreamDirection.ReceiveOnly)) {
            if (_log.getIsVerboseEnabled()) {
                _log.verbose("Generating RTCP receiver report.");
            }
            if (reportBlock != null) {
                return new RRControlFrame(this.__currentRemoteSynchronizationSource, reportBlock);
            }
            return new RRControlFrame();
        }
        if (Global.equals((Object)this.getDirection(), (Object)StreamDirection.Inactive)) {
            return frame;
        }
        if (_log.getIsVerboseEnabled()) {
            _log.verbose("Generating RTCP sender report.");
        }
        if (reportBlock != null) {
            return new SRControlFrame(this.__currentLocalSynchronizationSource, 0L, 0L, 0L, 0L, reportBlock);
        }
        return new SRControlFrame();
    }

    public int getRoundTripTime() {
        int smoothedRoundTripTime;
        IceTransport rtpTransport;
        if (this.getSrtpTransport() != null && (rtpTransport = (IceTransport)this.getSrtpTransport().getRtpTransport()) != null && (smoothedRoundTripTime = rtpTransport.getSmoothedRoundTripTime()) > -1) {
            return smoothedRoundTripTime;
        }
        return this.__roundTripTimeRR;
    }

    RtpHeaderExtensionRegistry getRtpHeaderExtensionRegistry() {
        return this._rtpHeaderExtensionRegistry;
    }

    private SdesControlFrame getSdes() {
        return new SdesControlFrame(new SdesChunk(this.__currentLocalSynchronizationSource, new SdesItem(SdesItemType.getCanonicalName(), super.getParameters().getCanonicalName())));
    }

    public RtpSendBuffer<TFrame, TBuffer, TBufferCollection, TFormat> getSendBuffer() {
        return this._sendBuffer;
    }

    public MediaSenderStats getSenderStats() {
        MediaSenderStats stats = new MediaSenderStats();
        stats.setId(super.getId());
        stats.setTimestamp(DateExtensions.getUtcNow());
        stats.setSynchronizationSource(this.__currentLocalSynchronizationSource);
        stats.setCodec(this.getCodecStats(false));
        stats.setNackCount(this.getNacksSent().getValue());
        stats.setPliCount(this.getPlisSent().getValue());
        stats.setFirCount(this.getFirsSent().getValue());
        stats.setBytesSent(this.getOctetsSentRtp().getValue());
        stats.setPacketsSent(this.getPacketsSentRtp().getValue());
        stats.setRoundTripTime(this.getRoundTripTime());
        return stats;
    }

    public SrtpTransport<TFrame, TBuffer, TBufferCollection, TFormat, TFormatCollection> getSrtpTransport() {
        return this._srtpTransport;
    }

    public StreamType getType() {
        return this._type;
    }

    private int incrementFecSequenceNumber() {
        int num = this.__currentFecSequenceNumber++;
        if (this.__currentFecSequenceNumber == 65536) {
            this.__currentFecSequenceNumber = 0;
        }
        return num;
    }

    private int incrementRtpSequenceNumber(LongHolder nextMediaSequenceNumber) {
        nextMediaSequenceNumber.setValue(this.__currentMediaSequenceNumber++);
        int num = this.__currentRtpSequenceNumber++;
        if (this.__currentRtpSequenceNumber == 65536) {
            this.__currentRtpSequenceNumber = 0;
        }
        return num;
    }

    private void logBitrateParameters(long currentTime, long duration, double currentUpstreamPacketLoss, double currentDownstreamPacketLoss, boolean logOutgoing, boolean logIncoming) {
        String str = LongExtensions.toString(currentTime);
        String str2 = LongExtensions.toString(duration);
        String str3 = LongExtensions.toString(this.getEstimatedUpstreamBitrate());
        String str4 = LongExtensions.toString(this.__actualLatestUpstreamBitRate);
        String str5 = LongExtensions.toString(this.getEstimatedDownstreamBitrate());
        String str6 = LongExtensions.toString(this.__actualLatestDownstreamBitRate);
        String str7 = DoubleExtensions.toString(currentUpstreamPacketLoss);
        String str8 = DoubleExtensions.toString(currentDownstreamPacketLoss);
        if (_log.getIsVerboseEnabled()) {
            if (logOutgoing) {
                _log.verbose(StringExtensions.format("RTP Transport: Calculating upstream bitrate stats at {0}. Time interval: {1} ms, previous upstream bitrate estimate: {2} bps, actual upstream bitrate over the time interval: {3} bps, current packet loss ratio on upstream: {4}", new Object[]{str, str2, str3, str4, str7}));
            }
            if (logIncoming) {
                _log.verbose(StringExtensions.format("RTP Transport: Calculating downstream bitrate stats at {0}. Time interval: {1} ms, previous downstream bitrate estimate: {2} bps, actual downstream bitrate over the time interval: {3} bps, current packet loss ratio on downstream: {4}", new Object[]{str, str2, str5, str6, str8}));
            }
        }
    }

    private void nackBufferReadFrameCallback(TFrame frame) {
        this.__nextNackBufferSequenceNumber = ((MediaBuffer)((MediaFrame)frame).getBuffer()).getSequenceNumber() + 1L;
        this.__nextNackBufferRtpSequenceNumber = (((MediaBuffer)((MediaFrame)frame).getBuffer()).getRtpSequenceNumber() + 1) % 65536;
        this.processReceiveFec(frame);
    }

    private void nackBufferReadNackCallback(GenericNackControlFrame nack) {
        super.sendControlFrames(new MediaControlFrame[]{nack});
        if (_log.getIsDebugEnabled()) {
            this.updateNackSenderStatistics();
        }
    }

    private boolean prepareBufferForSend(TBuffer buffer, TFrame frame) {
        if (((MediaFrame)frame).getSynchronizationSource() == -1L) {
            _log.error("RTP Transport cannot process frame. SynchronizationSource not set.");
            return false;
        }
        ((MediaBuffer)buffer).setSequenceNumbers(new long[ArrayExtensions.getLength(((MediaBuffer)buffer).getDataBuffers())]);
        for (int i = 0; i < ArrayExtensions.getLength(((MediaBuffer)buffer).getDataBuffers()); ++i) {
            RtpPacket rtpPacket = RtpPacket.wrap(((MediaBuffer)buffer).getDataBuffers()[i]);
            if (Global.equals((Object)this.getAbsoluteSenderTimeDirection(), (Object)StreamDirection.SendOnly) || Global.equals((Object)this.getAbsoluteSenderTimeDirection(), (Object)StreamDirection.SendReceive)) {
                rtpPacket.setAbsSendTime(this.getRtpHeaderExtensionRegistry());
            }
            if (this.__currentLocalSynchronizationSource == 0L) {
                this.__currentLocalSynchronizationSource = ((MediaFrame)frame).getSynchronizationSource();
            }
            if (!this.__videoBridgeMode) {
                long nextMediaSequenceNumber = 0L;
                LongHolder _var0 = new LongHolder(nextMediaSequenceNumber);
                int _var1 = this.getNextRtpSequenceNumber(_var0);
                nextMediaSequenceNumber = _var0.getValue();
                rtpPacket.setSequenceNumber(_var1);
                ((MediaBuffer)buffer).getSequenceNumbers()[i] = nextMediaSequenceNumber;
                rtpPacket.setTimestamp(this.getNextTimestamp(((MediaFrame)frame).getTimestamp()));
            }
            rtpPacket.setSynchronizationSource(this.__currentLocalSynchronizationSource);
            rtpPacket.setContributingSources(((MediaFrame)frame).getContributingSources());
            int payloadType = super.getPayloadType(((MediaFormat)((MediaBuffer)buffer).getFormat()).getName());
            if (payloadType == -1) {
                _log.error("RTP Transport cannot process frame. No matching payload types found.");
                return false;
            }
            rtpPacket.setPayloadType(payloadType);
            this.updateRtpSenderStatistics(rtpPacket);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processBandwidthStats(ScheduledItem item) {
        Object object = this.__lock;
        synchronized (object) {
            this._processBandwidthStatsSI.setSuspended(true);
            long currentTime = Scheduler.getCurrentTime();
            long duration = currentTime - this.__lastBWStatsCollectionStartTimestamp;
            boolean logOutgoing = true;
            boolean logIncoming = true;
            if (duration < 0L) {
                throw new RuntimeException(new Exception(StringExtensions.format("RTP Transport: unexpected duration for bandwidth estimation. Current time: {0}, last estimate time: {1}, duration: {2}", LongExtensions.toString(currentTime), LongExtensions.toString(this.__lastBWStatsCollectionStartTimestamp), LongExtensions.toString(duration))));
            }
            long num3 = (this.getOctetsSentRtp().getValue() - this.__octotetsSentOnLastBWStatsCollectionStart) * 8L;
            if (num3 > 0L) {
                long num4;
                this.__actualLatestUpstreamBitRate = num4 = 1000L * num3 / duration;
            } else {
                if (num3 < 0L) {
                    throw new RuntimeException(new Exception(StringExtensions.format("RTP Transport: unexpected number of bytes sent. Octets sent: {0}, last octets sent: {1}, bytesSent: {2}", this.getOctetsSentRtp().toString(), LongExtensions.toString(this.__octotetsSentOnLastBWStatsCollectionStart), LongExtensions.toString(num3))));
                }
                logOutgoing = false;
            }
            long num5 = (this.getOctetsReceivedRtp().getValue() - this.__octotetsReceivedOnLastBWStatsCollectionStart) * 8L;
            if (num5 > 0L) {
                long num6;
                this.__actualLatestDownstreamBitRate = num6 = 1000L * num5 / duration;
            } else {
                if (num5 < 0L) {
                    throw new RuntimeException(new Exception(StringExtensions.format("RTP Transport: unexpected number of bytes received. Octets received: {0}, last octets received: {1}, bytesRecv: {2}", this.getOctetsSentRtp().toString(), LongExtensions.toString(this.__octotetsSentOnLastBWStatsCollectionStart), LongExtensions.toString(num3))));
                }
                logIncoming = false;
            }
            double lossRatio = this.__smoothedUplinkPacketLoss < 0.0 ? 0.0 : this.__smoothedUplinkPacketLoss;
            double num8 = this.__smoothedDownlinkPacketLoss < 0.0 ? 0.0 : this.__smoothedDownlinkPacketLoss;
            long calculatedBR = this.__actualLatestDownstreamBitRate;
            long num10 = this.__actualLatestUpstreamBitRate;
            if (this.getEstimatedUpstreamBitrate() <= 0L && logOutgoing) {
                this.setEstimatedUpstreamBitrate(num10);
            }
            if (this.getEstimatedDownstreamBitrate() <= 0L && logIncoming) {
                this.setEstimatedDownstreamBitrate(calculatedBR);
            }
            if (logOutgoing) {
                num10 = this.updateBR(num10, this.getEstimatedUpstreamBitrate(), lossRatio);
            }
            if (logIncoming) {
                calculatedBR = this.updateBR(calculatedBR, this.getEstimatedDownstreamBitrate(), num8);
            }
            long num11 = num10;
            if (this.__smoothedUplinkBandwidthFromRemoteRemb > 0L) {
                if (num11 <= 0L || this.__smoothedUplinkBandwidthFromRemoteRemb < num11) {
                    num11 = this.__smoothedUplinkBandwidthFromRemoteRemb;
                }
                logOutgoing = true;
            }
            this.logBitrateParameters(currentTime, duration, lossRatio, num8, logOutgoing, logIncoming);
            if (logIncoming) {
                this.setEstimatedDownstreamBitrate(calculatedBR);
            }
            if (logOutgoing) {
                this.setEstimatedUpstreamBitrate(num11);
            }
            this.resetBWStats();
            this._startCollectingBWStatsSI.setSuspended(false);
        }
    }

    private void processGenericNack(GenericNackControlFrame genericNack) {
        for (GenericNack nack : genericNack.getGenericNacks()) {
            if (this.resendRtpPacket(nack.getPacketId())) {
                // empty if block
            }
            int packetId = nack.getPacketId();
            for (int i = 1; i <= nack.getLostPacketIdPlusLength(); ++i) {
                if (nack.getLostPacketIdPlus(i) && !this.resendRtpPacket((packetId + i) % 65536)) continue;
            }
        }
    }

    private void processJitterBuffer(TFrame frame) {
        if (this.getJitterConfig().getDisableBuffering()) {
            this.raiseReceiveFrame(frame);
        } else {
            if (this.getJitterBuffer() == null) {
                RtpPacket packet = RtpPacket.wrap(((MediaBuffer)((MediaFrame)frame).getBuffer()).getDataBuffer());
                this.setJitterBuffer(new JitterBuffer(this.getType().toString(), ((MediaFormat)super.getFormat(packet.getPayloadType())).getClockRate(), this.getJitterConfig().getBufferLength()));
            }
            if (!this.getJitterBuffer().push(frame)) {
                this.getPacketsDiscarded().increment();
                if (_log.getIsDebugEnabled()) {
                    _log.debug("Jitter buffer is discarding late packet for stream.");
                }
            }
            this.getJitterBuffer().pull(new IActionDelegate1<TFrame>(){

                @Override
                public String getId() {
                    return "fm.icelink.MediaTransport<TFrame,TBuffer,TBufferCollection,TFormat,TFormatCollection>.raiseReceiveFrame";
                }

                @Override
                public void invoke(TFrame frame) {
                    RtpTransport.this.raiseReceiveFrame(frame);
                }
            });
        }
    }

    private void processReceiveFec(TFrame frame) {
        if (!this.getFecEnabled()) {
            this.processJitterBuffer(frame);
        } else if (Global.equals(((MediaFormat)((MediaBuffer)((MediaFrame)frame).getBuffer()).getFormat()).getName(), MediaFormat.getRedName())) {
            RtpPacket packet;
            if (this._fecReceiver == null) {
                this._fecReceiver = new FecReceiver();
            }
            if (this._fecReceiver.addReceivedRedPacket((packet = RtpPacket.wrap(((MediaBuffer)((MediaFrame)frame).getBuffer()).getDataBuffer())).getHeaderLength(), packet.getSequenceNumber(), ((MediaBuffer)((MediaFrame)frame).getLastBuffer()).getDataBuffer(), ((MediaBuffer)((MediaFrame)frame).getLastBuffer()).getDataBuffer().getLength(), super.getPayloadType(MediaFormat.getUlpFecName()))) {
                this.__fecBuffer.clear();
                if (!this._fecReceiver.processReceivedFec(this.__fecBuffer)) {
                    // empty if block
                }
                LinkedListEnumerator<DataBuffer> enumerator = this.__fecBuffer.getEnumerator();
                while (enumerator.moveNext()) {
                    RtpPacket packet2 = RtpPacket.wrap(enumerator.getCurrent());
                    Object format = super.getFormat(packet2.getPayloadType());
                    if (format == null) {
                        _log.warn(StringExtensions.format("Unknown packet type of {0} received from Fec.", IntegerExtensions.toString(packet2.getPayloadType())));
                        continue;
                    }
                    TFrame local2 = this.getSrtpTransport().generateFrame(packet2, format);
                    if (local2 == null) continue;
                    this.processJitterBuffer(local2);
                }
            }
        } else {
            this.processJitterBuffer(frame);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRembControlFrame(RembControlFrame frame) {
        if (_log.getIsVerboseEnabled()) {
            _log.verbose(StringExtensions.format("RTP Transport: Received {0}", frame.toString()));
        }
        Object object = this.__lock;
        synchronized (object) {
            if (!this.__ignoreStats) {
                long bitrate = frame.getBitrate();
                this.__smoothedUplinkBandwidthFromRemoteRemb = this.__smoothedUplinkBandwidthFromRemoteRemb <= 0L ? bitrate : (long)((float)bitrate * __smoothingFactor) + this.__smoothedUplinkBandwidthFromRemoteRemb * (1L - bitrate);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processReportBlock(ReportBlock block) {
        ++this.__reportsReceived;
        if (block.getLastSenderReportTimestamp() > 0L) {
            long ticks;
            long num7;
            long num = DateExtensions.getTicks(NetworkTimeProtocol.compactNtpToDateTime(block.getLastSenderReportTimestamp())) / (long)Constants.getTicksPerMillisecond();
            long num2 = block.getDelaySinceLastSenderReport() * 1000L / 65536L;
            long num3 = DateExtensions.getTicks(NetworkTimeProtocol.compactNtpToDateTime(NetworkTimeProtocol.dateTimeToCompactNtp(DateExtensions.getUtcNow()))) / (long)Constants.getTicksPerMillisecond();
            long num4 = num3 - num - num2;
            this.__roundTripTimeRR = this.__roundTripTimeRR == -1 ? (int)num4 : (int)(__roundTripTimeAlpha * (double)this.__roundTripTimeRR + (1.0 - __roundTripTimeAlpha) * (double)num4);
            Object object = this.__lock;
            synchronized (object) {
                if (!this.__ignoreStats) {
                    double percentLost = block.getPercentLost();
                    this.updateLossBasedEstimatedAvailableBandwidth(percentLost, true);
                }
            }
            if (this.getNackEnabled()) {
                this.getNackBuffer().setRetransmissionTimeout(this.getRoundTripTime());
            }
            if ((num7 = ((ticks = DateExtensions.getTicks(DateExtensions.getUtcNow())) - this.__lastNackNetworkConditionReportTicks) / (long)Constants.getTicksPerMillisecond()) > (long)this.__nackNetworkConditionReportingInterval) {
                if (this.getRoundTripTime() > this.__roundTripTimeCriticalWarning) {
                    _log.warn(StringExtensions.format("Critical network condition detected! Round trip time exceeding {0}ms.", IntegerExtensions.toString(this.getRoundTripTime())));
                } else if (this.getRoundTripTime() > this.__roundTripTimePoorWarning) {
                    _log.warn(StringExtensions.format("Poor network condition detected! Round trip time exceeding {0}ms.", IntegerExtensions.toString(this.getRoundTripTime())));
                }
                this.__lastNackNetworkConditionReportTicks = ticks;
            }
        }
        if (this.__reportsReceived > this.getRedFecConfig().getMinimumReportsBeforeFec() && this.getFecEnabled()) {
            if (!this.getRedFecActivated() && block.getPercentLost() * 100.0 >= (double)this.getRedFecConfig().getActivationThreshold()) {
                _log.info(StringExtensions.format("Activating FEC for RTP Transport '{0}'.", super.getId()));
                this.setRedFecActivated(true);
            }
            if (this.getRedFecActivated() && block.getPercentLost() * 100.0 < (double)this.getRedFecConfig().getActivationThreshold()) {
                _log.info(StringExtensions.format("Deactivating FEC for RTP Transport '{0}'.", super.getId()));
                this.setRedFecActivated(false);
            }
        }
        this.setOutboundPacketsLostRtp(block.getCumulativeNumberOfPacketsLost());
    }

    private void processSendFec(TFrame frame) {
        SrtpTransport<Object, TBuffer, TBufferCollection, TFormat, TFormatCollection> srtpTransport = this.getSrtpTransport();
        if (srtpTransport != null) {
            FecRedPacket packet2;
            RtpPacket packet = null;
            if (this.getRedFecActivated()) {
                if (this._fecProducer == null) {
                    this._fecProducer = new FecProducer(new FecContext());
                }
                Object lastBuffer = ((MediaFrame)frame).getLastBuffer();
                Object local2 = ((MediaBuffer)((MediaFrame)frame).getLastBuffer()).clone();
                ((MediaBuffer)local2).setDataBuffers(new DataBuffer[ArrayExtensions.getLength(((MediaBuffer)lastBuffer).getDataBuffers())]);
                for (int i = 0; i < ArrayExtensions.getLength(((MediaBuffer)lastBuffer).getDataBuffers()); ++i) {
                    DataBuffer buffer = ((MediaBuffer)lastBuffer).getDataBuffers()[i];
                    packet = RtpPacket.wrap(buffer);
                    packet2 = this._fecProducer.buildRedPacket(buffer, buffer.getLength() - packet.getHeaderLength(), packet.getHeaderLength(), super.getPayloadType(MediaFormat.getRedName()));
                    ((MediaBuffer)local2).getDataBuffers()[i] = packet2.getData();
                    if (this._fecProducer.addRtpPacketAndGenerateFec(buffer, buffer.getLength() - packet.getHeaderLength(), packet.getHeaderLength())) continue;
                    _log.warn("Could not add RTP packet to outbound FEC context.");
                    return;
                }
                ((MediaBuffer)local2).setFormat(super.getFormat(MediaFormat.getRedName()));
                ((MediaFrame)frame).addBuffer((Object)local2);
            }
            srtpTransport.sendFrame(frame);
            while (this.getRedFecActivated() && this._fecProducer != null && this._fecProducer.getFecAvailable()) {
                long nextMediaSequenceNumber = 0L;
                LongHolder _var0 = new LongHolder(nextMediaSequenceNumber);
                int _var1 = this.getNextRtpSequenceNumber(_var0);
                nextMediaSequenceNumber = _var0.getValue();
                packet2 = this._fecProducer.getFecPacket(super.getPayloadType(MediaFormat.getRedName()), super.getPayloadType(MediaFormat.getUlpFecName()), _var1, packet.getHeaderLength());
                Object local3 = ((MediaFrame)frame).clone();
                ((MediaFrame)local3).removeBuffers();
                Object local4 = ((MediaBuffer)((MediaFrame)frame).getLastBuffer()).clone();
                ((MediaBuffer)local4).setFormat(super.getFormat(MediaFormat.getRedName()));
                ((MediaBuffer)local4).setDataBuffer(packet2.getData().subset(0, packet2.getLength()));
                ((MediaBuffer)local4).setSequenceNumber(nextMediaSequenceNumber);
                ((MediaFrame)local3).addBuffer(local4);
                srtpTransport.sendFrame(local3);
                ((MediaBuffer)local4).getDataBuffer().free();
            }
        }
    }

    public void removeOnSendControlFrames(IAction1<MediaControlFrame[]> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onSendControlFrames, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onSendControlFrames.remove(value);
        if (this.__onSendControlFrames.size() == 0) {
            this._onSendControlFrames = null;
        }
    }

    public boolean resendRtpPacket(int sequenceNumber) {
        TFrame local;
        if (this.getNackEnabled() && (local = this.getSendBuffer().read(sequenceNumber)) != null) {
            for (int i = ArrayExtensions.getLength(local.getBuffers()) - 1; i > 0; --i) {
                MediaBuffer local2 = local.getBuffers()[ArrayExtensions.getLength(local.getBuffers()) - 1];
                if (!((MediaFormat)local2.getFormat()).getIsPacketized()) continue;
                for (DataBuffer buffer : local2.getDataBuffers()) {
                    RtpPacket packet = RtpPacket.wrap(buffer);
                    if (packet.getSequenceNumber() != sequenceNumber) continue;
                    if (((MediaFormat)local2.getFormat()).getIsEncrypted()) {
                        IceTransport rtpTransport = (IceTransport)this.getSrtpTransport().getRtpTransport();
                        if (!(rtpTransport == null || Global.equals((Object)rtpTransport.getState(), (Object)IceTransportState.New) && Global.equals((Object)rtpTransport.getState(), (Object)IceTransportState.Disconnected) && Global.equals((Object)rtpTransport.getState(), (Object)IceTransportState.Closed))) {
                            if (Global.equals((Object)this.getAbsoluteSenderTimeDirection(), (Object)StreamDirection.SendOnly) || Global.equals((Object)this.getAbsoluteSenderTimeDirection(), (Object)StreamDirection.SendReceive)) {
                                packet.setAbsSendTime(this.getRtpHeaderExtensionRegistry());
                            }
                            rtpTransport.send(packet.getBuffer());
                        }
                    } else {
                        Object frame = ((MediaFrame)local).clone();
                        if (ArrayExtensions.getLength(frame.getBuffers()) > 1) {
                            ((MediaFrame)frame).setBuffer(local2.clone());
                        }
                        if (ArrayExtensions.getLength(((MediaBuffer)((MediaFrame)frame).getBuffer()).getDataBuffers()) > 1) {
                            ((MediaBuffer)((MediaFrame)frame).getBuffer()).setDataBuffer(buffer);
                        }
                        this.getSrtpTransport().sendFrame(frame);
                    }
                    return true;
                }
                break;
            }
        }
        return false;
    }

    private void resetBWStats() {
        if (_log.getIsVerboseEnabled()) {
            _log.verbose(StringExtensions.format("RTP Transport: Pausing bandwidth stats collection at {0}", LongExtensions.toString(Scheduler.getCurrentTime())));
        }
        this.__smoothedDownlinkPacketLoss = -1.0;
        this.__actualLatestDownstreamBitRate = -1L;
        this.__smoothedUplinkPacketLoss = -1.0;
        this.__actualLatestUpstreamBitRate = -1L;
        this.__smoothedUplinkBandwidthFromRemoteRemb = -1L;
        this.__ignoreStats = true;
    }

    public RtpTransport(Object lockObject, StreamType streamType, NackConfig nackConfig, RedFecConfig redFecConfig, JitterConfig jitterConfig, boolean disableAutomaticReports) {
        super(lockObject);
        this.__absoluteSenderTimeDirection = StreamDirection.Unset;
        this.__direction = StreamDirection.Inactive;
        this.__reportIntervalInTicks = Constants.getTicksPerSecond();
        this.__sentCountsLock = new Object();
        this.__receiveCountsLock = new Object();
        this.__startTimeOffset = LockedRandomizer.next(65535, Integer.MAX_VALUE);
        this.__currentRtpSequenceNumber = LockedRandomizer.next(64512) + 512;
        this.__currentFecSequenceNumber = LockedRandomizer.next(64512) + 512;
        this.__fecBuffer = new LinkedList();
        this.setType(streamType);
        this.setNackConfig(nackConfig);
        this.setRedFecConfig(redFecConfig);
        this.setJitterConfig(jitterConfig);
        this.setOctetsSentRtp(new AtomicLong());
        this.setPacketsSentRtp(new AtomicLong());
        this.setOctetsSentRtcp(new AtomicLong());
        this.setPacketsSentRtcp(new AtomicLong());
        this.setOctetsReceivedRtp(new AtomicLong());
        this.setPacketsReceivedRtp(new AtomicLong());
        this.setOctetsReceivedRtcp(new AtomicLong());
        this.setPacketsReceivedRtcp(new AtomicLong());
        this.setNacksSent(new AtomicLong());
        this.setNacksReceived(new AtomicLong());
        this.setPlisSent(new AtomicLong());
        this.setPlisReceived(new AtomicLong());
        this.setFirsSent(new AtomicLong());
        this.setFirsReceived(new AtomicLong());
        this.setPacketsDiscarded(new AtomicLong());
        if (!nackConfig.getDisableBuffering()) {
            this.setSendBuffer(new RtpSendBuffer(this.getType().toString(), this.getNackConfig().getSendBufferLength(), (IFunction1<Integer, TFrame[]>)new IFunctionDelegate1<Integer, TFrame[]>(){

                @Override
                public String getId() {
                    return "fm.icelink.RtpTransport<TFrame,TBuffer,TBufferCollection,TFormat,TFormatCollection>.createFormatArray";
                }

                @Override
                public TFrame[] invoke(Integer size) {
                    return RtpTransport.this.createFormatArray(size);
                }
            }));
            this.setNackBuffer(new NackBuffer(this.getType().toString(), this.getNackConfig().getReceiveBufferLength(), (IFunction1<Integer, TFrame[]>)new IFunctionDelegate1<Integer, TFrame[]>(){

                @Override
                public String getId() {
                    return "fm.icelink.RtpTransport<TFrame,TBuffer,TBufferCollection,TFormat,TFormatCollection>.createFormatArray";
                }

                @Override
                public TFrame[] invoke(Integer size) {
                    return RtpTransport.this.createFormatArray(size);
                }
            }));
        }
        if (Global.equals((Object)streamType, (Object)StreamType.Video)) {
            this._dispatchRembSI = new ScheduledItem((IAction1<ScheduledItem>)new IActionDelegate1<ScheduledItem>(){

                @Override
                public String getId() {
                    return "fm.icelink.RtpTransport<TFrame,TBuffer,TBufferCollection,TFormat,TFormatCollection>.sendRemb";
                }

                @Override
                public void invoke(ScheduledItem item) {
                    RtpTransport.this.sendRemb(item);
                }
            }, 1000, 1000, ScheduledItem.getUnset(), ScheduledItem.getUnset());
        }
        this._startCollectingBWStatsSI = new ScheduledItem((IAction1<ScheduledItem>)new IActionDelegate1<ScheduledItem>(){

            @Override
            public String getId() {
                return "fm.icelink.RtpTransport<TFrame,TBuffer,TBufferCollection,TFormat,TFormatCollection>.startCollectingBWStats";
            }

            @Override
            public void invoke(ScheduledItem item) {
                RtpTransport.this.startCollectingBWStats(item);
            }
        }, this.__delayToStartCollectingBWData, this.__delayToStartCollectingBWData, ScheduledItem.getUnset(), ScheduledItem.getUnset());
        ScheduledItem item = new ScheduledItem((IAction1<ScheduledItem>)new IActionDelegate1<ScheduledItem>(){

            @Override
            public String getId() {
                return "fm.icelink.RtpTransport<TFrame,TBuffer,TBufferCollection,TFormat,TFormatCollection>.processBandwidthStats";
            }

            @Override
            public void invoke(ScheduledItem item) {
                RtpTransport.this.processBandwidthStats(item);
            }
        }, this.__durationOfBWDataCollection, this.__durationOfBWDataCollection, ScheduledItem.getUnset(), ScheduledItem.getUnset());
        item.setSuspended(true);
        this._processBandwidthStatsSI = item;
    }

    private void sendBye(String reason) {
        super.sendControlFrames(new MediaControlFrame[]{this.getReport(), new ByeControlFrame(this.__currentLocalSynchronizationSource, reason)});
    }

    private void sendRemb(ScheduledItem item) {
        long[] remoteSynchronizationSources = super.getRemoteSynchronizationSources();
        long estimatedDownstreamBitrate = this.getEstimatedDownstreamBitrate();
        if (estimatedDownstreamBitrate > 0L) {
            RembControlFrame frame = new RembControlFrame(estimatedDownstreamBitrate, remoteSynchronizationSources);
            if (_log.getIsVerboseEnabled()) {
                _log.verbose(StringExtensions.format("RTP Transport: Dispatching {0}", frame.toString()));
            }
            super.sendControlFrames(new MediaControlFrame[]{frame});
        }
    }

    private void sendReport() {
        try {
            if (!this.getDisableAutomaticReports()) {
                super.sendControlFrames(new MediaControlFrame[]{this.getReport()});
            }
        }
        catch (Exception exception) {
            _log.debug("Could not send RTCP report.", exception);
        }
    }

    private void sendReportIfNeeded() {
        if (this.__lastReportSent == -1L) {
            this.__lastReportSent = DateExtensions.getTicks(DateExtensions.getUtcNow());
        } else {
            long ticks = DateExtensions.getTicks(DateExtensions.getUtcNow());
            if (ticks - this.__lastReportSent > (long)this.__reportIntervalInTicks) {
                boolean flag = false;
                if (ticks - this.__lastReportSent > (long)this.__reportIntervalInTicks) {
                    flag = true;
                    this.__lastReportSent = ticks;
                }
                if (flag) {
                    this.sendReport();
                }
            }
        }
    }

    void setAbsoluteSenderTimeDirection(StreamDirection value) {
        this.__absoluteSenderTimeDirection = value;
    }

    public void setDirection(StreamDirection value) {
        this.__direction = value;
    }

    public void setDisableAutomaticReports(boolean value) {
        this._disableAutomaticReports = value;
    }

    private void setEstimatedDownstreamBitrate(long value) {
        this.__estimatedDownstreamBitrate = value;
        if (_log.getIsVerboseEnabled()) {
            float num = (float)this.__estimatedDownstreamBitrate / 1048576.0f;
            _log.verbose(StringExtensions.format("RTP Transport: Setting estimated downstream bitrate to {0} mbps.", FloatExtensions.toString(Float.valueOf(num))));
        }
    }

    private void setEstimatedUpstreamBitrate(long value) {
        this.__estimatedUpstreamBitrate = value;
        if (_log.getIsVerboseEnabled()) {
            float num = (float)this.__estimatedUpstreamBitrate / 1048576.0f;
            _log.verbose(StringExtensions.format("RTP Transport: Setting estimated upstream bitrate to {0} mbps.", FloatExtensions.toString(Float.valueOf(num))));
        }
    }

    private void setFirsReceived(AtomicLong value) {
        this._firsReceived = value;
    }

    private void setFirsSent(AtomicLong value) {
        this._firsSent = value;
    }

    private void setInboundPacketsLostRtp(int value) {
        this._inboundPacketsLostRtp = value;
    }

    private void setJitterBuffer(JitterBuffer<TFrame, TBuffer, TBufferCollection, TFormat> value) {
        this._jitterBuffer = value;
    }

    private void setJitterConfig(JitterConfig value) {
        this._jitterConfig = value;
    }

    private void setNackBuffer(NackBuffer<TFrame, TBuffer, TBufferCollection, TFormat> value) {
        this._nackBuffer = value;
    }

    private void setNackConfig(NackConfig value) {
        this._nackConfig = value;
    }

    private void setNacksReceived(AtomicLong value) {
        this._nacksReceived = value;
    }

    private void setNacksSent(AtomicLong value) {
        this._nacksSent = value;
    }

    private void setOctetsReceivedRtcp(AtomicLong value) {
        this._octetsReceivedRtcp = value;
    }

    private void setOctetsReceivedRtp(AtomicLong value) {
        this._octetsReceivedRtp = value;
    }

    private void setOctetsSentRtcp(AtomicLong value) {
        this._octetsSentRtcp = value;
    }

    private void setOctetsSentRtp(AtomicLong value) {
        this._octetsSentRtp = value;
    }

    private void setOutboundPacketsLostRtp(int value) {
        this._outboundPacketsLostRtp = value;
    }

    private void setPacketsDiscarded(AtomicLong value) {
        this._packetsDiscarded = value;
    }

    private void setPacketsReceivedRtcp(AtomicLong value) {
        this._packetsReceivedRtcp = value;
    }

    private void setPacketsReceivedRtp(AtomicLong value) {
        this._packetsReceivedRtp = value;
    }

    private void setPacketsSentRtcp(AtomicLong value) {
        this._packetsSentRtcp = value;
    }

    private void setPacketsSentRtp(AtomicLong value) {
        this._packetsSentRtp = value;
    }

    private void setPlisReceived(AtomicLong value) {
        this._plisReceived = value;
    }

    private void setPlisSent(AtomicLong value) {
        this._plisSent = value;
    }

    private void setRedFecActivated(boolean value) {
        this._redFecActivated = value;
    }

    private void setRedFecConfig(RedFecConfig value) {
        this._redFecConfig = value;
    }

    void setRtpHeaderExtensionRegistry(RtpHeaderExtensionRegistry value) {
        this._rtpHeaderExtensionRegistry = value;
    }

    private void setSendBuffer(RtpSendBuffer<TFrame, TBuffer, TBufferCollection, TFormat> value) {
        this._sendBuffer = value;
    }

    public void setSrtpTransport(SrtpTransport<TFrame, TBuffer, TBufferCollection, TFormat, TFormatCollection> value) {
        this._srtpTransport = value;
    }

    private void setType(StreamType value) {
        this._type = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startCollectingBWStats(ScheduledItem item) {
        Object object = this.__lock;
        synchronized (object) {
            this.__lastBWStatsCollectionStartTimestamp = Scheduler.getCurrentTime();
            if (_log.getIsVerboseEnabled()) {
                _log.verbose(StringExtensions.format("RTP Transport: Resuming bandwidth stats collection at {0}", LongExtensions.toString(this.__lastBWStatsCollectionStartTimestamp)));
            }
            this._startCollectingBWStatsSI.setSuspended(true);
            this.__octotetsSentOnLastBWStatsCollectionStart = this.getOctetsSentRtp().getValue();
            this.__octotetsReceivedOnLastBWStatsCollectionStart = this.getOctetsReceivedRtp().getValue();
            this._processBandwidthStatsSI.setSuspended(false);
            this.__ignoreStats = false;
        }
    }

    private long updateBR(long calculatedBR, long previousBREstimate, double lossRatio) {
        double num = -1.0;
        if (lossRatio == 0.0) {
            lossRatio = 1.0E-6;
        }
        num = lossRatio < 0.01 ? 1.05 * (double)previousBREstimate : (lossRatio >= 0.01 && lossRatio <= 0.05 ? (double)previousBREstimate : (1.0 - 0.5 * lossRatio) * (double)calculatedBR);
        return (long)num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLossBasedEstimatedAvailableBandwidth(double lossRatio, boolean local) {
        Object object = this.__lock;
        synchronized (object) {
            if (local) {
                this.__smoothedUplinkPacketLoss = this.__smoothedUplinkPacketLoss < 0.0 ? lossRatio : this.__smoothedUplinkPacketLoss * (double)(1.0f - __smoothingFactor) + lossRatio * (double)__smoothingFactor;
            } else {
                this.__smoothedDownlinkPacketLoss = this.__smoothedDownlinkPacketLoss < 0.0 ? lossRatio : this.__smoothedDownlinkPacketLoss * (double)(1.0f - __smoothingFactor) + lossRatio * (double)__smoothingFactor;
            }
        }
    }

    private void updateNackReceiverStatistics() {
        long num3;
        long ticks;
        long num2;
        ++this.__nacksReceivedDuringInterval;
        ++this.__nacksReceivedDuringNetworkConditionInterval;
        this.getNacksReceived().increment();
        if (this.__lastNackReportTicks == -1L) {
            this.__lastNackReportTicks = DateExtensions.getTicks(DateExtensions.getUtcNow());
        }
        if ((num2 = ((ticks = DateExtensions.getTicks(DateExtensions.getUtcNow())) - this.__lastNackReportTicks) / (long)Constants.getTicksPerSecond()) > (long)this.__nackReportingInterval) {
            _log.debug(StringExtensions.format("Received {0} generic NACKs in the last {1}ms.", IntegerExtensions.toString(this.__nacksReceivedDuringInterval), LongExtensions.toString(num2)));
            this.__nacksReceivedDuringInterval = 0;
            this.__lastNackReportTicks = ticks;
        }
        if ((num3 = (ticks - this.__lastNackNetworkConditionReportTicks) / (long)Constants.getTicksPerMillisecond()) > (long)this.__nackNetworkConditionReportingInterval) {
            if (this.__nacksReceivedDuringNetworkConditionInterval > this.__nacksReceivedDuringIntervalCriticalNetworkWarning) {
                _log.warn(StringExtensions.format("Critical network condition detected! NACKs sent exceeding critical threshold ({0}:{1}).", LongExtensions.toString(num3), IntegerExtensions.toString(this.__nacksReceivedDuringIntervalCriticalNetworkWarning)));
            } else if (this.__nacksReceivedDuringNetworkConditionInterval > this.__nacksReceivedDuringIntervalPoorNetworkWarning) {
                _log.warn(StringExtensions.format("Poor network condition detected! Large numbers of NACKs being sent ({0}:{1}).", LongExtensions.toString(num3), IntegerExtensions.toString(this.__nacksReceivedDuringIntervalCriticalNetworkWarning)));
            }
            this.__nacksSentDuringNetworkConditionInterval = 0;
            this.__lastNackNetworkConditionReportTicks = ticks;
        }
    }

    private void updateNackSenderStatistics() {
        ++this.__nacksSentDuringInterval;
        ++this.__nacksSentDuringNetworkConditionInterval;
        this.getNacksSent().increment();
        if (this.__lastNackReportTicks == -1L) {
            this.__lastNackReportTicks = DateExtensions.getTicks(DateExtensions.getUtcNow());
        }
        if (this.__lastNackNetworkConditionReportTicks == -1L) {
            this.__lastNackNetworkConditionReportTicks = DateExtensions.getTicks(DateExtensions.getUtcNow());
        }
        long ticks = DateExtensions.getTicks(DateExtensions.getUtcNow());
        long num2 = (ticks - this.__lastNackReportTicks) / (long)Constants.getTicksPerMillisecond();
        long num3 = (ticks - this.__lastNackNetworkConditionReportTicks) / (long)Constants.getTicksPerMillisecond();
        if (num2 > (long)this.__nackReportingInterval) {
            _log.debug(StringExtensions.format("Sent {0} generic NACKs in the last {1}ms.", IntegerExtensions.toString(this.__nacksSentDuringInterval), LongExtensions.toString(num2)));
            this.__nacksSentDuringInterval = 0;
            this.__lastNackReportTicks = ticks;
        }
        if (num3 > (long)this.__nackNetworkConditionReportingInterval) {
            if (this.__nacksSentDuringNetworkConditionInterval > this.__nacksSentDuringIntervalCriticalNetworkWarning) {
                _log.warn(StringExtensions.format("Critical network condition detected! NACKs sent exceeding critical threshold ({0}ms {1}).", LongExtensions.toString(num3), IntegerExtensions.toString(this.__nacksSentDuringIntervalCriticalNetworkWarning)));
            } else if (this.__nacksSentDuringNetworkConditionInterval > this.__nacksSentDuringIntervalPoorNetworkWarning) {
                _log.warn(StringExtensions.format("Poor network condition detected! Large numbers of NACKs being sent ({0}ms {1}).", LongExtensions.toString(num3), IntegerExtensions.toString(this.__nacksSentDuringIntervalPoorNetworkWarning)));
            }
            this.__nacksSentDuringNetworkConditionInterval = 0;
            this.__lastNackNetworkConditionReportTicks = ticks;
        }
    }

    private void updateRtcpReceiverStatistics(MediaControlFrame[] frames) {
        if (frames != null) {
            int num = 0;
            for (MediaControlFrame frame : frames) {
                num += frame.getDataBuffer().getLength();
            }
            this.getOctetsReceivedRtcp().add(num);
            this.getPacketsReceivedRtcp().increment();
        }
    }

    private void updateRtcpSenderStatistics(MediaControlFrame frame) {
        this.getOctetsSentRtcp().add(frame.getDataBuffer().getLength());
        this.getPacketsSentRtcp().increment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRtpReceiverStatistics(RtpPacket packet, long sequenceNumber, int clockRate) {
        Object object = this.__receiveCountsLock;
        synchronized (object) {
            long ticks = DateExtensions.getTicks(DateExtensions.getUtcNow());
            if (this.__currentRemoteSynchronizationSource == 0L) {
                this.__currentRemoteSynchronizationSource = packet.getSynchronizationSource();
                this.__minReceivedRtpTimestamp = packet.getTimestamp();
                this.__minReceivedTicks = ticks;
                this.__minReceivedPacketIndex = sequenceNumber;
                this.__maxReceivedPacketIndex = sequenceNumber;
                this.__receiveRtpCyclesPerTick = clockRate / Constants.getTicksPerSecond();
            }
            this.__currentReceivePayloadType = packet.getPayloadType();
            this.__minReceivedRtpTimestamp = MathAssistant.min(packet.getTimestamp(), this.__minReceivedRtpTimestamp);
            this.__minReceivedTicks = MathAssistant.min(ticks, this.__minReceivedTicks);
            this.__minReceivedPacketIndex = MathAssistant.min(sequenceNumber, this.__minReceivedPacketIndex);
            this.__maxReceivedPacketIndex = MathAssistant.max(sequenceNumber, this.__maxReceivedPacketIndex);
            this.getOctetsReceivedRtp().add(packet.getBuffer().getLength());
            this.getPacketsReceivedRtp().increment();
            long num2 = (long)((double)(ticks - this.__minReceivedTicks) * this.__receiveRtpCyclesPerTick) + this.__minReceivedRtpTimestamp;
            long num3 = num2 - packet.getTimestamp();
            long num4 = num3 - this.__lastReceiveTransit;
            this.__lastReceiveTransit = num3;
            if (num4 < 0L) {
                num4 = -num4;
            }
            this.__receiveJitter += ((double)num4 - this.__receiveJitter) / 16.0;
        }
        this.sendReportIfNeeded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateRtpSenderStatistics(RtpPacket rtpPacket) {
        if (rtpPacket == null) {
            _log.error("Transport cannot process RTP. Malformed RTP packet in frame.");
            return false;
        }
        if (this.__firstSendRtpTimestamp == -1L) {
            Object format = super.getFormat(rtpPacket.getPayloadType());
            this.__firstSendRtpTimestamp = rtpPacket.getTimestamp();
            this.__firstSendTicks = DateExtensions.getTicks(DateExtensions.getUtcNow());
            this.__sendRtpCyclesPerTick = (double)((MediaFormat)format).getClockRate() / 1.0E7;
        }
        this.__currentSendPayloadType = rtpPacket.getPayloadType();
        int length = rtpPacket.getPayload().getLength();
        Object object = this.__sentCountsLock;
        synchronized (object) {
            this.getPacketsSentRtp().increment();
            this.getOctetsSentRtp().add(length);
        }
        this.sendReportIfNeeded();
        return true;
    }

    private void validateAppControlFrame(AppControlFrame frame) {
        frame.setSynchronizationSource(this.__currentLocalSynchronizationSource);
    }

    private void validateByeControlFrame(ByeControlFrame frame) {
        if (frame.getSourceCount() == 0) {
            frame = new ByeControlFrame(this.__currentLocalSynchronizationSource);
        }
    }

    private void validateFeedbackControlFrame(FeedbackControlFrame frame) {
        frame.setPacketSenderSynchronizationSource(this.__currentLocalSynchronizationSource);
        frame.setMediaSourceSynchronizationSource(this.__currentRemoteSynchronizationSource);
        if (frame instanceof FirControlFrame) {
            FirControlFrame frame2 = (FirControlFrame)frame;
            for (FirEntry entry : frame2.getEntries()) {
                entry.setSynchronizationSource(this.__currentRemoteSynchronizationSource);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateReportControlFrame(ReportControlFrame frame) {
        if (ArrayExtensions.getLength(frame.getReportBlocks()) > 0) {
            if (this.__maxReceivedPacketIndex == -1L) {
                frame.setReportBlock(null);
            } else {
                for (ReportBlock block : frame.getReportBlocks()) {
                    long num9;
                    long num8;
                    long num7;
                    long num6;
                    long num5;
                    long num3;
                    Object obj2;
                    block.setSynchronizationSource(this.__currentRemoteSynchronizationSource);
                    long num = 0L;
                    long num2 = 0L;
                    Object object = obj2 = this.__receiveCountsLock;
                    synchronized (object) {
                        num = this.__lastSenderReportNtpTimestamp;
                        num2 = this.__lastSenderReportTicks;
                        num3 = this.__maxReceivedPacketIndex;
                        long num4 = this.__minReceivedPacketIndex;
                        num5 = num3 - num4 + 1L;
                        num6 = this.getPacketsReceivedRtp().getValue();
                        num7 = num5 - this.__lastExpectedPacketCount;
                        this.__lastExpectedPacketCount = num5;
                        num8 = num6 - this.__lastReceivedPacketCount;
                        this.__lastReceivedPacketCount = num6;
                        num9 = (long)this.__receiveJitter;
                    }
                    int num10 = (int)(num5 - num6);
                    int num11 = (int)(num7 - num8);
                    short num12 = 0;
                    if (num7 != 0L && num11 > 0) {
                        num12 = (short)((long)(num11 << 8) / num7);
                    }
                    long num13 = Binary.fromBytes32(Binary.toBytes64(num, false), 2, false);
                    long num14 = 0L;
                    if (num2 > 0L) {
                        num14 = (long)((double)(DateExtensions.getTicks(DateExtensions.getUtcNow()) - num2) * (65536.0 / (double)Constants.getTicksPerSecond()));
                    }
                    if (block.getFractionLost() == 0) {
                        block.setFractionLost(num12);
                    }
                    if (block.getCumulativeNumberOfPacketsLost() == 0) {
                        block.setCumulativeNumberOfPacketsLost(num10);
                        this.setInboundPacketsLostRtp(num10);
                    }
                    if (block.getExtendedHighestSequenceNumberReceived() == 0L) {
                        block.setExtendedHighestSequenceNumberReceived(num3);
                    }
                    if (block.getInterarrivalJitter() == 0L) {
                        block.setInterarrivalJitter(num9);
                    }
                    if (block.getLastSenderReportTimestamp() == 0L) {
                        block.setLastSenderReportTimestamp(num13);
                    }
                    if (block.getDelaySinceLastSenderReport() == 0L) {
                        block.setDelaySinceLastSenderReport(num14);
                    }
                    Object object2 = obj2 = this.__lock;
                    synchronized (object2) {
                        if (!this.__ignoreStats) {
                            this.updateLossBasedEstimatedAvailableBandwidth(block.getPercentLost(), false);
                        }
                    }
                }
            }
        }
    }

    private void validateRRControlFrame(RRControlFrame frame) {
        frame.setSynchronizationSource(this.__currentLocalSynchronizationSource);
        this.validateReportControlFrame(frame);
    }

    private void validateSdesControlFrame(SdesControlFrame frame) {
        if (frame.getChunks() != null) {
            for (SdesChunk chunk : frame.getChunks()) {
                chunk.setSynchronizationSource(this.__currentLocalSynchronizationSource);
                if (chunk.getSourceDescriptionItems() == null) continue;
                for (int i = 0; i < ArrayExtensions.getLength(chunk.getSourceDescriptionItems()); ++i) {
                    SdesItem item = chunk.getSourceDescriptionItems()[i];
                    if (item.getType() != SdesItemType.getCanonicalName() || Global.equals(item.getText(), super.getParameters().getCanonicalName())) continue;
                    item = new SdesItem(SdesItemType.getCanonicalName(), super.getParameters().getCanonicalName());
                }
            }
        }
    }

    private void validateSRControlFrame(SRControlFrame frame) {
        Date utcNow = DateExtensions.getUtcNow();
        long num = this.getPacketsSentRtp().getValue();
        long num2 = this.getOctetsSentRtp().getValue();
        frame.setSynchronizationSource(this.__currentLocalSynchronizationSource);
        if (frame.getNtpTimestamp() == 0L) {
            frame.setNtpTimestamp(NetworkTimeProtocol.dateTimeToNtp(utcNow));
        }
        if (frame.getRtpTimestamp() == 0L) {
            frame.setRtpTimestamp(num == 0L ? 0L : (long)((double)(DateExtensions.getTicks(utcNow) - this.__firstSendTicks) * this.__sendRtpCyclesPerTick) + (long)this.__startTimeOffset);
        }
        if (frame.getPacketCount() == 0L) {
            frame.setPacketCount(num);
        }
        if (frame.getOctetCount() == 0L) {
            frame.setOctetCount(num2);
        }
        this.validateReportControlFrame(frame);
    }

    static {
        _log = Log.getLogger("FM.IceLink.Rtp.Transport");
        __roundTripTimeAlpha = 0.75;
        __smoothingFactor = 0.5f;
    }
}

