/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.Global;
import fm.icelink.HashMapExtensions;
import fm.icelink.Holder;
import fm.icelink.RtpHeaderExtensionRegistryElement;
import fm.icelink.RtpHeaderExtensionType;
import fm.icelink.StreamDirection;
import fm.icelink.StringExtensions;
import java.util.HashMap;
import java.util.Iterator;

class RtpHeaderExtensionRegistry {
    private HashMap<Integer, RtpHeaderExtensionRegistryElement> __intRegistry;
    private Object __lock;
    private HashMap<RtpHeaderExtensionType, RtpHeaderExtensionRegistryElement> __typeRegistry = new HashMap();
    private static int _maxIdValue;
    private static int _minIdValue;
    public static int _unset;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.__lock;
        synchronized (object) {
            this.__typeRegistry.clear();
            this.__intRegistry.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getRtpHeaderExtensionAbsTimeRecvEnabled() {
        Object object = this.__lock;
        synchronized (object) {
            RtpHeaderExtensionRegistryElement element = null;
            Holder<Object> _var0 = new Holder<Object>(element);
            boolean _var1 = HashMapExtensions.tryGetValue(this.__typeRegistry, RtpHeaderExtensionType.AbsSendTime, _var0);
            element = _var0.getValue();
            return _var1 && (Global.equals((Object)element.getDirection(), (Object)StreamDirection.ReceiveOnly) || Global.equals((Object)element.getDirection(), (Object)StreamDirection.SendReceive) || Global.equals((Object)element.getDirection(), (Object)StreamDirection.Unset));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getRtpHeaderExtensionAbsTimeSendEnabled() {
        Object object = this.__lock;
        synchronized (object) {
            RtpHeaderExtensionRegistryElement element = null;
            Holder<Object> _var0 = new Holder<Object>(element);
            boolean _var1 = HashMapExtensions.tryGetValue(this.__typeRegistry, RtpHeaderExtensionType.AbsSendTime, _var0);
            element = _var0.getValue();
            return _var1 && (Global.equals((Object)element.getDirection(), (Object)StreamDirection.SendOnly) || Global.equals((Object)element.getDirection(), (Object)StreamDirection.SendReceive) || Global.equals((Object)element.getDirection(), (Object)StreamDirection.Unset));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RtpHeaderExtensionRegistryElement[] obtainRegisteredEntries() {
        RtpHeaderExtensionRegistryElement[] elementArray = null;
        Object object = this.__lock;
        synchronized (object) {
            elementArray = new RtpHeaderExtensionRegistryElement[HashMapExtensions.getCount(this.__intRegistry)];
            int index = 0;
            Iterator<RtpHeaderExtensionRegistryElement> iterator = HashMapExtensions.getValues(this.__intRegistry).iterator();
            while (iterator.hasNext()) {
                RtpHeaderExtensionRegistryElement element;
                elementArray[index] = element = iterator.next();
                ++index;
            }
        }
        return elementArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void populate(RtpHeaderExtensionRegistryElement[] elements) {
        Object object = this.__lock;
        synchronized (object) {
            this.clear();
            for (RtpHeaderExtensionRegistryElement element : elements) {
                this.register(element.getType(), element.getDirection(), element.getUri(), element.getId());
            }
        }
    }

    public void register(RtpHeaderExtensionType type, StreamDirection direction, String uri) {
        this.register(type, direction, uri, _minIdValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(RtpHeaderExtensionType type, StreamDirection direction, String uri, int id) {
        Object object = this.__lock;
        synchronized (object) {
            if (this.__intRegistry.containsKey(id) || id > _maxIdValue) {
                id = _minIdValue;
            }
            boolean flag = false;
            if (this.__typeRegistry.containsKey((Object)type)) {
                throw new RuntimeException(new Exception(StringExtensions.format("Attempted to add RTP Header Extension Type {0} but it already exists in the local registry.", type.toString())));
            }
            while (!flag) {
                if (this.__intRegistry.containsKey(id)) {
                    if (++id <= _maxIdValue) continue;
                    throw new RuntimeException(new Exception("Ability to register more than 14 RTP Header Extensions is not yet implemented."));
                }
                flag = true;
            }
            RtpHeaderExtensionRegistryElement element = new RtpHeaderExtensionRegistryElement(id, type, direction, uri);
            HashMapExtensions.add(this.__intRegistry, id, element);
            HashMapExtensions.add(this.__typeRegistry, type, element);
        }
    }

    public int registeredIdForRtpHeaderExtensionType(RtpHeaderExtensionType type) {
        RtpHeaderExtensionRegistryElement element = null;
        Holder<Object> _var0 = new Holder<Object>(element);
        boolean _var1 = HashMapExtensions.tryGetValue(this.__typeRegistry, type, _var0);
        element = _var0.getValue();
        if (_var1) {
            return element.getId();
        }
        return -1;
    }

    public RtpHeaderExtensionType registeredTypeForRtpHeaderExtensionId(int id) {
        RtpHeaderExtensionRegistryElement element = null;
        Holder<Object> _var0 = new Holder<Object>(element);
        boolean _var1 = HashMapExtensions.tryGetValue(this.__intRegistry, Integer.valueOf(id), _var0);
        element = _var0.getValue();
        if (_var1) {
            return element.getType();
        }
        return RtpHeaderExtensionType.Unknown;
    }

    public RtpHeaderExtensionRegistry() {
        this.__intRegistry = new HashMap();
        this.__lock = new Object();
        this.__typeRegistry = new HashMap();
        this.__intRegistry = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(RtpHeaderExtensionType type, StreamDirection direction, String uri) {
        RtpHeaderExtensionRegistryElement element = null;
        Object object = this.__lock;
        synchronized (object) {
            Holder<Object> _var0 = new Holder<Object>(element);
            boolean _var1 = HashMapExtensions.tryGetValue(this.__typeRegistry, type, _var0);
            element = _var0.getValue();
            if (!_var1 && !Global.equals((Object)direction, (Object)StreamDirection.Unset)) {
                this.register(type, direction, uri);
            } else if (!Global.equals((Object)direction, (Object)StreamDirection.Unset)) {
                element.setDirection(direction);
            } else {
                element.setDirection(StreamDirection.Inactive);
            }
        }
    }

    static {
        _unset = -1;
        _minIdValue = 1;
        _maxIdValue = 14;
    }
}

