/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.AppControlFrame;
import fm.icelink.ByeControlFrame;
import fm.icelink.DataBuffer;
import fm.icelink.FirControlFrame;
import fm.icelink.GenericNackControlFrame;
import fm.icelink.IntegerExtensions;
import fm.icelink.PayloadSpecificControlFrame;
import fm.icelink.PliControlFrame;
import fm.icelink.RRControlFrame;
import fm.icelink.RembControlFrame;
import fm.icelink.RtcpPacket;
import fm.icelink.RtpControlFrame;
import fm.icelink.SRControlFrame;
import fm.icelink.SdesControlFrame;
import fm.icelink.SliControlFrame;
import fm.icelink.StringExtensions;

public class MediaControlFrame {
    private DataBuffer __dataBuffer = null;
    private RtcpPacket _packet;

    public int getByte1Last5Bits() {
        return this._packet.getByte1Last5Bits();
    }

    public DataBuffer getDataBuffer() {
        return this.__dataBuffer;
    }

    public static int getFixedHeaderLength() {
        return 4;
    }

    public DataBuffer getPayload() {
        return this._packet.getPayload();
    }

    public int getPayloadLengthWithPadding() {
        return this._packet.getPayloadLengthWithPadding();
    }

    public int getPayloadType() {
        return this._packet.getPayloadType();
    }

    public int getVersion() {
        return this._packet.getVersion();
    }

    public MediaControlFrame() {
        this(DataBuffer.allocate(MediaControlFrame.getFixedHeaderLength()));
    }

    public MediaControlFrame(DataBuffer buffer) {
        if (buffer.getLength() < MediaControlFrame.getFixedHeaderLength()) {
            throw new RuntimeException(new Exception(StringExtensions.concat("DataBuffer must be at least ", IntegerExtensions.toString(MediaControlFrame.getFixedHeaderLength()), " bytes long.")));
        }
        this.setDataBuffer(buffer);
    }

    static MediaControlFrame parse(RtcpPacket packet) {
        int payloadType = packet.getPayloadType();
        if (payloadType == SRControlFrame.getRegisteredPayloadType()) {
            return new SRControlFrame(packet.getBuffer());
        }
        if (payloadType == RRControlFrame.getRegisteredPayloadType()) {
            return new RRControlFrame(packet.getBuffer());
        }
        if (payloadType == SdesControlFrame.getRegisteredPayloadType()) {
            return new SdesControlFrame(packet.getBuffer());
        }
        if (payloadType == ByeControlFrame.getRegisteredPayloadType()) {
            return new ByeControlFrame(packet.getBuffer());
        }
        if (payloadType == AppControlFrame.getRegisteredPayloadType()) {
            return new AppControlFrame(packet.getBuffer());
        }
        if (payloadType == RtpControlFrame.getRegisteredPayloadType()) {
            if (packet.getByte1Last5Bits() == GenericNackControlFrame.getRegisteredFeedbackMessageType()) {
                return new GenericNackControlFrame(packet.getBuffer());
            }
            return new MediaControlFrame(packet.getBuffer());
        }
        if (payloadType == PayloadSpecificControlFrame.getRegisteredPayloadType()) {
            int num2 = packet.getByte1Last5Bits();
            if (num2 == PliControlFrame.getRegisteredFeedbackMessageType()) {
                return new PliControlFrame(packet.getBuffer());
            }
            if (num2 == FirControlFrame.getRegisteredFeedbackMessageType()) {
                return new FirControlFrame(packet.getBuffer());
            }
            if (num2 == SliControlFrame.getRegisteredFedbackMessageType()) {
                return new SliControlFrame(packet.getBuffer());
            }
            if (num2 == RembControlFrame.getRegisteredFeedbackMessageType()) {
                return new RembControlFrame(packet.getBuffer());
            }
            return new MediaControlFrame(packet.getBuffer());
        }
        return new MediaControlFrame(packet.getBuffer());
    }

    public void setByte1Last5Bits(int value) {
        this._packet.setByte1Last5Bits(value);
    }

    protected void setDataBuffer(DataBuffer value) {
        this.__dataBuffer = value;
        this._packet = new RtcpPacket(this.__dataBuffer);
    }

    private void setPayload(DataBuffer value) {
        this._packet.setPayload(value);
    }

    protected void setPayloadLengthWithPadding(int value) {
        this._packet.setPayloadLengthWithPadding(value);
    }

    public void setPayloadType(int value) {
        this._packet.setPayloadType(value);
    }

    public void setVersion(int value) {
        this._packet.setVersion(value);
    }
}

