/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.AddressType;
import fm.icelink.LocalAddress;
import fm.icelink.TransportAddress;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class LocalNetwork {
    public static String[] getIPAddresses(AddressType[] addressTypes) {
        return LocalNetwork.getIPAddresses(addressTypes, true);
    }

    public static String[] getIPAddresses(AddressType[] addressTypes, boolean allowPrivate) {
        try {
            LocalAddress[] addresses = LocalNetwork.getLocalAddresses(addressTypes);
            ArrayList<String> ipAddresses = new ArrayList<String>();
            for (int i = 0; i < addresses.length; ++i) {
                String ipAddress = addresses[i].getIPAddress();
                if (!allowPrivate && TransportAddress.isPrivate(ipAddress)) continue;
                ipAddresses.add(ipAddress);
            }
            return ipAddresses.toArray(new String[0]);
        }
        catch (Exception ex) {
            return new String[0];
        }
    }

    static LocalAddress[] getLocalAddresses(AddressType[] addressTypes) {
        try {
            boolean ipv4 = false;
            boolean ipv6 = false;
            for (AddressType addressType : addressTypes) {
                if (addressType == AddressType.IPv4) {
                    ipv4 = true;
                }
                if (addressType != AddressType.IPv6) continue;
                ipv6 = true;
            }
            ArrayList<LocalAddress> localAddresses = new ArrayList<LocalAddress>();
            Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
            while (nis.hasMoreElements()) {
                NetworkInterface ni = nis.nextElement();
                if (ni.isLoopback() || !ni.isUp()) continue;
                List<InterfaceAddress> ias = ni.getInterfaceAddresses();
                for (InterfaceAddress ia : ias) {
                    String ipAddress;
                    InetAddress address = ia.getAddress();
                    if ((!ipv6 || !(address instanceof Inet6Address)) && (!ipv4 || !(address instanceof Inet4Address)) || TransportAddress.isLinkLocal(ipAddress = TransportAddress.sanitizeIPAddress(address.toString()))) continue;
                    short prefixLength = ia.getNetworkPrefixLength();
                    String mask = TransportAddress.maskFromPrefixLength(prefixLength);
                    localAddresses.add(new LocalAddress(ipAddress, mask, 1000000L));
                }
            }
            return localAddresses.toArray(new LocalAddress[localAddresses.size()]);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static AddressType getAddressType(String ipAddress) {
        try {
            InetAddress address = InetAddress.getByName(ipAddress);
            if (address instanceof Inet6Address) {
                return AddressType.IPv6;
            }
            if (address instanceof Inet4Address) {
                return AddressType.IPv4;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static byte[] getAddressBytes(String ipAddress) throws Exception {
        return InetAddress.getByName(ipAddress).getAddress();
    }

    public static String getAddress(byte[] addressBytes) throws Exception {
        return InetAddress.getByAddress(addressBytes).toString();
    }
}

