/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.AddressType;
import fm.icelink.Candidate;
import fm.icelink.Future;
import fm.icelink.Global;
import fm.icelink.IAction0;
import fm.icelink.IAction1;
import fm.icelink.IAction2;
import fm.icelink.IceCandidate;
import fm.icelink.IceGatherOptions;
import fm.icelink.IceGatherPolicy;
import fm.icelink.IceGatherer;
import fm.icelink.IceGatheringState;
import fm.icelink.IcePortRange;
import fm.icelink.IceServer;
import fm.icelink.IceServerTestResult;
import fm.icelink.ManagedThread;
import fm.icelink.Promise;
import fm.icelink.Scheduler;
import fm.icelink.StringExtensions;
import java.util.ArrayList;

public class IceServerTest {
    private AddressType[] _iceAddressTypes;
    private IceGatherer _iceGatherer;
    private IcePortRange _icePortRange;
    private IceServer _iceServer;
    private volatile boolean _running = false;
    private Object _runningLock = new Object();

    private Promise<IceServerTestResult> doRun(final Promise<IceServerTestResult> promise) {
        ManagedThread.dispatch(new IAction0(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void invoke() {
                try {
                    IceServer[] iceServerArray;
                    Object object = IceServerTest.this._runningLock;
                    synchronized (object) {
                        if (IceServerTest.this._running) {
                            throw new RuntimeException(new Exception("Test is already running."));
                        }
                        IceServerTest.this._running = true;
                    }
                    Object lockObject = new Object();
                    if (IceServerTest.this.getIceServer() == null) {
                        iceServerArray = null;
                    } else {
                        IceServer[] iceServerArray2 = new IceServer[1];
                        iceServerArray = iceServerArray2;
                        iceServerArray2[0] = IceServerTest.this.getIceServer();
                    }
                    IceServer[] servers = iceServerArray;
                    IceServerTest.this.setIceGatherer(new IceGatherer(lockObject, new Scheduler(lockObject), new IceGatherOptions(IceGatherPolicy.All, servers, IceServerTest.this.getIcePortRange(), IceServerTest.this.getIceAddressTypes())));
                    IceServerTest.this.doRun(promise, new ArrayList());
                }
                catch (Exception exception) {
                    IceServerTest.this._running = false;
                    promise.reject(exception);
                }
            }
        });
        return promise;
    }

    private void doRun(final Promise<IceServerTestResult> promise, final ArrayList<Candidate> candidates) {
        this.getIceGatherer().addOnStateChange(new IAction1<IceGatherer>(){

            @Override
            public void invoke(IceGatherer g) {
                if (Global.equals((Object)g.getState(), (Object)IceGatheringState.Failed)) {
                    promise.reject(new Exception(StringExtensions.format("ICE gatherer failed.{0}", g.getError() == null ? StringExtensions.empty : StringExtensions.concat(" ", g.getError().getException().getMessage()))));
                } else if (Global.equals((Object)g.getState(), (Object)IceGatheringState.Complete)) {
                    promise.resolve(new IceServerTestResult(candidates.toArray(new Candidate[0])));
                    g.stop();
                }
            }
        });
        this.getIceGatherer().addOnLocalCandidate(new IAction2<IceGatherer, IceCandidate>(){

            @Override
            public void invoke(IceGatherer g, IceCandidate iceCandidate) {
                candidates.add(iceCandidate.toCandidate(1, 0));
            }
        });
        if (!this.getIceGatherer().start()) {
            throw new RuntimeException(new Exception("Could not start ICE gatherer."));
        }
    }

    public AddressType[] getIceAddressTypes() {
        return this._iceAddressTypes;
    }

    private IceGatherer getIceGatherer() {
        return this._iceGatherer;
    }

    public IcePortRange getIcePortRange() {
        return this._icePortRange;
    }

    public IceServer getIceServer() {
        return this._iceServer;
    }

    public IceServerTest(IceServer iceServer, IcePortRange icePortRange, AddressType[] iceAddressTypes) {
        if (icePortRange == null) {
            icePortRange = new IcePortRange();
        }
        if (iceAddressTypes == null) {
            iceAddressTypes = new AddressType[]{AddressType.IPv4, AddressType.IPv6};
        }
        this.setIceServer(iceServer);
        this.setIcePortRange(icePortRange);
        this.setIceAddressTypes(iceAddressTypes);
    }

    public IceServerTest(IceServer iceServer, IcePortRange icePortRange) {
        this(iceServer, icePortRange, null);
    }

    public IceServerTest(IceServer iceServer) {
        this(iceServer, null);
    }

    public Future<IceServerTestResult> run() {
        return this.doRun(new Promise<IceServerTestResult>());
    }

    private void setIceAddressTypes(AddressType[] value) {
        this._iceAddressTypes = value;
    }

    private void setIceGatherer(IceGatherer value) {
        this._iceGatherer = value;
    }

    private void setIcePortRange(IcePortRange value) {
        this._icePortRange = value;
    }

    private void setIceServer(IceServer value) {
        this._iceServer = value;
    }
}

