/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayListExtensions;
import fm.icelink.CandidatePairState;
import fm.icelink.CandidateType;
import fm.icelink.Global;
import fm.icelink.Holder;
import fm.icelink.IceCandidate;
import fm.icelink.IceCandidatePair;
import fm.icelink.StringBuilderExtensions;
import fm.icelink.StringExtensions;
import java.util.ArrayList;

class IceCheckList {
    private Object __lock;
    private ArrayList<IceCandidatePair> __ordinaryCheckList;
    private ArrayList<IceCandidatePair> __triggeredCheckList = new ArrayList();
    private ArrayList<IceCandidatePair> __waitingForPermissionRequestResponse;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToAwaitingOriginalRelayPermissionsList(IceCandidatePair candidatePair) {
        Object object = this.__lock;
        synchronized (object) {
            this.__waitingForPermissionRequestResponse.add(candidatePair);
            candidatePair.startPermissionRequests();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addToOrdinaryCheckList(IceCandidatePair candidatePair) {
        if (Global.equals((Object)candidatePair.getLocal().getType(), (Object)CandidateType.ServerReflexive)) {
            candidatePair.setLocal(candidatePair.getLocal().getBase());
        }
        boolean flag = false;
        int index = 0;
        Object object = this.__lock;
        synchronized (object) {
            while (!flag && index < ArrayListExtensions.getCount(this.__ordinaryCheckList)) {
                IceCandidatePair pair = ArrayListExtensions.getItem(this.__ordinaryCheckList).get(index);
                if (Global.equals(candidatePair.getLocal(), pair.getLocal()) && Global.equals(candidatePair.getRemote(), pair.getRemote())) {
                    return false;
                }
                if (pair.getPriority() <= candidatePair.getPriority()) {
                    if (!this.__ordinaryCheckList.contains(candidatePair)) {
                        ArrayListExtensions.insert(this.__ordinaryCheckList, index, candidatePair);
                    }
                    flag = true;
                    continue;
                }
                ++index;
            }
            if (!flag && !this.__ordinaryCheckList.contains(candidatePair)) {
                this.__ordinaryCheckList.add(candidatePair);
            }
            candidatePair.setState(CandidatePairState.Waiting);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToTriggeredCheckList(Holder<IceCandidatePair> pair) {
        IceCandidatePair pair2 = this.findMatchingCandidatePair(pair.getValue());
        if (pair2 != null) {
            Object object;
            Object obj2;
            pair.getValue().stop();
            pair.setValue(pair2);
            if (Global.equals((Object)pair.getValue().getState(), (Object)CandidatePairState.New)) {
                pair.getValue().setOnOriginalRelayPermissionsObtained(null);
                pair.getValue().setAwaitingOriginalRelayPermissions(false);
                this.addToOrdinaryCheckList(pair.getValue());
                object = obj2 = this.__lock;
                synchronized (object) {
                    this.__waitingForPermissionRequestResponse.remove(pair.getValue());
                }
            }
            if (Global.equals((Object)pair.getValue().getState(), (Object)CandidatePairState.Waiting)) {
                object = obj2 = this.__lock;
                synchronized (object) {
                    if (!this.__triggeredCheckList.contains(pair.getValue())) {
                        this.__triggeredCheckList.add(pair.getValue());
                    }
                }
            }
            if (Global.equals((Object)pair.getValue().getState(), (Object)CandidatePairState.InProgress)) {
                pair.getValue().cancelConnectivityCheck();
                object = obj2 = this.__lock;
                synchronized (object) {
                    if (!this.__triggeredCheckList.contains(pair.getValue())) {
                        this.__triggeredCheckList.add(pair.getValue());
                    }
                }
                pair.getValue().setState(CandidatePairState.Waiting);
            } else if (Global.equals((Object)pair.getValue().getState(), (Object)CandidatePairState.Failed)) {
                object = obj2 = this.__lock;
                synchronized (object) {
                    if (!this.__triggeredCheckList.contains(pair.getValue())) {
                        this.__triggeredCheckList.add(pair.getValue());
                    }
                }
                pair.getValue().setState(CandidatePairState.Waiting);
            }
        } else if (!Global.equals((Object)pair.getValue().getState(), (Object)CandidatePairState.Succeeded)) {
            Object obj2;
            if (Global.equals((Object)pair.getValue().getLocal().getType(), (Object)CandidateType.Relayed)) {
                pair.getValue().startPermissionRequests();
            }
            Object object = obj2 = this.__lock;
            synchronized (object) {
                if (!this.__triggeredCheckList.contains(pair.getValue())) {
                    this.__triggeredCheckList.add(pair.getValue());
                }
            }
            pair.getValue().setAwaitingOriginalRelayPermissions(false);
            this.addToOrdinaryCheckList(pair.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object obj2;
        Object object = obj2 = this.__lock;
        synchronized (object) {
            for (IceCandidatePair pair : this.__triggeredCheckList) {
                pair.stop();
            }
            this.__triggeredCheckList.clear();
        }
        object = obj2 = this.__lock;
        synchronized (object) {
            for (IceCandidatePair pair : this.__ordinaryCheckList) {
                pair.stop();
            }
            this.__ordinaryCheckList.clear();
        }
        object = obj2 = this.__lock;
        synchronized (object) {
            for (IceCandidatePair pair : this.__waitingForPermissionRequestResponse) {
                pair.stop();
            }
            this.__waitingForPermissionRequestResponse.clear();
        }
    }

    public IceCandidatePair findMatchingCandidatePair(IceCandidatePair cp) {
        IceCandidate local = cp.getLocal();
        IceCandidate remote = cp.getRemote();
        return this.findMatchingCandidatePair(local, remote);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IceCandidatePair findMatchingCandidatePair(IceCandidate local, IceCandidate remote) {
        Object object = this.__lock;
        synchronized (object) {
            for (IceCandidatePair pair : this.__ordinaryCheckList) {
                if (!pair.equals(local, remote)) continue;
                return pair;
            }
            for (IceCandidatePair pair : this.__waitingForPermissionRequestResponse) {
                if (!pair.equals(local, remote)) continue;
                return pair;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IceCandidate findMatchingLocalCandidate(String ipAddress, int port) {
        Object obj2;
        Object object = obj2 = this.__lock;
        synchronized (object) {
            for (IceCandidatePair pair : this.__ordinaryCheckList) {
                if (!Global.equals(pair.getLocal().getIPAddress(), ipAddress) || pair.getLocal().getPort() != port) continue;
                return pair.getLocal();
            }
        }
        object = obj2 = this.__lock;
        synchronized (object) {
            for (IceCandidatePair pair : this.__waitingForPermissionRequestResponse) {
                if (!Global.equals(pair.getLocal().getIPAddress(), ipAddress) || pair.getLocal().getPort() != port) continue;
                return pair.getLocal();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getAllCandidatePairsCompletedAndAtLeastOneSucceeded() {
        boolean flag = true;
        boolean flag2 = false;
        if (ArrayListExtensions.getCount(this.__waitingForPermissionRequestResponse) > 0) {
            return false;
        }
        Object object = this.__lock;
        synchronized (object) {
            for (IceCandidatePair pair : this.__ordinaryCheckList) {
                flag = flag && (Global.equals((Object)pair.getState(), (Object)CandidatePairState.Succeeded) || Global.equals((Object)pair.getState(), (Object)CandidatePairState.Failed) || Global.equals((Object)pair.getState(), (Object)CandidatePairState.Closed));
                flag2 = flag2 || Global.equals((Object)pair.getState(), (Object)CandidatePairState.Succeeded);
            }
        }
        return flag && flag2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getAtLeastOneCandidatePairSucceeded() {
        Object object = this.__lock;
        synchronized (object) {
            for (IceCandidatePair pair : this.__ordinaryCheckList) {
                if (!Global.equals((Object)pair.getState(), (Object)CandidatePairState.Succeeded)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IceCandidatePair[] getCandidatePairs() {
        ArrayList list = new ArrayList();
        Object object = this.__lock;
        synchronized (object) {
            ArrayListExtensions.addRange(list, this.__triggeredCheckList);
            ArrayListExtensions.addRange(list, this.__ordinaryCheckList);
            ArrayListExtensions.addRange(list, this.__waitingForPermissionRequestResponse);
        }
        return list.toArray(new IceCandidatePair[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getConnectivityChecksCompletedAndNoneSucceeded() {
        Object object = this.__lock;
        synchronized (object) {
            for (IceCandidatePair pair : this.__ordinaryCheckList) {
                if (!Global.equals((Object)pair.getState(), (Object)CandidatePairState.InProgress) && !Global.equals((Object)pair.getState(), (Object)CandidatePairState.Succeeded) && !Global.equals((Object)pair.getState(), (Object)CandidatePairState.Waiting) && !Global.equals((Object)pair.getState(), (Object)CandidatePairState.New)) continue;
                return false;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getConnectivityChecksNotCompleted() {
        Object object = this.__lock;
        synchronized (object) {
            for (IceCandidatePair pair : this.__ordinaryCheckList) {
                if (!Global.equals((Object)pair.getState(), (Object)CandidatePairState.InProgress) && !Global.equals((Object)pair.getState(), (Object)CandidatePairState.Waiting) && !Global.equals((Object)pair.getState(), (Object)CandidatePairState.New)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IceCandidatePair getWaitingCandidatePair() {
        int num;
        Object obj2;
        IceCandidatePair item = null;
        boolean flag = false;
        Object object = obj2 = this.__lock;
        synchronized (object) {
            ArrayList<IceCandidatePair> list = new ArrayList<IceCandidatePair>();
            for (num = 0; num < ArrayListExtensions.getCount(this.__triggeredCheckList) && !flag; ++num) {
                if (Global.equals((Object)ArrayListExtensions.getItem(this.__triggeredCheckList).get(num).getState(), (Object)CandidatePairState.Waiting)) {
                    item = ArrayListExtensions.getItem(this.__triggeredCheckList).get(num);
                    list.add(item);
                    flag = true;
                    continue;
                }
                IceCandidatePair pair2 = ArrayListExtensions.getItem(this.__triggeredCheckList).get(num);
                list.add(pair2);
            }
            for (IceCandidatePair pair2 : list) {
                this.__triggeredCheckList.remove(pair2);
            }
        }
        if (!flag) {
            object = obj2 = this.__lock;
            synchronized (object) {
                for (num = 0; num < ArrayListExtensions.getCount(this.__ordinaryCheckList) && !flag; ++num) {
                    if (!Global.equals((Object)ArrayListExtensions.getItem(this.__ordinaryCheckList).get(num).getState(), (Object)CandidatePairState.Waiting)) continue;
                    flag = true;
                    item = ArrayListExtensions.getItem(this.__ordinaryCheckList).get(num);
                }
            }
        }
        return item;
    }

    public IceCheckList(Object lockObject) {
        this.__ordinaryCheckList = new ArrayList();
        this.__waitingForPermissionRequestResponse = new ArrayList();
        this.__lock = lockObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processGotOriginalRelayPermission(IceCandidatePair pair) {
        Object obj2;
        Object object = obj2 = this.__lock;
        synchronized (object) {
            if (Global.equals((Object)pair.getState(), (Object)CandidatePairState.New)) {
                this.addToOrdinaryCheckList(pair);
            }
        }
        object = obj2 = this.__lock;
        synchronized (object) {
            this.__waitingForPermissionRequestResponse.remove(pair);
        }
        pair.setOnOriginalRelayPermissionsObtained(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder builder = new StringBuilder();
        Object object = this.__lock;
        synchronized (object) {
            for (IceCandidatePair pair : this.__ordinaryCheckList) {
                StringBuilderExtensions.append(builder, StringExtensions.concat(pair.toString(), "\n"));
            }
            for (IceCandidatePair pair : this.__waitingForPermissionRequestResponse) {
                StringBuilderExtensions.append(builder, StringExtensions.concat(pair.toString(), "\n"));
            }
        }
        return StringExtensions.trimEnd(builder.toString(), new char[]{'\n'});
    }
}

