/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.xirsys.v2;

import fm.icelink.Future;
import fm.icelink.HttpMethod;
import fm.icelink.HttpRequestArgs;
import fm.icelink.HttpResponseArgs;
import fm.icelink.HttpTransfer;
import fm.icelink.HttpTransferFactory;
import fm.icelink.IAction1;
import fm.icelink.Promise;
import fm.icelink.StringExtensions;
import fm.icelink.xirsys.v2.IceResponse;
import fm.icelink.xirsys.v2.IceServer;
import java.util.ArrayList;

public class Client {
    private static String __defaultEndpoint = "https://service.xirsys.com/ice";
    private String _application;
    private String _domain;
    private String _endpoint;
    private String _ident;
    private String _room;
    private String _secret;
    private boolean _secure;

    public Client(String ident, String secret, String domain, String application, String room) {
        this(ident, secret, domain, application, room, true);
    }

    public Client(String ident, String secret, String domain, String application) {
        this(ident, secret, domain, application, "default");
    }

    public Client(String ident, String secret, String domain) {
        this(ident, secret, domain, "default");
    }

    public Client(String ident, String secret, String domain, String application, String room, boolean secure) {
        this.setIdent(ident);
        this.setSecret(secret);
        this.setDomain(domain);
        this.setApplication(application);
        this.setRoom(room);
        this.setSecure(secure);
        this.setEndpoint(Client.getDefaultEndpoint());
    }

    private void doGetIceServers(final Promise<fm.icelink.IceServer[]> promise) {
        String str = HttpTransfer.addQueryToUrl((String)HttpTransfer.addQueryToUrl((String)HttpTransfer.addQueryToUrl((String)HttpTransfer.addQueryToUrl((String)HttpTransfer.addQueryToUrl((String)HttpTransfer.addQueryToUrl((String)this.getEndpoint(), (String)"ident", (String)this.getIdent()), (String)"secret", (String)this.getSecret()), (String)"domain", (String)this.getDomain()), (String)"application", (String)this.getApplication()), (String)"room", (String)this.getRoom()), (String)"secure", (String)(this.getSecure() ? "1" : "0"));
        HttpRequestArgs requestArgs = new HttpRequestArgs();
        requestArgs.setMethod(HttpMethod.Get);
        requestArgs.setUrl(str);
        HttpTransferFactory.getHttpTransfer().sendTextAsync(requestArgs, (IAction1)new IAction1<HttpResponseArgs>(){

            public void invoke(HttpResponseArgs responseArgs) {
                IceResponse response = IceResponse.fromJson(responseArgs.getTextContent());
                if (response == null) {
                    promise.reject(new Exception("XirSys: null response"));
                } else if (response.getStatus().hasValue() && response.getStatus().getValue() != 200) {
                    promise.reject(new Exception(StringExtensions.format((String)"XirSys: {0} {1}", (Object)response.getStatus().toString(), (Object)response.getError())));
                } else {
                    ArrayList<fm.icelink.IceServer> list = new ArrayList<fm.icelink.IceServer>();
                    for (IceServer server : response.getData().getIceServers()) {
                        if (server.getUsername() == null || server.getCredential() == null) {
                            list.add(new fm.icelink.IceServer(server.getUrl()));
                            continue;
                        }
                        list.add(new fm.icelink.IceServer(server.getUrl(), server.getUsername(), server.getCredential()));
                    }
                    promise.resolve((Object)list.toArray(new fm.icelink.IceServer[0]));
                }
            }
        });
    }

    public String getApplication() {
        return this._application;
    }

    public static String getDefaultEndpoint() {
        return __defaultEndpoint;
    }

    public String getDomain() {
        return this._domain;
    }

    public String getEndpoint() {
        return this._endpoint;
    }

    public Future<fm.icelink.IceServer[]> getIceServers() {
        Promise promise = new Promise();
        this.doGetIceServers((Promise<fm.icelink.IceServer[]>)promise);
        return promise;
    }

    public String getIdent() {
        return this._ident;
    }

    public String getRoom() {
        return this._room;
    }

    public String getSecret() {
        return this._secret;
    }

    public boolean getSecure() {
        return this._secure;
    }

    public void setApplication(String value) {
        this._application = value;
    }

    public static void setDefaultEndpoint(String value) {
        __defaultEndpoint = value;
    }

    public void setDomain(String value) {
        this._domain = value;
    }

    public void setEndpoint(String value) {
        this._endpoint = value;
    }

    public void setIdent(String value) {
        this._ident = value;
    }

    public void setRoom(String value) {
        this._room = value;
    }

    public void setSecret(String value) {
        this._secret = value;
    }

    public void setSecure(boolean value) {
        this._secure = value;
    }

    private String toFormData() {
        return StringExtensions.format((String)"ident={0}&secret={1}&domain={2}&application={3}&room={4}&secure={5}", (Object[])new Object[]{this.getIdent(), this.getSecret(), this.getDomain(), this.getApplication(), this.getRoom(), this.getSecure() ? "1" : "0"});
    }
}

