/*
 * Decompiled with CFR 0.152.
 */
package fm;

import fm.Delegate;
import fm.HttpRequestArgs;
import fm.HttpResponseArgs;
import fm.HttpSendFinishArgs;
import fm.HttpSendStartArgs;
import fm.Randomizer;
import fm.SingleAction;
import fm.StringComparison;
import fm.StringExtensions;
import fm.UriExtensions;

public abstract class HttpTransfer {
    private static String __wildcardCharacters = "abcdefghijklmnopqrstuvwxyz";
    private String _httpTransferCallbackKey = "fm.httpTransfer.callback";
    private static SingleAction<HttpSendFinishArgs> _onSendFinish;
    private static SingleAction<HttpSendStartArgs> _onSendStart;

    public static SingleAction<HttpSendFinishArgs> addOnSendFinish(SingleAction<HttpSendFinishArgs> value) {
        _onSendFinish = Delegate.combine(_onSendFinish, value);
        return value;
    }

    public static SingleAction<HttpSendStartArgs> addOnSendStart(SingleAction<HttpSendStartArgs> value) {
        _onSendStart = Delegate.combine(_onSendStart, value);
        return value;
    }

    public static String addQueryToUrl(String url, String key, String value) {
        if (StringExtensions.isNullOrEmpty(key)) {
            return url;
        }
        if (value == null) {
            value = StringExtensions.empty;
        }
        key = UriExtensions.escapeDataString(key);
        value = UriExtensions.escapeDataString(value);
        return StringExtensions.concat(new String[]{url, StringExtensions.indexOf(url, "?", StringComparison.OrdinalIgnoreCase) == -1 ? "?" : "&", key, "=", value});
    }

    public static String addQueryToUrl(String url, String key) {
        return HttpTransfer.addQueryToUrl(url, key, null);
    }

    private void finishRequest(HttpResponseArgs responseArgs) {
        this.raiseOnSendFinish(responseArgs);
    }

    public static String getRandomWildcardCharacter() {
        String wildcardCharacters = HttpTransfer.getWildcardCharacters();
        int startIndex = new Randomizer().next(StringExtensions.getLength(wildcardCharacters));
        return StringExtensions.substring(wildcardCharacters, startIndex, 1);
    }

    public static String getWildcardCharacters() {
        return __wildcardCharacters;
    }

    protected HttpTransfer() {
    }

    private void raiseOnSendFinish(HttpResponseArgs responseArgs) {
        SingleAction<HttpSendFinishArgs> onSendFinish = _onSendFinish;
        if (onSendFinish != null) {
            HttpSendFinishArgs p = new HttpSendFinishArgs();
            p.setSender(responseArgs.getRequestArgs().getSender());
            p.setRequestBinaryContent(responseArgs.getRequestArgs().getBinaryContent());
            p.setRequestTextContent(responseArgs.getRequestArgs().getTextContent());
            p.setResponseBinaryContent(responseArgs.getBinaryContent());
            p.setResponseTextContent(responseArgs.getTextContent());
            p.setResponseHeaders(responseArgs.getHeaders());
            onSendFinish.invoke(p);
        }
    }

    private void raiseOnSendStart(HttpRequestArgs requestArgs) {
        SingleAction<HttpSendStartArgs> onSendStart = _onSendStart;
        if (onSendStart != null) {
            HttpSendStartArgs p = new HttpSendStartArgs();
            p.setSender(requestArgs.getSender());
            p.setRequestBinaryContent(requestArgs.getBinaryContent());
            p.setRequestTextContent(requestArgs.getTextContent());
            onSendStart.invoke(p);
        }
    }

    public static void removeOnSendFinish(SingleAction<HttpSendFinishArgs> value) {
        _onSendFinish = Delegate.remove(_onSendFinish, value);
    }

    public static void removeOnSendStart(SingleAction<HttpSendStartArgs> value) {
        _onSendStart = Delegate.remove(_onSendStart, value);
    }

    public static String replaceWildcards(String url) {
        return url.replace("*", HttpTransfer.getRandomWildcardCharacter());
    }

    public HttpResponseArgs send(HttpRequestArgs requestArgs) {
        HttpResponseArgs args;
        this.startRequest(requestArgs);
        try {
            args = requestArgs.getBinaryContent() != null ? this.sendBinary(requestArgs) : this.sendText(requestArgs);
        }
        catch (Exception exception) {
            HttpResponseArgs args2 = new HttpResponseArgs(requestArgs);
            args2.setException(exception);
            args = args2;
        }
        this.finishRequest(args);
        return args;
    }

    public void sendAsync(HttpRequestArgs requestArgs, SingleAction<HttpResponseArgs> callback) {
        this.startRequest(requestArgs);
        requestArgs.setDynamicValue(this._httpTransferCallbackKey, callback);
        try {
            if (requestArgs.getBinaryContent() != null) {
                final HttpTransfer _var0 = this;
                this.sendBinaryAsync(requestArgs, new SingleAction<HttpResponseArgs>(){

                    @Override
                    public void invoke(HttpResponseArgs responseArgs) {
                        try {
                            _var0.sendAsyncCallback(responseArgs);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
            } else {
                final HttpTransfer _var2 = this;
                this.sendTextAsync(requestArgs, new SingleAction<HttpResponseArgs>(){

                    @Override
                    public void invoke(HttpResponseArgs responseArgs) {
                        try {
                            _var2.sendAsyncCallback(responseArgs);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
            }
        }
        catch (Exception exception) {
            HttpResponseArgs p = new HttpResponseArgs(requestArgs);
            p.setException(exception);
            callback.invoke(p);
        }
    }

    private void sendAsyncCallback(HttpResponseArgs responseArgs) {
        SingleAction dynamicValue = (SingleAction)responseArgs.getRequestArgs().getDynamicValue(this._httpTransferCallbackKey);
        responseArgs.getRequestArgs().unsetDynamicValue(this._httpTransferCallbackKey);
        this.finishRequest(responseArgs);
        dynamicValue.invoke(responseArgs);
    }

    public abstract HttpResponseArgs sendBinary(HttpRequestArgs var1) throws Exception;

    public abstract void sendBinaryAsync(HttpRequestArgs var1, SingleAction<HttpResponseArgs> var2) throws Exception;

    public abstract HttpResponseArgs sendText(HttpRequestArgs var1) throws Exception;

    public abstract void sendTextAsync(HttpRequestArgs var1, SingleAction<HttpResponseArgs> var2) throws Exception;

    public static void setWildcardCharacters(String value) {
        __wildcardCharacters = value;
    }

    public abstract void shutdown() throws Exception;

    private void startRequest(HttpRequestArgs requestArgs) {
        this.raiseOnSendStart(requestArgs);
    }
}

