/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.android;

import android.content.Context;
import android.graphics.Bitmap;
import android.widget.ImageView;
import fm.icelink.IAction0;
import fm.icelink.IVideoSource;
import fm.icelink.LayoutScale;
import fm.icelink.VideoBuffer;
import fm.icelink.VideoFormat;
import fm.icelink.VideoFrame;
import fm.icelink.ViewSink;
import fm.icelink.android.ImageUtility;
import fm.icelink.android.Utility;

public class ImageViewSink
extends ViewSink<ImageView> {
    private ImageView _view;
    private LayoutScale _viewScale = LayoutScale.Contain;
    private boolean _viewMirror = false;
    private LayoutScale _lastViewScale;
    private boolean _lastViewMirror;

    public ImageView getView() {
        return this._view;
    }

    public LayoutScale getViewScale() {
        return this._viewScale;
    }

    public void setViewScale(LayoutScale viewScale) {
        this._viewScale = viewScale;
    }

    public boolean getViewMirror() {
        return this._viewMirror;
    }

    public void setViewMirror(boolean viewMirror) {
        this._viewMirror = viewMirror;
    }

    public String getLabel() {
        return "Android ImageView Sink";
    }

    public ImageViewSink(Context context) {
        super(VideoFormat.getArgb());
        this.initialize(context);
    }

    public ImageViewSink(Context context, IVideoSource source) {
        super(source);
        this.initialize(context);
    }

    public ImageViewSink(Context context, IVideoSource[] sources) {
        super(sources);
        this.initialize(context);
    }

    public ImageViewSink(ImageView view) {
        super(VideoFormat.getArgb());
        this.initialize(view);
    }

    public ImageViewSink(ImageView view, IVideoSource source) {
        super(source);
        this.initialize(view);
    }

    public ImageViewSink(ImageView view, IVideoSource[] sources) {
        super(sources);
        this.initialize(view);
    }

    private void initialize(final Context context) {
        Utility.dispatchToMainThread(new IAction0(){

            public void invoke() {
                ImageViewSink.this.initialize(new ImageView(context));
            }
        }, true);
    }

    private void initialize(ImageView view) {
        if (!((VideoFormat)this.getInputFormat()).getName().equals(VideoFormat.getArgbName())) {
            throw new RuntimeException("Input format must be ARGB.");
        }
        if (view == null) {
            throw new RuntimeException("View cannot be null.");
        }
        this._view = view;
    }

    protected void doProcessFrame(VideoFrame frame, VideoBuffer inputBuffer) {
        super.doProcessFrame(frame, inputBuffer);
        this.renderBuffer(inputBuffer);
    }

    public void renderBuffer(VideoBuffer buffer) {
        this.renderBitmap(ImageUtility.bufferToBitmap(buffer));
    }

    public void renderBitmap(final Bitmap bitmap) {
        if (bitmap != null) {
            Utility.dispatchToMainThread(new IAction0(){

                public void invoke() {
                    boolean viewMirror;
                    LayoutScale viewScale = ImageViewSink.this._viewScale;
                    if (viewScale != ImageViewSink.this._lastViewScale) {
                        if (viewScale == LayoutScale.Contain) {
                            ImageViewSink.this._view.setScaleType(ImageView.ScaleType.FIT_CENTER);
                        } else if (viewScale == LayoutScale.Cover) {
                            ImageViewSink.this._view.setScaleType(ImageView.ScaleType.CENTER_CROP);
                        } else if (viewScale == LayoutScale.Stretch) {
                            ImageViewSink.this._view.setScaleType(ImageView.ScaleType.FIT_XY);
                        }
                        ImageViewSink.this._lastViewScale = viewScale;
                    }
                    if ((viewMirror = ImageViewSink.this._viewMirror) != ImageViewSink.this._lastViewMirror) {
                        if (viewMirror) {
                            ImageViewSink.this._view.setScaleX(-1.0f);
                        } else {
                            ImageViewSink.this._view.setScaleX(1.0f);
                        }
                        ImageViewSink.this._lastViewMirror = viewMirror;
                    }
                    ImageViewSink.this._view.setImageBitmap(bitmap);
                }
            });
        }
    }
}

