/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.android;

import android.content.Context;
import android.hardware.Camera;
import android.os.Process;
import android.os.SystemClock;
import android.view.Display;
import android.view.OrientationEventListener;
import android.view.WindowManager;
import fm.icelink.DataBuffer;
import fm.icelink.Future;
import fm.icelink.IAction0;
import fm.icelink.IAction1;
import fm.icelink.Log;
import fm.icelink.ManagedThread;
import fm.icelink.ParseAssistant;
import fm.icelink.Promise;
import fm.icelink.SourceInput;
import fm.icelink.VideoBuffer;
import fm.icelink.VideoConfig;
import fm.icelink.VideoFormat;
import fm.icelink.VideoFrame;
import fm.icelink.VideoSource;
import fm.icelink.android.CameraPreview;
import java.util.ArrayList;

public class CameraSource
extends VideoSource {
    private VideoConfig config;
    private Camera camera = null;
    private CameraPreview preview = null;
    private float desiredFrameDuration = 0.0f;
    private long lastTimestamp = -1L;
    private Object threadLock = new Object();
    private byte[] threadData = null;
    private OrientationEventListener orientationEventListener;
    private Display defaultDisplay;
    private int selectedWidth;
    private int selectedHeight;
    private int bufferOrientation = 0;
    private int lastRotation = -1;
    private int cameraId = 0;
    private volatile boolean isCapturing = false;
    private volatile boolean isStopped = true;

    public Camera getCamera() {
        return this.camera;
    }

    public CameraPreview getPreview() {
        return this.preview;
    }

    public SourceInput[] getInputs() {
        ArrayList<SourceInput> inputs = new ArrayList<SourceInput>();
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        for (int i = 0; i < Camera.getNumberOfCameras(); ++i) {
            Camera.getCameraInfo((int)i, (Camera.CameraInfo)cameraInfo);
            inputs.add(CameraSource.sourceInputFromCameraInfo(cameraInfo, i));
        }
        return inputs.toArray(new SourceInput[inputs.size()]);
    }

    public SourceInput getFrontInput() {
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        for (int i = 0; i < Camera.getNumberOfCameras(); ++i) {
            Camera.getCameraInfo((int)i, (Camera.CameraInfo)cameraInfo);
            if (cameraInfo.facing != 1) continue;
            return CameraSource.sourceInputFromCameraInfo(cameraInfo, i);
        }
        return null;
    }

    public SourceInput getBackInput() {
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        for (int i = 0; i < Camera.getNumberOfCameras(); ++i) {
            Camera.getCameraInfo((int)i, (Camera.CameraInfo)cameraInfo);
            if (cameraInfo.facing != 0) continue;
            return CameraSource.sourceInputFromCameraInfo(cameraInfo, i);
        }
        return null;
    }

    private static SourceInput sourceInputFromCameraInfo(Camera.CameraInfo cameraInfo, int index) {
        String name = cameraInfo.facing == 1 ? "Front-Facing Camera" : "Back-Facing Camera";
        return new SourceInput(Integer.toString(index), name);
    }

    public String getLabel() {
        return "Android Camera Source";
    }

    public CameraSource(CameraPreview preview, VideoConfig config) {
        super(VideoFormat.getNv21());
        if (preview == null) {
            throw new RuntimeException("Preview cannot be null.");
        }
        Context context = preview.getContext();
        if (context.checkCallingOrSelfPermission("android.permission.CAMERA") != 0) {
            throw new RuntimeException("Video capture permission has not been granted. Please add android.permission.CAMERA to your application manifest.");
        }
        this.preview = preview;
        this.config = config;
        this.defaultDisplay = ((WindowManager)context.getApplicationContext().getSystemService("window")).getDefaultDisplay();
        this.setRotation(this.defaultDisplay);
        this.orientationEventListener = new OrientationEventListener(context.getApplicationContext(), 3){

            public void onOrientationChanged(int arg0) {
                CameraSource.this.setRotation(CameraSource.this.defaultDisplay);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setRotation(Display display) {
        int cameraRotate;
        int rotation = display.getRotation();
        if (rotation == this.lastRotation) {
            return false;
        }
        this.lastRotation = rotation;
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        Camera.getCameraInfo((int)this.cameraId, (Camera.CameraInfo)cameraInfo);
        int degrees = 0;
        switch (rotation) {
            case 0: {
                degrees = 0;
                break;
            }
            case 1: {
                degrees = 90;
                break;
            }
            case 2: {
                degrees = 180;
                break;
            }
            case 3: {
                degrees = 270;
            }
        }
        if (cameraInfo.facing == 1) {
            this.bufferOrientation = cameraRotate = (cameraInfo.orientation + degrees) % 360;
            cameraRotate = (360 - cameraRotate) % 360;
        } else {
            this.bufferOrientation = cameraRotate = (cameraInfo.orientation - degrees + 360) % 360;
        }
        Object object = this.threadLock;
        synchronized (object) {
            if (this.camera != null) {
                this.camera.setDisplayOrientation(cameraRotate);
            }
        }
        this.preview.setCameraRotation(cameraRotate);
        return true;
    }

    protected Future<Object> doStart() {
        final Promise promise = new Promise();
        ManagedThread.dispatch((IAction0)new IAction0(){

            public void invoke() {
                try {
                    CameraSource.this.desiredFrameDuration = 1000.0f / (float)CameraSource.this.config.getFrameRate();
                    if (CameraSource.this.orientationEventListener.canDetectOrientation()) {
                        CameraSource.this.orientationEventListener.enable();
                    } else {
                        Log.error((String)"Orientation event listener cannot detect orientation changes!");
                    }
                    SourceInput input = CameraSource.this.getInput();
                    if (input == null) {
                        input = CameraSource.this.getFrontInput();
                    }
                    if (input == null) {
                        input = CameraSource.this.getBackInput();
                    }
                    if (input == null) {
                        throw new Exception("Device has no available cameras.");
                    }
                    CameraSource.this.cameraId = ParseAssistant.parseIntegerValue((String)input.getId());
                    CameraSource.this.camera = Camera.open((int)CameraSource.this.cameraId);
                    Camera.Parameters parameters = CameraSource.this.camera.getParameters();
                    parameters.setPreviewFormat(17);
                    Camera.Size selectedSize = null;
                    int selectedSizeDistance = -1;
                    for (Camera.Size size : parameters.getSupportedPreviewSizes()) {
                        int sizeWidthDistance = Math.abs(size.width - CameraSource.this.config.getWidth());
                        int sizeHeightDistance = Math.abs(size.height - CameraSource.this.config.getHeight());
                        int sizeDistance = sizeWidthDistance + sizeHeightDistance;
                        if (selectedSizeDistance != -1 && sizeDistance >= selectedSizeDistance) continue;
                        selectedSize = size;
                        selectedSizeDistance = sizeDistance;
                    }
                    if (selectedSize == null) {
                        throw new Exception("No supported preview size.");
                    }
                    CameraSource.this.selectedWidth = selectedSize.width;
                    CameraSource.this.selectedHeight = selectedSize.height;
                    parameters.setPreviewSize(CameraSource.this.selectedWidth, CameraSource.this.selectedHeight);
                    int[] selectedFpsRange = null;
                    int selectedFpsDistance = -1;
                    for (int[] fpsRange : parameters.getSupportedPreviewFpsRange()) {
                        int fpsMinDistance = Math.abs(fpsRange[0] - CameraSource.this.config.getFrameRate() * 1000);
                        int fpsMaxDistance = Math.abs(fpsRange[1] - CameraSource.this.config.getFrameRate() * 1000);
                        int fpsDistance = fpsMinDistance + fpsMaxDistance;
                        if (selectedFpsDistance != -1 && fpsDistance >= selectedFpsDistance) continue;
                        selectedFpsRange = fpsRange;
                        selectedFpsDistance = fpsDistance;
                    }
                    if (selectedFpsRange != null) {
                        parameters.setPreviewFpsRange((int)selectedFpsRange[0], (int)selectedFpsRange[1]);
                    }
                    String selectedFocusMode = null;
                    for (String focusMode : parameters.getSupportedFocusModes()) {
                        if (!focusMode.equals("continuous-video")) continue;
                        selectedFocusMode = focusMode;
                    }
                    if (selectedFocusMode != null) {
                        parameters.setFocusMode(selectedFocusMode);
                    }
                    CameraSource.this.camera.setParameters(parameters);
                    CameraSource.this.camera.setPreviewCallback(new Camera.PreviewCallback(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void onPreviewFrame(byte[] data, Camera camera) {
                            long timestamp = SystemClock.elapsedRealtime();
                            if (CameraSource.this.lastTimestamp != -1L && (float)(timestamp - CameraSource.this.lastTimestamp) < CameraSource.this.desiredFrameDuration) {
                                return;
                            }
                            CameraSource.this.lastTimestamp = timestamp;
                            Object object = CameraSource.this.threadLock;
                            synchronized (object) {
                                if (CameraSource.this.isCapturing) {
                                    CameraSource.access$1102(CameraSource.this, data);
                                    CameraSource.this.threadLock.notify();
                                }
                            }
                        }
                    });
                    CameraSource.this.setInput(input);
                    CameraSource.this.preview.setCamera(CameraSource.this.camera);
                    CameraSource.this.lastRotation = -1;
                    CameraSource.this.setRotation(CameraSource.this.defaultDisplay);
                    CameraSource.this.isCapturing = true;
                    CameraSource.this.isStopped = false;
                    ManagedThread thread = new ManagedThread((IAction1)new IAction1<ManagedThread>(){

                        public void invoke(ManagedThread thread) {
                            CameraSource.this.captureLoop(thread);
                        }
                    });
                    thread.start();
                    promise.resolve(null);
                }
                catch (Exception ex) {
                    promise.reject(ex);
                }
            }
        });
        return promise;
    }

    protected Future<Object> doStop() {
        final Promise promise = new Promise();
        ManagedThread.dispatch((IAction0)new IAction0(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void invoke() {
                try {
                    CameraSource.this.isCapturing = false;
                    Object object = CameraSource.this.threadLock;
                    synchronized (object) {
                        CameraSource.access$1102(CameraSource.this, null);
                        CameraSource.this.threadLock.notify();
                    }
                    while (!CameraSource.this.isStopped) {
                        ManagedThread.sleep((int)10);
                    }
                    CameraSource.this.preview.setCamera(null);
                    if (CameraSource.this.camera != null) {
                        CameraSource.this.camera.setPreviewCallback(null);
                        object = CameraSource.this.threadLock;
                        synchronized (object) {
                            CameraSource.this.camera.release();
                            CameraSource.this.camera = null;
                        }
                    }
                    if (CameraSource.this.orientationEventListener != null) {
                        CameraSource.this.orientationEventListener.disable();
                    }
                    promise.resolve(null);
                }
                catch (Exception ex) {
                    promise.reject(ex);
                }
            }
        });
        return promise;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void captureLoop(ManagedThread thread) {
        if (Process.getThreadPriority((int)Process.myTid()) != -1) {
            Process.setThreadPriority((int)-1);
        }
        byte[] data = null;
        while (this.isCapturing) {
            if (data != null) {
                try {
                    DataBuffer videoPlane = DataBuffer.wrap(data, (int)0, (int)data.length);
                    VideoBuffer buffer = new VideoBuffer(this.selectedWidth, this.selectedHeight, videoPlane, VideoFormat.getNv21());
                    buffer.setOrientation(this.bufferOrientation);
                    this.raiseFrame(new VideoFrame(buffer));
                }
                catch (Exception ex) {
                    Log.error((String)"Could not raise camera image.", (Exception)ex);
                }
            }
            Object object = this.threadLock;
            synchronized (object) {
                if (this.threadData == null && this.isCapturing) {
                    try {
                        this.threadLock.wait();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                data = this.threadData;
                this.threadData = null;
            }
        }
        this.isStopped = true;
    }

    static /* synthetic */ byte[] access$1102(CameraSource x0, byte[] x1) {
        x0.threadData = x1;
        return x1;
    }
}

