/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.android;

import android.media.AudioTrack;
import android.os.Process;
import fm.icelink.AudioBuffer;
import fm.icelink.AudioConfig;
import fm.icelink.AudioFormat;
import fm.icelink.AudioFrame;
import fm.icelink.AudioSink;
import fm.icelink.BitAssistant;
import fm.icelink.DataBuffer;
import fm.icelink.IAction1;
import fm.icelink.IAudioSource;
import fm.icelink.IMediaSource;
import fm.icelink.Log;
import fm.icelink.ManagedThread;
import fm.icelink.pcm.Format;

public class AudioTrackSink
extends AudioSink {
    private int audioStreamType = 3;
    private AudioTrack audioTrack;
    private int sampleLength = 2;
    private int latencyMillis = 200;
    private int bufferLengthMillis = this.latencyMillis * 2;
    private int samplesReadIndex;
    private int samplesWriteIndex;
    private long samplesReadCount;
    private long samplesWriteCount;
    private byte[] samples;
    private int chunkSize;
    private int chunkTime;
    private int chunkDivisor = 2;
    private volatile boolean isRendering;
    private volatile boolean isStopped;

    public int getAudioStreamType() {
        return this.audioStreamType;
    }

    public void setAudioStreamType(int audioStreamType) {
        this.audioStreamType = audioStreamType;
    }

    public String getLabel() {
        return "Android AudioTrack Sink";
    }

    public static int getBufferDelay(AudioConfig config) {
        int clockRate = config.getClockRate();
        int channelCount = config.getChannelCount();
        int channelConfig = channelCount == 1 ? 16 : 12;
        int minBufferSizeInBytes = AudioTrack.getMinBufferSize((int)clockRate, (int)channelConfig, (int)2);
        int bytesPerMilli = clockRate * channelCount * 2 / 1000;
        return minBufferSizeInBytes / bytesPerMilli;
    }

    public AudioTrackSink(AudioConfig config) {
        super((AudioFormat)new Format(config));
        this.initialize();
    }

    public AudioTrackSink(IAudioSource source) {
        this(source.getConfig());
        this.addSource((IMediaSource)source);
    }

    public AudioTrackSink(IAudioSource[] sources) {
        this(sources[0].getConfig());
        this.addSources((IMediaSource[])sources);
    }

    private void initialize() {
        int clockRate = ((AudioFormat)this.getInputFormat()).getClockRate();
        int channelCount = ((AudioFormat)this.getInputFormat()).getChannelCount();
        int channelConfig = channelCount == 1 ? 4 : 12;
        int bufferSize = AudioTrack.getMinBufferSize((int)clockRate, (int)channelConfig, (int)2);
        this.chunkSize = bufferSize / this.chunkDivisor;
        this.chunkTime = this.chunkSize * 1000 / (clockRate * channelCount * this.sampleLength);
        this.samplesReadIndex = 0;
        this.samplesWriteIndex = 0;
        this.samplesReadCount = 0L;
        this.samplesWriteCount = 0L;
        this.samples = new byte[clockRate * channelCount * this.sampleLength * this.bufferLengthMillis / 1000];
        this.audioTrack = new AudioTrack(this.getAudioStreamType(), clockRate, channelConfig, 2, bufferSize, 1);
        if (this.audioTrack.getState() != 1) {
            throw new RuntimeException("Device does not support requested audio format.");
        }
        this.isRendering = true;
        ManagedThread thread = new ManagedThread((IAction1)new IAction1<ManagedThread>(){

            public void invoke(ManagedThread thread) {
                AudioTrackSink.this.renderLoop();
            }
        });
        thread.start();
    }

    protected void doProcessFrame(AudioFrame frame, AudioBuffer inputBuffer) {
        if (this.audioTrack == null) {
            throw new RuntimeException("AudioTrackSink must be opened before a frame can be processed!");
        }
        int available = (int)(this.samplesWriteCount - this.samplesReadCount);
        DataBuffer inputDataBuffer = inputBuffer.getDataBuffer();
        int length = inputDataBuffer.getLength();
        if (available + length <= this.samples.length) {
            this.writeToSamples(inputDataBuffer.getData(), inputDataBuffer.getIndex(), inputDataBuffer.getLength());
        } else {
            Log.debug((String)"AudioTrackSink buffer overrun.");
        }
    }

    protected void doDestroy() {
        this.isRendering = false;
        while (!this.isStopped) {
            ManagedThread.sleep((int)10);
        }
        if (this.audioTrack != null) {
            this.audioTrack.release();
        }
    }

    private void writeToSamples(byte[] source, int index, int length) {
        if (this.samplesWriteIndex + length < this.samples.length) {
            System.arraycopy(source, index, this.samples, this.samplesWriteIndex, length);
            this.samplesWriteIndex += length;
        } else {
            int readIndex = index;
            int length1 = this.samples.length - this.samplesWriteIndex;
            System.arraycopy(source, readIndex, this.samples, this.samplesWriteIndex, length1);
            this.samplesWriteIndex = 0;
            int length2 = length - length1;
            System.arraycopy(source, readIndex += length1, this.samples, this.samplesWriteIndex, length2);
            this.samplesWriteIndex += length2;
        }
        if (this.samplesWriteIndex == this.samples.length) {
            this.samplesWriteIndex = 0;
        }
        this.samplesWriteCount += (long)length;
    }

    private void readFromSamples(byte[] target, int index, int length) {
        if (this.samplesReadIndex + length < this.samples.length) {
            System.arraycopy(this.samples, this.samplesReadIndex, target, index, length);
            this.samplesReadIndex += length;
        } else {
            int writeIndex = index;
            int length1 = this.samples.length - this.samplesReadIndex;
            System.arraycopy(this.samples, this.samplesReadIndex, target, writeIndex, length1);
            this.samplesReadIndex = 0;
            int length2 = length - length1;
            System.arraycopy(this.samples, this.samplesReadIndex, target, writeIndex += length1, length2);
            this.samplesReadIndex += length2;
        }
        if (this.samplesReadIndex == this.samples.length) {
            this.samplesReadIndex = 0;
        }
        this.samplesReadCount += (long)length;
    }

    private void renderLoop() {
        if (Process.getThreadPriority((int)Process.myTid()) != -19) {
            Process.setThreadPriority((int)-19);
        }
        int clockRate = ((AudioFormat)this.getInputFormat()).getClockRate();
        int channelCount = ((AudioFormat)this.getInputFormat()).getChannelCount();
        long playbackState = 0L;
        long originNanos = System.nanoTime();
        long nanosPerMilli = 1000000L;
        long writtenMillis = 0L;
        byte[] data = new byte[this.chunkSize];
        while (this.isRendering) {
            long elapsedMillis = (System.nanoTime() - originNanos) / nanosPerMilli;
            while (writtenMillis < elapsedMillis) {
                int available = (int)(this.samplesWriteCount - this.samplesReadCount);
                int availableMillis = (int)(this.samplesWriteCount * 1000L / (long)(clockRate * channelCount * this.sampleLength));
                if (availableMillis < this.latencyMillis) {
                    available = 0;
                }
                if (this.chunkSize <= available) {
                    this.readFromSamples(data, 0, this.chunkSize);
                } else if (available == 0) {
                    BitAssistant.set((byte[])data, (int)0, (int)this.chunkSize, (int)0);
                } else {
                    this.readFromSamples(data, 0, available);
                    int silenceLength = this.chunkSize - available;
                    BitAssistant.set((byte[])data, (int)available, (int)silenceLength, (int)0);
                    Log.debug((String)"AudioTrackSink buffer underrun.");
                }
                this.audioTrack.write(data, 0, this.chunkSize);
                writtenMillis += (long)this.chunkTime;
            }
            if (playbackState < (long)this.chunkDivisor && ++playbackState == 2L) {
                this.audioTrack.play();
            }
            try {
                Thread.sleep(this.chunkTime);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.audioTrack.stop();
        this.isStopped = true;
    }
}

