/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.vp9;

import fm.icelink.DataBuffer;
import fm.icelink.DataBufferStream;

class Packet {
    private boolean _endOfLayerFrame;
    private boolean _extendedPictureID;
    private boolean _flexibleMode;
    private DataBuffer _header;
    private boolean _interPicturePredictedLayerFrame;
    private boolean _layerIndicesPresent;
    private DataBuffer _payload;
    private short _pictureID;
    private boolean _pictureIDPresent;
    private boolean _scalabilityStructurePresent;
    private boolean _startOfLayerFrame;

    private static Packet extractV00(DataBuffer packetBuffer, DataBufferStream stream) {
        boolean flag;
        int num;
        Packet packet = new Packet();
        packet.setPictureIDPresent(stream.read1());
        packet.setInterPicturePredictedLayerFrame(stream.read1());
        packet.setLayerIndicesPresent(stream.read1());
        packet.setFlexibleMode(stream.read1());
        packet.setStartOfLayerFrame(stream.read1());
        packet.setEndOfLayerFrame(stream.read1());
        packet.setScalabilityStructurePresent(stream.read1());
        stream.nextByte();
        if (packet.getPictureIDPresent()) {
            packet.setExtendedPictureID(stream.read1());
            if (packet.getExtendedPictureID()) {
                packet.setPictureID((short)stream.read15());
            } else {
                packet.setPictureID((short)stream.read7());
            }
        }
        if (packet.getLayerIndicesPresent()) {
            if (packet.getFlexibleMode()) {
                num = stream.read3();
                flag = stream.read1();
                int num2 = stream.read3();
                boolean bl = stream.read1();
            } else {
                stream.read8();
                stream.read8();
            }
        }
        if (packet.getInterPicturePredictedLayerFrame() && packet.getFlexibleMode()) {
            boolean flag3 = false;
            do {
                int num3 = stream.read7();
            } while (flag3 = stream.read1());
        }
        if (packet.getScalabilityStructurePresent()) {
            int num6;
            int num4 = stream.read3() + 1;
            boolean flag4 = stream.read1();
            int num5 = stream.read4() + 1;
            if (flag4) {
                for (num6 = 0; num6 < num4; ++num6) {
                    int num7 = stream.read16();
                    int n = stream.read16();
                }
            }
            for (num6 = 0; num6 < num5; ++num6) {
                num = stream.read3();
                flag = stream.read1();
                int num9 = stream.read2();
                stream.nextByte();
                for (int i = 0; i < num9; ++i) {
                    stream.read8();
                }
            }
        }
        packet.setPayload(packetBuffer.subset(stream.getPosition()));
        return packet;
    }

    private static Packet extractV02(DataBuffer packetBuffer, DataBufferStream stream) {
        boolean flag;
        int num;
        Packet packet = new Packet();
        packet.setPictureIDPresent(stream.read1());
        packet.setInterPicturePredictedLayerFrame(stream.read1());
        packet.setLayerIndicesPresent(stream.read1());
        packet.setFlexibleMode(stream.read1());
        packet.setStartOfLayerFrame(stream.read1());
        packet.setEndOfLayerFrame(stream.read1());
        packet.setScalabilityStructurePresent(stream.read1());
        if (stream.read1()) {
            throw new RuntimeException(new Exception("VP9 RTP header failed sanity check for spec version 02."));
        }
        if (packet.getPictureIDPresent()) {
            packet.setExtendedPictureID(stream.read1());
            if (packet.getExtendedPictureID()) {
                packet.setPictureID((short)stream.read15());
            } else {
                packet.setPictureID((short)stream.read7());
            }
        }
        if (packet.getLayerIndicesPresent()) {
            num = stream.read3();
            flag = stream.read1();
            int num2 = stream.read3();
            boolean flag2 = stream.read1();
            if (!packet.getFlexibleMode()) {
                stream.read8();
            }
        }
        if (packet.getInterPicturePredictedLayerFrame() && packet.getFlexibleMode()) {
            boolean flag3 = false;
            do {
                int num3 = stream.read7();
            } while (flag3 = stream.read1());
        }
        if (packet.getScalabilityStructurePresent()) {
            int num6;
            int num4 = stream.read3() + 1;
            boolean flag4 = stream.read1();
            boolean flag5 = stream.read1();
            if (stream.read3() != 0) {
                throw new RuntimeException(new Exception("VP9 RTP Scalability Structure failed sanity check for spec version 02."));
            }
            if (flag4) {
                for (num6 = 0; num6 < num4; ++num6) {
                    int num7 = stream.read16();
                    int n = stream.read16();
                }
            }
            if (flag5) {
                int num9 = stream.read8();
                for (num6 = 0; num6 < num9; ++num6) {
                    num = stream.read3();
                    flag = stream.read1();
                    int num10 = stream.read2();
                    stream.nextByte();
                    for (int i = 0; i < num10; ++i) {
                        stream.read8();
                    }
                }
            }
        }
        packet.setPayload(packetBuffer.subset(stream.getPosition()));
        return packet;
    }

    private void generateHeader() {
        this.setHeader(DataBuffer.allocate(this.getHeaderLength()));
        this.getHeader().write1(this.getPictureIDPresent(), 0, 0);
        this.getHeader().write1(this.getInterPicturePredictedLayerFrame(), 0, 1);
        this.getHeader().write1(this.getLayerIndicesPresent(), 0, 2);
        this.getHeader().write1(this.getFlexibleMode(), 0, 3);
        this.getHeader().write1(this.getStartOfLayerFrame(), 0, 4);
        this.getHeader().write1(this.getEndOfLayerFrame(), 0, 5);
        this.getHeader().write1(this.getScalabilityStructurePresent(), 0, 6);
        this.getHeader().write1(this.getReservedBit(), 0, 7);
    }

    public DataBuffer getBuffer() {
        if (this.getHeader() == null) {
            this.generateHeader();
        }
        return this.getHeader().append(this.getPayload());
    }

    public boolean getEndOfLayerFrame() {
        return this._endOfLayerFrame;
    }

    public boolean getExtendedPictureID() {
        return this._extendedPictureID;
    }

    public int getFixedHeaderLength() {
        return 1;
    }

    public boolean getFlexibleMode() {
        return this._flexibleMode;
    }

    public DataBuffer getHeader() {
        return this._header;
    }

    public int getHeaderLength() {
        return this.getFixedHeaderLength() + this.getVariableHeaderLength();
    }

    public boolean getInterPicturePredictedLayerFrame() {
        return this._interPicturePredictedLayerFrame;
    }

    public boolean getLayerIndicesPresent() {
        return this._layerIndicesPresent;
    }

    public DataBuffer getPayload() {
        return this._payload;
    }

    public short getPictureID() {
        return this._pictureID;
    }

    public boolean getPictureIDPresent() {
        return this._pictureIDPresent;
    }

    public boolean getReservedBit() {
        return false;
    }

    public boolean getScalabilityStructurePresent() {
        return this._scalabilityStructurePresent;
    }

    public boolean getStartOfLayerFrame() {
        return this._startOfLayerFrame;
    }

    public int getVariableHeaderLength() {
        return (this.getPictureIDPresent() ? 1 : 0) + (this.getExtendedPictureID() ? 1 : 0);
    }

    public Packet() {
    }

    public Packet(DataBuffer payload, boolean startOfPartition, byte partitionIndex) {
        this(payload, startOfPartition);
    }

    public Packet(DataBuffer payload, boolean startOfLayerFrame) {
        this.setPayload(payload);
        this.setStartOfLayerFrame(startOfLayerFrame);
    }

    public void setEndOfLayerFrame(boolean value) {
        this._endOfLayerFrame = value;
    }

    public void setExtendedPictureID(boolean value) {
        this._extendedPictureID = value;
    }

    public void setFlexibleMode(boolean value) {
        this._flexibleMode = value;
    }

    private void setHeader(DataBuffer value) {
        this._header = value;
    }

    public void setInterPicturePredictedLayerFrame(boolean value) {
        this._interPicturePredictedLayerFrame = value;
    }

    public void setLayerIndicesPresent(boolean value) {
        this._layerIndicesPresent = value;
    }

    public void setPayload(DataBuffer value) {
        this._payload = value;
    }

    public void setPictureID(short value) {
        this._pictureID = value;
    }

    public void setPictureIDPresent(boolean value) {
        this._pictureIDPresent = value;
    }

    public void setScalabilityStructurePresent(boolean value) {
        this._scalabilityStructurePresent = value;
    }

    public void setStartOfLayerFrame(boolean value) {
        this._startOfLayerFrame = value;
    }

    public static Packet wrap(DataBuffer packetBuffer) {
        DataBufferStream stream = new DataBufferStream(packetBuffer);
        stream.getBuffer().setLittleEndian(false);
        return Packet.extractV02(packetBuffer, stream);
    }
}

