/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.stun.turn;

import fm.icelink.AddressType;
import fm.icelink.Binary;
import fm.icelink.BitAssistant;
import fm.icelink.ByteCollection;
import fm.icelink.Global;
import fm.icelink.IntegerExtensions;
import fm.icelink.LocalNetwork;
import fm.icelink.StringExtensions;
import fm.icelink.TransportAddress;
import fm.icelink.stun.AddressFamily;
import fm.icelink.stun.Attribute;

public class XorRelayedAddressAttribute
extends Attribute {
    private String _ipAddress;
    private int _port;
    private byte[] _transactionId;

    public static XorRelayedAddressAttribute fromValueBytes(byte[] valueBytes, byte[] transactionId) {
        AddressType type;
        if (valueBytes[1] == AddressFamily.getIPv4()) {
            type = AddressType.IPv4;
        } else if (valueBytes[1] == AddressFamily.getIPv6()) {
            type = AddressType.IPv6;
        } else {
            return null;
        }
        byte[] portBytes = BitAssistant.subArray(valueBytes, 2, 2);
        Attribute.xorPort(portBytes, transactionId);
        int num = Binary.fromBytes16(portBytes, 0, false);
        int count = Global.equals((Object)type, (Object)AddressType.IPv4) ? 4 : 16;
        byte[] ipAddressBytes = BitAssistant.subArray(valueBytes, 4, count);
        Attribute.xorIPAddress(ipAddressBytes, transactionId);
        String str = StringExtensions.empty;
        try {
            str = TransportAddress.sanitizeIPAddress(LocalNetwork.getAddress(ipAddressBytes));
        }
        catch (Exception exception1) {
            str = Global.equals((Object)type, (Object)AddressType.IPv4) ? Attribute.getBlankIPv4Address() : Attribute.getBlankIPv6Address();
        }
        XorRelayedAddressAttribute attribute = new XorRelayedAddressAttribute();
        attribute.setTransactionId(transactionId);
        attribute.setPort(num);
        attribute.setIPAddress(str);
        return attribute;
    }

    public String getIPAddress() {
        return this._ipAddress;
    }

    public int getPort() {
        return this._port;
    }

    public byte[] getTransactionId() {
        return this._transactionId;
    }

    @Override
    protected byte[] getValueBytes() {
        byte[] addressBytes;
        ByteCollection bytes = new ByteCollection();
        bytes.add((byte)0);
        AddressType addressType = LocalNetwork.getAddressType(this.getIPAddress());
        if (Global.equals((Object)addressType, (Object)AddressType.IPv4)) {
            bytes.add((byte)1);
        } else if (Global.equals((Object)addressType, (Object)AddressType.IPv6)) {
            bytes.add((byte)2);
        }
        byte[] portBytes = Binary.toBytes16(this.getPort(), false);
        Attribute.xorPort(portBytes, this.getTransactionId());
        bytes.addRange(portBytes);
        try {
            addressBytes = LocalNetwork.getAddressBytes(this.getIPAddress());
        }
        catch (Exception exception1) {
            addressBytes = Global.equals((Object)addressType, (Object)AddressType.IPv4) ? Attribute.getBlankIPv4AddressBytes() : Attribute.getBlankIPv6AddressBytes();
        }
        Attribute.xorIPAddress(addressBytes, this.getTransactionId());
        bytes.addRange(addressBytes);
        return bytes.toArray();
    }

    public void setIPAddress(String value) {
        this._ipAddress = value;
    }

    public void setPort(int value) {
        this._port = value;
    }

    private void setTransactionId(byte[] value) {
        this._transactionId = value;
    }

    public String toString() {
        return StringExtensions.format("XOR-RELAYED-ADDRESS {0}:{1}", this.getIPAddress(), IntegerExtensions.toString(this.getPort()));
    }

    public XorRelayedAddressAttribute(String ipAddress, int port, byte[] transactionId) {
        this.setIPAddress(TransportAddress.sanitizeIPAddress(ipAddress));
        this.setPort(port);
        this.setTransactionId(transactionId);
    }

    private XorRelayedAddressAttribute() {
    }
}

