/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.stun;

import fm.icelink.ArrayExtensions;
import fm.icelink.ByteCollection;
import fm.icelink.IntegerExtensions;
import fm.icelink.StringExtensions;
import fm.icelink.Utf8;
import fm.icelink.stun.Attribute;

public class ErrorCodeAttribute
extends Attribute {
    private int __code;
    private String __reason;

    public ErrorCodeAttribute(int code, String reason) {
        this.setCode(code);
        this.setReason(reason != null ? reason : "");
    }

    public ErrorCodeAttribute(int code) {
        this(code, null);
    }

    private ErrorCodeAttribute() {
    }

    public static ErrorCodeAttribute fromValueBytes(byte[] valueBytes) {
        byte num = valueBytes[2];
        byte num2 = valueBytes[3];
        int num3 = num * 100 + num2;
        String str = Utf8.decode(valueBytes, 4, ArrayExtensions.getLength(valueBytes) - 4).trim();
        ErrorCodeAttribute attribute = new ErrorCodeAttribute();
        attribute.setCode(num3);
        attribute.setReason(str);
        return attribute;
    }

    public int getCode() {
        return this.__code;
    }

    public String getReason() {
        return this.__reason;
    }

    @Override
    protected byte[] getValueBytes() {
        ByteCollection bytes = new ByteCollection();
        bytes.add((byte)0);
        bytes.add((byte)0);
        byte b = (byte)(this.getCode() / 100);
        bytes.add(b);
        byte num2 = (byte)(this.getCode() % 100);
        bytes.add(num2);
        bytes.addRange(Utf8.encode(this.getReason()));
        return bytes.toArray();
    }

    public void setCode(int value) {
        if (value < 300 || value > 699) {
            throw new RuntimeException(new Exception("code must be in the range of 300 to 699."));
        }
        this.__code = value;
    }

    public void setReason(String value) {
        if (StringExtensions.getLength(value) > 127) {
            throw new RuntimeException(new Exception("reason must have fewer than 128 characters."));
        }
        this.__reason = value;
    }

    public String toString() {
        return StringExtensions.format("ERROR-CODE {0} {1}", IntegerExtensions.toString(this.getCode()), this.getReason());
    }
}

