/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.sdp;

import fm.icelink.ArrayExtensions;
import fm.icelink.ArrayListExtensions;
import fm.icelink.StreamDirection;
import fm.icelink.StringBuilderExtensions;
import fm.icelink.StringExtensions;
import fm.icelink.sdp.Attribute;
import fm.icelink.sdp.AttributeCollection;
import fm.icelink.sdp.AttributeType;
import fm.icelink.sdp.Bandwidth;
import fm.icelink.sdp.ConnectionData;
import fm.icelink.sdp.CryptoAttribute;
import fm.icelink.sdp.EncryptionKey;
import fm.icelink.sdp.MediaDescription;
import fm.icelink.sdp.Origin;
import fm.icelink.sdp.SetupAttribute;
import fm.icelink.sdp.TimeDescription;
import fm.icelink.sdp.TimeZones;
import fm.icelink.sdp.Timing;
import fm.icelink.sdp.Utility;
import fm.icelink.sdp.ice.FingerprintAttribute;
import fm.icelink.sdp.ice.PasswordAttribute;
import fm.icelink.sdp.ice.UfragAttribute;
import java.net.URI;
import java.util.ArrayList;

public class Message {
    private ArrayList<Bandwidth> __bandwidths = new ArrayList();
    private ArrayList<MediaDescription> __mediaDescriptions;
    private AttributeCollection __sessionAttributes;
    private ArrayList<TimeDescription> __timeDescriptions = new ArrayList();
    private ConnectionData _connectionData;
    private String _emailAddress;
    private EncryptionKey _encryptionKey;
    private Origin _origin;
    private String _phoneNumber;
    private String _protocolVersion;
    private String _sessionInformation;
    private String _sessionName;
    private TimeZones _timeZoneAdjustments;
    private URI _uri;

    public void addBandwidth(Bandwidth bandwidth) {
        this.__bandwidths.add(bandwidth);
    }

    public void addMediaDescription(MediaDescription mediaDescription) {
        this.__mediaDescriptions.add(mediaDescription);
    }

    public void addSessionAttribute(Attribute attribute) {
        if (!Attribute.isSessionLevel(attribute.getClass())) {
            if (Attribute.isMediaLevel(attribute.getClass())) {
                throw new RuntimeException(new Exception("Attribute is media-only."));
            }
            throw new RuntimeException(new Exception("Attribute is not registered."));
        }
        this.__sessionAttributes.addAttribute(attribute);
    }

    public void addTimeDescription(TimeDescription timeDescription) {
        this.__timeDescriptions.add(timeDescription);
    }

    public Bandwidth[] getBandwidths() {
        return this.__bandwidths.toArray(new Bandwidth[0]);
    }

    public ConnectionData getConnectionData() {
        return this._connectionData;
    }

    public String getEmailAddress() {
        return this._emailAddress;
    }

    public EncryptionKey getEncryptionKey() {
        return this._encryptionKey;
    }

    public MediaDescription[] getMediaDescriptions() {
        return this.__mediaDescriptions.toArray(new MediaDescription[0]);
    }

    public Origin getOrigin() {
        return this._origin;
    }

    public String getPhoneNumber() {
        return this._phoneNumber;
    }

    public String getProtocolVersion() {
        return this._protocolVersion;
    }

    public Attribute[] getSessionAttributes() {
        return this.__sessionAttributes.toArray();
    }

    public String getSessionInformation() {
        return this._sessionInformation;
    }

    public CryptoAttribute[] getSessionLevelCryptoAttributes() {
        return MediaDescription.getCryptoAttributes(this.__sessionAttributes);
    }

    public StreamDirection getSessionLevelDirection() {
        return MediaDescription.getStreamDirection(this.__sessionAttributes);
    }

    public FingerprintAttribute getSessionLevelFingerprintAttribute() {
        return MediaDescription.getFingerprintAttribute(this.__sessionAttributes);
    }

    public PasswordAttribute getSessionLevelIcePasswordAttribute() {
        return MediaDescription.getIcePasswordAttribute(this.__sessionAttributes);
    }

    public UfragAttribute getSessionLevelIceUfragAttribute() {
        return MediaDescription.getIceUfragAttribute(this.__sessionAttributes);
    }

    public boolean getSessionLevelRtcpMultiplexingSupport() {
        return MediaDescription.getRtcpMultiplexingSupport(this.__sessionAttributes);
    }

    public SetupAttribute getSessionLevelSetupAttribute() {
        return MediaDescription.getSetupAttribute(this.__sessionAttributes);
    }

    public String getSessionName() {
        return this._sessionName;
    }

    public TimeDescription[] getTimeDescriptions() {
        return this.__timeDescriptions.toArray(new TimeDescription[0]);
    }

    public TimeZones getTimeZoneAdjustments() {
        return this._timeZoneAdjustments;
    }

    public URI getUri() {
        return this._uri;
    }

    public Message(Origin origin, String sessionName, TimeDescription[] timeDescriptions) {
        this.__sessionAttributes = new AttributeCollection();
        this.__mediaDescriptions = new ArrayList();
        if (origin == null) {
            throw new RuntimeException(new Exception("origin cannot be null."));
        }
        if (timeDescriptions == null) {
            timeDescriptions = new TimeDescription[]{new TimeDescription(new Timing())};
        }
        if (sessionName == null || StringExtensions.isNullOrEmpty(sessionName.trim())) {
            sessionName = "-";
        }
        this.setProtocolVersion("0");
        this.setOrigin(origin);
        this.setSessionName(sessionName.trim());
        ArrayListExtensions.addRange(this.__timeDescriptions, timeDescriptions);
    }

    public Message(Origin origin) {
        this(origin, null);
    }

    public Message(Origin origin, String sessionName) {
        this(origin, sessionName, null);
    }

    public static Message parse(String s) {
        Object[] strArray = Utility.splitAndClean(s);
        if (strArray[0].charAt(0) != 'v' || strArray[1].charAt(0) != 'o' || strArray[2].charAt(0) != 's') {
            return null;
        }
        Origin origin = Origin.parse(strArray[1].substring(2));
        String sessionName = strArray[2].substring(2);
        Message message = new Message(origin, sessionName);
        message.removeTimeDescriptions();
        for (int i = 3; i < ArrayExtensions.getLength(strArray); ++i) {
            Object str4;
            int num2;
            Object str2 = strArray[i];
            if (((String)str2).charAt(0) == 'i') {
                message.setSessionInformation(((String)str2).substring(2));
                continue;
            }
            if (((String)str2).charAt(0) == 'u') {
                try {
                    message.setUri(new URI(((String)str2).substring(2)));
                }
                catch (Exception exception) {}
                continue;
            }
            if (((String)str2).charAt(0) == 'e') {
                message.setEmailAddress(((String)str2).substring(2));
                continue;
            }
            if (((String)str2).charAt(0) == 'p') {
                message.setPhoneNumber(((String)str2).substring(2));
                continue;
            }
            if (((String)str2).charAt(0) == 'c') {
                message.setConnectionData(ConnectionData.parse((String)str2));
                continue;
            }
            if (((String)str2).charAt(0) == 'b') {
                message.addBandwidth(Bandwidth.parse((String)str2));
                continue;
            }
            if (((String)str2).charAt(0) == 't') {
                Object str3 = str2;
                for (num2 = i + 1; num2 < ArrayExtensions.getLength(strArray) && ((String)(str4 = strArray[num2])).charAt(0) == 'r'; ++num2) {
                    str3 = StringExtensions.concat((String)str3, "\n", (String)str4);
                    ++i;
                }
                message.addTimeDescription(TimeDescription.parse((String)str3));
                continue;
            }
            if (((String)str2).charAt(0) == 'z') {
                message.setTimeZoneAdjustments(TimeZones.parse((String)str2));
                continue;
            }
            if (((String)str2).charAt(0) == 'k') {
                message.setEncryptionKey(EncryptionKey.parse((String)str2));
                continue;
            }
            if (((String)str2).charAt(0) == 'a') {
                message.addSessionAttribute(Attribute.parse((String)str2));
                continue;
            }
            if (((String)str2).charAt(0) != 'm') continue;
            Object str5 = str2;
            for (num2 = i + 1; num2 < ArrayExtensions.getLength(strArray) && ((String)(str4 = strArray[num2])).charAt(0) != 'm'; ++num2) {
                str5 = StringExtensions.concat((String)str5, "\n", (String)str4);
                ++i;
            }
            message.addMediaDescription(MediaDescription.parse((String)str5));
        }
        return message;
    }

    public boolean removeBandwidth(Bandwidth bandwidth) {
        return this.__bandwidths.remove(bandwidth);
    }

    public boolean removeMediaDescription(MediaDescription mediaDescription) {
        return this.__mediaDescriptions.remove(mediaDescription);
    }

    public boolean removeSessionAttribute(AttributeType attributeType) {
        return this.__sessionAttributes.remove(attributeType);
    }

    public boolean removeTimeDescription(TimeDescription timeDescription) {
        return this.__timeDescriptions.remove(timeDescription);
    }

    public void removeTimeDescriptions() {
        this.__timeDescriptions = new ArrayList();
    }

    public void setConnectionData(ConnectionData value) {
        this._connectionData = value;
    }

    public void setEmailAddress(String value) {
        this._emailAddress = value;
    }

    public void setEncryptionKey(EncryptionKey value) {
        this._encryptionKey = value;
    }

    private void setOrigin(Origin value) {
        this._origin = value;
    }

    public void setPhoneNumber(String value) {
        this._phoneNumber = value;
    }

    private void setProtocolVersion(String value) {
        this._protocolVersion = value;
    }

    public void setSessionInformation(String value) {
        this._sessionInformation = value;
    }

    private void setSessionName(String value) {
        this._sessionName = value;
    }

    public void setTimeZoneAdjustments(TimeZones value) {
        this._timeZoneAdjustments = value;
    }

    public void setUri(URI value) {
        this._uri = value;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        StringBuilderExtensions.append(builder, StringExtensions.concat("v=", this.getProtocolVersion(), "\r\n"));
        StringBuilderExtensions.append(builder, StringExtensions.concat("o=", this.getOrigin().toString(), "\r\n"));
        StringBuilderExtensions.append(builder, StringExtensions.concat("s=", this.getSessionName(), "\r\n"));
        if (this.getSessionInformation() != null) {
            StringBuilderExtensions.append(builder, StringExtensions.concat("i=", this.getSessionInformation(), "\r\n"));
        }
        if (this.getUri() != null) {
            StringBuilderExtensions.append(builder, StringExtensions.concat("u=", this.getUri().toString(), "\r\n"));
        }
        if (this.getEmailAddress() != null) {
            StringBuilderExtensions.append(builder, StringExtensions.concat("e=", this.getEmailAddress(), "\r\n"));
        }
        if (this.getPhoneNumber() != null) {
            StringBuilderExtensions.append(builder, StringExtensions.concat("p=", this.getPhoneNumber(), "\r\n"));
        }
        if (this.getConnectionData() != null) {
            StringBuilderExtensions.append(builder, StringExtensions.concat(this.getConnectionData().toString(), "\r\n"));
        }
        for (Bandwidth bandwidth : this.getBandwidths()) {
            StringBuilderExtensions.append(builder, StringExtensions.concat(bandwidth.toString(), "\r\n"));
        }
        for (TimeDescription description : this.getTimeDescriptions()) {
            StringBuilderExtensions.append(builder, description.toString());
        }
        if (this.getTimeZoneAdjustments() != null) {
            StringBuilderExtensions.append(builder, StringExtensions.concat(this.getTimeZoneAdjustments().toString(), "\r\n"));
        }
        if (this.getEncryptionKey() != null) {
            StringBuilderExtensions.append(builder, StringExtensions.concat(this.getEncryptionKey().toString(), "\r\n"));
        }
        for (Attribute attribute : this.getSessionAttributes()) {
            StringBuilderExtensions.append(builder, StringExtensions.concat(attribute.toString(), "\r\n"));
        }
        for (MediaDescription description2 : this.getMediaDescriptions()) {
            StringBuilderExtensions.append(builder, description2.toString());
        }
        return builder.toString();
    }

    public void updateSetupValue(String setupValue) {
        this.removeSessionAttribute(AttributeType.SetupAttribute);
        SetupAttribute attribute = new SetupAttribute(setupValue);
        this.addSessionAttribute(attribute);
    }
}

