/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.matroska;

import fm.icelink.AudioBuffer;
import fm.icelink.AudioFormat;
import fm.icelink.AudioFrame;
import fm.icelink.IActionDelegate0;
import fm.icelink.IAudioSource;
import fm.icelink.matroska.AudioRecorder;

public class AudioSink
extends fm.icelink.AudioSink {
    private Object __locker = new Object();
    private AudioRecorder __recorder;
    private String _path;

    public AudioSink(String path, IAudioSource source) {
        this(path, (AudioFormat)source.getOutputFormat());
        super.addSource(source);
    }

    public AudioSink(String path) {
        this.initialize(path);
    }

    public AudioSink(String path, AudioFormat format) {
        super(format);
        this.initialize(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void audioSink_OnDisabledChange() {
        if (super.getDisabled()) {
            Object object = this.__locker;
            synchronized (object) {
                if (this.__recorder != null) {
                    this.__recorder.close();
                    this.__recorder = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doDestroy() {
        Object object = this.__locker;
        synchronized (object) {
            if (this.__recorder != null) {
                this.__recorder.close();
                this.__recorder = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doProcessFrame(AudioFrame frame, AudioBuffer inputBuffer) {
        Object object = this.__locker;
        synchronized (object) {
            if (!super.getDisabled()) {
                if (this.__recorder == null) {
                    this.__recorder = new AudioRecorder(this.getPath(), (AudioFormat)super.getInputFormat());
                    this.__recorder.open();
                }
                this.__recorder.write(inputBuffer, frame.getTimestamp());
            }
        }
    }

    @Override
    public String getLabel() {
        return "Matroska Audio Sink";
    }

    public String getPath() {
        return this._path;
    }

    private void initialize(String path) {
        this.setPath(path);
        super.addOnDisabledChange(new IActionDelegate0(){

            @Override
            public String getId() {
                return "fm.icelink.matroska.AudioSink.audioSink_OnDisabledChange";
            }

            @Override
            public void invoke() {
                AudioSink.this.audioSink_OnDisabledChange();
            }
        });
    }

    private void setPath(String value) {
        this._path = value;
    }
}

