/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.Collection;
import fm.icelink.Error;
import fm.icelink.Future;
import fm.icelink.Global;
import fm.icelink.IAction0;
import fm.icelink.IAction1;
import fm.icelink.IActionDelegate0;
import fm.icelink.IActionDelegate1;
import fm.icelink.IElement;
import fm.icelink.IMediaElement;
import fm.icelink.IMediaSink;
import fm.icelink.IMediaSource;
import fm.icelink.ISink;
import fm.icelink.JsonSerializer;
import fm.icelink.License;
import fm.icelink.Log;
import fm.icelink.ManagedThread;
import fm.icelink.MediaBuffer;
import fm.icelink.MediaBufferCollection;
import fm.icelink.MediaControlFrame;
import fm.icelink.MediaFormat;
import fm.icelink.MediaFrame;
import fm.icelink.MediaSinkBase;
import fm.icelink.MediaSinkState;
import fm.icelink.MediaSourceCollection;
import fm.icelink.Promise;
import fm.icelink.SinkOutput;
import fm.icelink.Stream;
import fm.icelink.StringExtensions;
import fm.icelink.sdp.MediaDescription;
import java.util.ArrayList;
import java.util.List;

public abstract class MediaSink<TISource extends IMediaSource<TISource, TISink, TFrame, TBuffer, TBufferCollection, TFormat>, TISourceCollection extends MediaSourceCollection<TISource, TISink, TFrame, TBuffer, TBufferCollection, TFormat, TISourceCollection>, TISink extends IMediaSink<TISource, TISink, TFrame, TBuffer, TBufferCollection, TFormat>, TSink extends MediaSink<TISource, TISourceCollection, TISink, TSink, TFrame, TBuffer, TBufferCollection, TFormat>, TFrame extends MediaFrame<TBuffer, TBufferCollection, TFormat, TFrame>, TBuffer extends MediaBuffer<TFormat, TBuffer>, TBufferCollection extends MediaBufferCollection<TBuffer, TBufferCollection, TFormat>, TFormat extends MediaFormat<TFormat>>
extends MediaSinkBase
implements IMediaSink<TISource, TISink, TFrame, TBuffer, TBufferCollection, TFormat>,
ISink<TISource, TISink, TFrame, TBuffer, TBufferCollection, TFormat>,
IMediaElement,
IElement {
    private boolean __disabled;
    private List<IAction0> __onDisabledChange = new ArrayList<IAction0>();
    private List<IAction1<TFrame>> __onProcessFrame = new ArrayList<IAction1<TFrame>>();
    private List<IAction1<MediaControlFrame[]>> __onRaiseControlFrames = new ArrayList<IAction1<MediaControlFrame[]>>();
    private List<IAction1<TSink>> __onStateChange = new ArrayList<IAction1<TSink>>();
    private SinkOutput __output = null;
    private volatile boolean __processingFrame = false;
    private volatile boolean __raisingControlFrames = false;
    private TISourceCollection __sources;
    private MediaSinkState __state;
    private Object __stateLock;
    private TFormat _inputFormat;
    private boolean _muted;
    private IAction0 _onDisabledChange = new IAction0(){

        @Override
        public void invoke() {
            for (IAction0 action : new ArrayList(MediaSink.this.__onDisabledChange)) {
                action.invoke();
            }
        }
    };
    private IAction1<TFrame> _onProcessFrame = new IAction1<TFrame>(){

        @Override
        public void invoke(TFrame p0) {
            for (IAction1 action : new ArrayList(MediaSink.this.__onProcessFrame)) {
                action.invoke(p0);
            }
        }
    };
    private IAction1<MediaControlFrame[]> _onRaiseControlFrames = new IAction1<MediaControlFrame[]>(){

        @Override
        public void invoke(MediaControlFrame[] p0) {
            for (IAction1 action : new ArrayList(MediaSink.this.__onRaiseControlFrames)) {
                action.invoke(p0);
            }
        }
    };
    private IAction1<TSink> _onStateChange = new IAction1<TSink>(){

        @Override
        public void invoke(TSink p0) {
            for (IAction1 action : new ArrayList(MediaSink.this.__onStateChange)) {
                action.invoke(p0);
            }
        }
    };

    public void addOnDisabledChange(IAction0 value) {
        this.__onDisabledChange.add(value);
    }

    @Override
    public void addOnProcessFrame(IAction1<TFrame> value) {
        this.__onProcessFrame.add(value);
    }

    public void addOnRaiseControlFrames(IAction1<MediaControlFrame[]> value) {
        this.__onRaiseControlFrames.add(value);
    }

    public void addOnStateChange(IAction1<TSink> value) {
        this.__onStateChange.add(value);
    }

    @Override
    public void addSource(TISource source) {
        if (source != null) {
            this.validateSource(source);
            ((Collection)this.__sources).add(source);
        }
    }

    @Override
    public void addSources(TISource[] sources) {
        for (TISource local : sources) {
            this.validateSource(local);
        }
        ((Collection)this.__sources).addMany(sources);
    }

    public Future<Object> changeOutput(SinkOutput output) {
        return this.doChangeOutput(new Promise<Object>(), output);
    }

    protected abstract TISourceCollection createSourceCollection(TISink var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean destroy() {
        MediaSinkState state;
        Object obj2;
        Object object = obj2 = this.__stateLock;
        synchronized (object) {
            MediaSinkState _var0 = this.getState();
            if (_var0 == MediaSinkState.Destroying) {
                throw new RuntimeException(new Exception("A media sink cannot be destroyed while it is being destroyed on a different thread."));
            }
            if (_var0 == MediaSinkState.Destroyed) {
                return true;
            }
            state = this.getState();
            this.setState(MediaSinkState.Destroying);
        }
        Log.debug(StringExtensions.format("Media sink ({0}) is being destroyed.", this.getLabel()));
        while (this.__processingFrame || this.__raisingControlFrames) {
            ManagedThread.sleep(10);
        }
        try {
            this.doDestroy();
            object = obj2 = this.__stateLock;
            synchronized (object) {
                this.setState(MediaSinkState.Destroyed);
            }
            ((MediaSourceCollection)this.__sources).destroy();
            return true;
        }
        catch (Exception obj1) {
            Object object2 = obj2 = this.__stateLock;
            synchronized (object2) {
                this.setState(state);
            }
            return false;
        }
    }

    private Future<Object> doChangeOutput(final Promise<Object> promise, final SinkOutput output) {
        IAction0 action = null;
        IAction0 action2 = null;
        if (Global.equals(output, this.__output)) {
            if (action == null) {
                action = new IAction0(){

                    @Override
                    public void invoke() {
                        promise.resolve(null);
                    }
                };
            }
            ManagedThread.dispatch(action);
        } else {
            if (action2 == null) {
                action2 = new IAction0(){

                    @Override
                    public void invoke() {
                        MediaSink.this.__output = output;
                        promise.resolve(null);
                    }
                };
            }
            ManagedThread.dispatch(action2);
        }
        return promise;
    }

    protected abstract void doDestroy();

    protected abstract void doProcessFrame(TFrame var1, TBuffer var2);

    protected Error doProcessSdpMediaDescription(MediaDescription mediaDescription, boolean isOffer, boolean isLocalDescription) {
        return null;
    }

    @Override
    public boolean getDisabled() {
        return this.__disabled;
    }

    @Override
    public TFormat getInputFormat() {
        return this._inputFormat;
    }

    public boolean getMuted() {
        return this._muted;
    }

    public SinkOutput getOutput() {
        return this.__output;
    }

    public SinkOutput[] getOutputs() {
        return new SinkOutput[0];
    }

    @Override
    public String getPipelineJson() {
        return StringExtensions.concat(new String[]{"{ ", this.getPipelineJsonBase(), ", ", this.getPipelineJsonSources(), " }"});
    }

    private String getPipelineJsonBase() {
        return StringExtensions.concat(new String[]{this.getPipelineJsonId(), ", ", this.getPipelineJsonLabel(), ", ", this.getPipelineJsonTag(), ", ", this.getPipelineJsonDisabled(), ", ", this.getPipelineJsonInput()});
    }

    private String getPipelineJsonDisabled() {
        return StringExtensions.concat("\"disabled\": ", this.getDisabled() ? "true" : "false");
    }

    @Override
    public String getPipelineJsonFromSource() {
        return StringExtensions.concat("{ ", this.getPipelineJsonBase(), " }");
    }

    private String getPipelineJsonId() {
        return StringExtensions.concat("\"id\": ", JsonSerializer.serializeString(super.getId()));
    }

    private String getPipelineJsonInput() {
        return StringExtensions.concat("\"input\": ", this.getInputFormat() == null ? "null" : JsonSerializer.serializeString(((MediaFormat)this.getInputFormat()).toString()));
    }

    private String getPipelineJsonLabel() {
        return StringExtensions.concat("\"label\": ", JsonSerializer.serializeString(this.getLabel()));
    }

    private String getPipelineJsonSources() {
        ArrayList<String> list = new ArrayList<String>();
        for (IMediaSource local : this.getSources()) {
            list.add(local.getPipelineJsonFromSink());
        }
        return StringExtensions.concat("\"sources\": [", StringExtensions.join(", ", list.toArray(new String[0])), "]");
    }

    private String getPipelineJsonTag() {
        return StringExtensions.concat("\"tag\": ", JsonSerializer.serializeString(super.getTag()));
    }

    @Override
    public TISource getSource() {
        return (TISource)((IMediaSource)((Collection)this.__sources).getValue());
    }

    @Override
    public TISource[] getSources() {
        return (IMediaSource[])((Collection)this.__sources).getValues();
    }

    public MediaSinkState getState() {
        return this.__state;
    }

    public boolean hasSource(TISource source) {
        for (IMediaSource local : this.getSources()) {
            if (local != source) continue;
            return true;
        }
        return false;
    }

    public MediaSink() {
        this(null);
    }

    public MediaSink(TFormat inputFormat) {
        this.__state = MediaSinkState.Initialized;
        this.__stateLock = new Object();
        License.checkKey();
        this.setInputFormat(inputFormat);
        this.__sources = this.createSourceCollection(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processFrame(TFrame frame) {
        if (Global.equals((Object)this.__state, (Object)MediaSinkState.Initialized)) {
            this.__processingFrame = true;
            try {
                Object buffer22;
                if (Global.equals((Object)this.__state, (Object)MediaSinkState.Initialized) && (buffer22 = ((MediaFrame)frame).getBuffer(this.getInputFormat())) != null) {
                    IAction1<TFrame> onProcessFrame;
                    if (StringExtensions.isNullOrEmpty(((MediaBuffer)buffer22).getSourceId())) {
                        ((MediaBuffer)buffer22).setSourceId(super.getId());
                    }
                    if (this.getMuted()) {
                        ((MediaBuffer)buffer22).mute();
                    }
                    if ((onProcessFrame = this._onProcessFrame) != null) {
                        onProcessFrame.invoke(frame);
                    }
                    this.doProcessFrame(frame, buffer22);
                }
                boolean buffer22 = true;
                return buffer22;
            }
            catch (Exception exception) {
                Log.error(StringExtensions.format("Media sink ({0}) could not process frame.", this.getLabel()), exception);
            }
            finally {
                this.__processingFrame = false;
            }
        }
        return false;
    }

    @Override
    public Error processSdpMediaDescriptionFromSource(MediaDescription mediaDescription, boolean isOffer, boolean isLocalDescription) {
        return this.doProcessSdpMediaDescription(mediaDescription, isOffer, isLocalDescription);
    }

    protected void raiseControlFrame(MediaControlFrame controlFrame) {
        this.raiseControlFrames(new MediaControlFrame[]{controlFrame});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void raiseControlFrames(MediaControlFrame[] controlFrames) {
        if (Global.equals((Object)this.__state, (Object)MediaSinkState.Initialized)) {
            this.__raisingControlFrames = true;
            try {
                if (Global.equals((Object)this.__state, (Object)MediaSinkState.Initialized)) {
                    IAction1<MediaControlFrame[]> onRaiseControlFrames = this._onRaiseControlFrames;
                    if (onRaiseControlFrames != null) {
                        onRaiseControlFrames.invoke(controlFrames);
                    }
                    for (IMediaSource local : this.getSources()) {
                        local.processControlFrames(controlFrames);
                    }
                }
            }
            catch (Exception exception) {
                Log.error(StringExtensions.format("Media sink ({0}) could not raise control frames.", this.getLabel()), exception);
            }
            finally {
                this.__raisingControlFrames = false;
            }
        }
    }

    public void removeOnDisabledChange(IAction0 value) {
        IAction0 match;
        if (value instanceof IActionDelegate0 && (match = Global.findIActionDelegate0WithId(this.__onDisabledChange, ((IActionDelegate0)value).getId())) != null) {
            value = match;
        }
        this.__onDisabledChange.remove(value);
    }

    @Override
    public void removeOnProcessFrame(IAction1<TFrame> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onProcessFrame, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onProcessFrame.remove(value);
    }

    public void removeOnRaiseControlFrames(IAction1<MediaControlFrame[]> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onRaiseControlFrames, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onRaiseControlFrames.remove(value);
    }

    public void removeOnStateChange(IAction1<TSink> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onStateChange, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onStateChange.remove(value);
    }

    @Override
    public boolean removeSource(TISource source) {
        return ((Collection)this.__sources).remove(source);
    }

    @Override
    public void removeSources() {
        ((Collection)this.__sources).removeAll();
    }

    @Override
    public boolean removeSources(TISource[] sources) {
        return ((Collection)this.__sources).removeMany(sources);
    }

    public void setDisabled(boolean value) {
        if (!Global.equals(this.__disabled, value)) {
            this.__disabled = value;
            IAction0 onDisabledChange = this._onDisabledChange;
            if (onDisabledChange != null) {
                onDisabledChange.invoke();
            }
        }
    }

    private void setInputFormat(TFormat value) {
        this._inputFormat = value;
    }

    public void setMuted(boolean value) {
        this._muted = value;
    }

    protected void setOutput(SinkOutput value) {
        this.__output = value;
    }

    public void setSource(TISource value) {
        this.removeSources();
        this.addSource(value);
    }

    public void setSources(TISource[] value) {
        this.removeSources();
        this.addSources((IMediaSource[])value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(MediaSinkState value) {
        Object object = this.__stateLock;
        synchronized (object) {
            if (!Global.equals((Object)this.__state, (Object)value)) {
                this.__state = value;
                IAction1<TSink> onStateChange = this._onStateChange;
                if (onStateChange != null) {
                    onStateChange.invoke(this);
                }
            }
        }
    }

    public String toString() {
        return StringExtensions.format("{0} ({1})", this.getLabel(), ((MediaFormat)this.getInputFormat()).getName());
    }

    private void validateSource(TISource source) {
        if (!(source instanceof Stream)) {
            if (this.getInputFormat() == null) {
                this.setInputFormat(((MediaFormat)source.getOutputFormat()).clone());
            }
            if (!((MediaFormat)source.getOutputFormat()).isEquivalent(this.getInputFormat())) {
                throw new RuntimeException(new Exception(StringExtensions.concat(new String[]{"Output format [", ((MediaFormat)source.getOutputFormat()).toString(), "] of source (", source.getLabel(), ") does not match input format [", ((MediaFormat)this.getInputFormat()).toString(), "] of sink (", this.getLabel(), ")."})));
            }
        }
    }
}

