/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.DateExtensions;
import fm.icelink.IntegerExtensions;
import fm.icelink.LogLevel;
import fm.icelink.StringExtensions;
import java.util.Date;

public abstract class LogProvider {
    private LogLevel _level;

    protected abstract void doLog(LogLevel var1, String var2, Exception var3);

    public LogLevel getLevel() {
        return this._level;
    }

    public static String getPrefix(LogLevel level) {
        String str = "IceLink";
        LogLevel _var0 = level;
        if (_var0 == LogLevel.Debug) {
            return StringExtensions.format("[{0}] DEBUG", str);
        }
        if (_var0 == LogLevel.Info) {
            return StringExtensions.format("[{0}] INFO ", str);
        }
        if (_var0 == LogLevel.Warn) {
            return StringExtensions.format("[{0}] WARN ", str);
        }
        if (_var0 == LogLevel.Error) {
            return StringExtensions.format("[{0}] ERROR", str);
        }
        if (_var0 == LogLevel.Fatal) {
            return StringExtensions.format("[{0}] FATAL", str);
        }
        if (_var0 == LogLevel.None) {
            return StringExtensions.format("[{0}] NONE ", str);
        }
        return StringExtensions.format("[{0}] ?????", str);
    }

    public static String getPrefix(LogLevel level, boolean includeTimestamp) {
        String prefix = LogProvider.getPrefix(level);
        if (includeTimestamp) {
            prefix = StringExtensions.format("{0} {1}", prefix, LogProvider.getPrefixTimestamp(DateExtensions.getUtcNow()));
        }
        return prefix;
    }

    public static String getPrefixTimestamp(Date timestamp) {
        String str = IntegerExtensions.toString(DateExtensions.getYear(timestamp));
        String str2 = IntegerExtensions.toString(DateExtensions.getMonth(timestamp));
        String str3 = IntegerExtensions.toString(DateExtensions.getDay(timestamp));
        String str4 = IntegerExtensions.toString(DateExtensions.getHour(timestamp));
        String str5 = IntegerExtensions.toString(DateExtensions.getMinute(timestamp));
        String str6 = IntegerExtensions.toString(DateExtensions.getSecond(timestamp));
        while (StringExtensions.getLength(str) < 4) {
            str = StringExtensions.concat("0", str);
        }
        while (StringExtensions.getLength(str2) < 2) {
            str2 = StringExtensions.concat("0", str2);
        }
        while (StringExtensions.getLength(str3) < 2) {
            str3 = StringExtensions.concat("0", str3);
        }
        while (StringExtensions.getLength(str4) < 2) {
            str4 = StringExtensions.concat("0", str4);
        }
        while (StringExtensions.getLength(str5) < 2) {
            str5 = StringExtensions.concat("0", str5);
        }
        while (StringExtensions.getLength(str6) < 2) {
            str6 = StringExtensions.concat("0", str6);
        }
        return StringExtensions.format("{0}/{1}/{2}-{3}:{4}:{5}", new Object[]{str, str2, str3, str4, str5, str6});
    }

    public void log(LogLevel level, String message) {
        this.log(level, message, null);
    }

    public void log(LogLevel level, String message, Exception ex) {
        if (level.getAssignedValue() >= this.getLevel().getAssignedValue()) {
            try {
                this.doLog(level, message, ex);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public LogProvider() {
        this.setLevel(LogLevel.Debug);
    }

    public void setLevel(LogLevel value) {
        this._level = value;
    }
}

