/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum DtlsCipherSuite {
    Aes128Sha(1),
    DhRsaAes128Sha(2),
    EcdhRsaAes128Sha(3),
    DheRsaAes128Sha(4),
    EcdheRsaAes128Sha(5),
    EcdheEcdsaAes128Sha(6),
    Aes128GcmSha256(7),
    DhRsaAes128GcmSha256(8),
    EcdhRsaAes128GcmSha256(9),
    DheRsaAes128GcmSha256(10),
    EcdheRsaAes128GcmSha256(11),
    EcdheEcdsaAes128GcmSha256(12);

    private final int value;
    private static final Map<Integer, DtlsCipherSuite> lookup;

    private DtlsCipherSuite(int value) {
        this.value = value;
    }

    public int getAssignedValue() {
        return this.value;
    }

    public static DtlsCipherSuite getByAssignedValue(int value) {
        return lookup.get(value);
    }

    static {
        lookup = new HashMap<Integer, DtlsCipherSuite>();
        for (DtlsCipherSuite s : EnumSet.allOf(DtlsCipherSuite.class)) {
            lookup.put(s.getAssignedValue(), s);
        }
    }
}

