/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.AudioBuffer;
import fm.icelink.AudioBufferCollection;
import fm.icelink.AudioConfig;
import fm.icelink.AudioFormat;
import fm.icelink.AudioFrame;
import fm.icelink.IAction1;
import fm.icelink.IActionDelegate1;
import fm.icelink.IAudioElement;
import fm.icelink.IAudioReframer;
import fm.icelink.IAudioSink;
import fm.icelink.IAudioSinkCollection;
import fm.icelink.IAudioSource;
import fm.icelink.IElement;
import fm.icelink.IMediaElement;
import fm.icelink.IMediaSource;
import fm.icelink.ISource;
import fm.icelink.MediaSource;
import fm.icelink.SoundReframerContext;

public abstract class AudioSource
extends MediaSource<IAudioSource, IAudioSink, IAudioSinkCollection, AudioSource, AudioFrame, AudioBuffer, AudioBufferCollection, AudioFormat>
implements IAudioSource,
IMediaSource<IAudioSource, IAudioSink, AudioFrame, AudioBuffer, AudioBufferCollection, AudioFormat>,
ISource<IAudioSource, IAudioSink, AudioFrame, AudioBuffer, AudioBufferCollection, AudioFormat>,
IAudioElement,
IMediaElement,
IElement,
IAudioReframer {
    private SoundReframerContext __reframerContext = new SoundReframerContext(20.0);
    private double _gain;

    public AudioSource(AudioFormat outputFormat) {
        super(outputFormat);
        this.setGain(1.0);
    }

    public static int calculateDuration(int dataLength, int clockRate, int channelCount) {
        return 1000 * dataLength / (clockRate * channelCount * 2);
    }

    public int calculateDuration(int dataLength) {
        return AudioSource.calculateDuration(dataLength, ((AudioFormat)super.getOutputFormat()).getClockRate(), ((AudioFormat)super.getOutputFormat()).getChannelCount());
    }

    @Override
    protected IAudioSinkCollection createSinkCollection(IAudioSource source) {
        return new IAudioSinkCollection(source);
    }

    @Override
    public AudioConfig getConfig() {
        return ((AudioFormat)super.getOutputFormat()).getConfig();
    }

    @Override
    public boolean getDisableTimestampReset() {
        return this.__reframerContext.getDisableTimestampReset();
    }

    @Override
    public boolean getForceTimestampReset() {
        return this.__reframerContext.getForceTimestampReset();
    }

    @Override
    public double getFrameDuration() {
        return this.__reframerContext.getFrameDuration();
    }

    public double getGain() {
        return this._gain;
    }

    @Override
    public int getTimestampResetInterval() {
        return this.__reframerContext.getTimestampResetInterval();
    }

    @Override
    protected void raiseFrame(AudioFrame frame) {
        AudioBuffer buffer = (AudioBuffer)frame.getBuffer(AudioFormat.getPcmName());
        if (buffer == null) {
            this.raiseProcessedFrame(frame);
        } else {
            if (this.__reframerContext.getOnFrame() == null) {
                this.__reframerContext.setOnFrame((IAction1<AudioFrame>)new IActionDelegate1<AudioFrame>(){

                    @Override
                    public String getId() {
                        return "fm.icelink.AudioSource.raiseProcessedFrame";
                    }

                    @Override
                    public void invoke(AudioFrame frame) {
                        AudioSource.this.raiseProcessedFrame(frame);
                    }
                });
            }
            this.__reframerContext.processFrame(frame, buffer);
        }
    }

    private void raiseProcessedFrame(AudioFrame frame) {
        if (this.getGain() != 1.0) {
            for (AudioBuffer buffer : (AudioBuffer[])frame.getBuffers()) {
                buffer.applyGain(this.getGain());
            }
        }
        super.raiseFrame(frame);
    }

    @Override
    public void setDisableTimestampReset(boolean value) {
        this.__reframerContext.setDisableTimestampReset(value);
    }

    @Override
    public void setForceTimestampReset(boolean value) {
        this.__reframerContext.setForceTimestampReset(value);
    }

    @Override
    public void setFrameDuration(double value) {
        this.__reframerContext.setFrameDuration(value);
    }

    public void setGain(double value) {
        this._gain = value;
    }

    @Override
    public void setTimestampResetInterval(int value) {
        this.__reframerContext.setTimestampResetInterval(value);
    }
}

