/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.AudioBuffer;
import fm.icelink.AudioBufferCollection;
import fm.icelink.AudioConfig;
import fm.icelink.AudioFormat;
import fm.icelink.AudioFrame;
import fm.icelink.IAudioElement;
import fm.icelink.IAudioPipe;
import fm.icelink.IAudioSink;
import fm.icelink.IAudioSinkCollection;
import fm.icelink.IAudioSource;
import fm.icelink.IAudioSourceCollection;
import fm.icelink.IElement;
import fm.icelink.IMediaElement;
import fm.icelink.IMediaSink;
import fm.icelink.IMediaSource;
import fm.icelink.ISink;
import fm.icelink.ISource;
import fm.icelink.MediaPipe;

public abstract class AudioPipe
extends MediaPipe<IAudioSource, IAudioSourceCollection, IAudioSink, IAudioSinkCollection, AudioPipe, AudioFrame, AudioBuffer, AudioBufferCollection, AudioFormat>
implements IAudioPipe,
IAudioSource,
IMediaSource<IAudioSource, IAudioSink, AudioFrame, AudioBuffer, AudioBufferCollection, AudioFormat>,
ISource<IAudioSource, IAudioSink, AudioFrame, AudioBuffer, AudioBufferCollection, AudioFormat>,
IAudioSink,
IMediaSink<IAudioSource, IAudioSink, AudioFrame, AudioBuffer, AudioBufferCollection, AudioFormat>,
ISink<IAudioSource, IAudioSink, AudioFrame, AudioBuffer, AudioBufferCollection, AudioFormat>,
IAudioElement,
IMediaElement,
IElement {
    private double _gain;

    public AudioPipe(AudioFormat inputFormat, AudioFormat outputFormat) {
        super(inputFormat, outputFormat);
        this.setGain(1.0);
    }

    public AudioPipe(AudioFormat outputFormat) {
        this(null, outputFormat);
    }

    @Override
    protected IAudioSinkCollection createSinkCollection(IAudioSource source) {
        return new IAudioSinkCollection(source);
    }

    @Override
    protected IAudioSourceCollection createSourceCollection(IAudioSink sink) {
        return new IAudioSourceCollection(sink);
    }

    @Override
    public AudioConfig getConfig() {
        return ((AudioFormat)super.getOutputFormat()).getConfig();
    }

    public double getGain() {
        return this._gain;
    }

    @Override
    protected void raiseFrame(AudioFrame frame) {
        if (this.getGain() != 1.0) {
            for (AudioBuffer buffer : (AudioBuffer[])frame.getBuffers()) {
                buffer.applyGain(this.getGain());
            }
        }
        super.raiseFrame(frame);
    }

    public void setGain(double value) {
        this._gain = value;
    }
}

