/*
 * Decompiled with CFR 0.152.
 */
package fm.websync;

import fm.NullableGuid;
import fm.SingleAction;
import fm.websync.BackoffArgs;
import fm.websync.BaseInputArgs;
import fm.websync.ConnectCompleteArgs;
import fm.websync.ConnectFailureArgs;
import fm.websync.ConnectRetryMode;
import fm.websync.ConnectSuccessArgs;
import fm.websync.RetryBackoffCallback;
import fm.websync.StateRestoredArgs;
import fm.websync.StreamFailureArgs;

public class ConnectArgs
extends BaseInputArgs {
    private int _defaultRetryBackoffTimeout = 500;
    private boolean _isReconnect;
    private NullableGuid _lastClientId = new NullableGuid();
    private NullableGuid _lastSessionId = new NullableGuid();
    private SingleAction<ConnectCompleteArgs> _onComplete;
    private SingleAction<ConnectFailureArgs> _onFailure;
    private SingleAction<StateRestoredArgs> _onStateRestored;
    private SingleAction<StreamFailureArgs> _onStreamFailure;
    private SingleAction<ConnectSuccessArgs> _onSuccess;
    private RetryBackoffCallback _retryBackoff;
    private ConnectRetryMode _retryMode;

    public ConnectArgs() {
        this.setRetryMode(ConnectRetryMode.Intelligent);
        final ConnectArgs _var0 = this;
        this.setRetryBackoff(new RetryBackoffCallback(){

            @Override
            public Integer invoke(BackoffArgs e) {
                try {
                    return _var0.defaultRetryBackoff(e);
                }
                catch (Exception _var1) {
                    return 0;
                }
            }
        });
    }

    private int defaultRetryBackoff(BackoffArgs e) {
        if (e.getIndex() == 0) {
            return this._defaultRetryBackoffTimeout;
        }
        return e.getLastTimeout() * 2;
    }

    boolean getIsReconnect() {
        return this._isReconnect;
    }

    NullableGuid getLastClientId() {
        return this._lastClientId;
    }

    NullableGuid getLastSessionId() {
        return this._lastSessionId;
    }

    public SingleAction<ConnectCompleteArgs> getOnComplete() {
        return this._onComplete;
    }

    public SingleAction<ConnectFailureArgs> getOnFailure() {
        return this._onFailure;
    }

    public SingleAction<StateRestoredArgs> getOnStateRestored() {
        return this._onStateRestored;
    }

    public SingleAction<StreamFailureArgs> getOnStreamFailure() {
        return this._onStreamFailure;
    }

    public SingleAction<ConnectSuccessArgs> getOnSuccess() {
        return this._onSuccess;
    }

    public RetryBackoffCallback getRetryBackoff() {
        return this._retryBackoff;
    }

    public ConnectRetryMode getRetryMode() {
        return this._retryMode;
    }

    void setIsReconnect(boolean value) {
        this._isReconnect = value;
    }

    void setLastClientId(NullableGuid value) {
        this._lastClientId = value;
    }

    void setLastSessionId(NullableGuid value) {
        this._lastSessionId = value;
    }

    public void setOnComplete(SingleAction<ConnectCompleteArgs> value) {
        this._onComplete = value;
    }

    public void setOnFailure(SingleAction<ConnectFailureArgs> value) {
        this._onFailure = value;
    }

    public void setOnStateRestored(SingleAction<StateRestoredArgs> value) {
        this._onStateRestored = value;
    }

    public void setOnStreamFailure(SingleAction<StreamFailureArgs> value) {
        this._onStreamFailure = value;
    }

    public void setOnSuccess(SingleAction<ConnectSuccessArgs> value) {
        this._onSuccess = value;
    }

    public void setRetryBackoff(RetryBackoffCallback value) {
        this._retryBackoff = value;
    }

    public void setRetryMode(ConnectRetryMode value) {
        this._retryMode = value;
    }
}

