/*
 * Decompiled with CFR 0.152.
 */
package fm;

import fm.Log;
import java.util.Arrays;

public class FloatCollection {
    private float[] _list;
    private int _length;

    public void add(float b) {
        try {
            this.append(b);
        }
        catch (Exception ex) {
            Log.error("Could not add(float).", ex);
        }
    }

    public void addRange(float[] buffer) {
        if (buffer != null) {
            try {
                this.append(buffer, buffer.length);
            }
            catch (Exception ex) {
                Log.error("Could not addRange(float[]).", ex);
            }
        }
    }

    public void addRange(FloatCollection collection) {
        if (collection != null) {
            try {
                this.append(collection._list, collection._length);
            }
            catch (Exception ex) {
                Log.error("Could not addRange(FloatCollection).", ex);
            }
        }
    }

    public FloatCollection() {
    }

    public FloatCollection(float[] buffer) {
        this.addRange(buffer);
    }

    public float get(int index) {
        if (this._list != null && index < this._list.length) {
            return this._list[index];
        }
        return 0.0f;
    }

    public int getCount() {
        return this._length;
    }

    public float[] getRange(int index, int count) {
        return Arrays.copyOfRange(this._list, index, index + count);
    }

    public void insertRange(int index, float[] buffer) {
        if (buffer != null) {
            try {
                this.insert(buffer, buffer.length, index);
            }
            catch (Exception ex) {
                Log.error("Could not insertRange(int,float[]).", ex);
            }
        }
    }

    public void insertRange(int index, FloatCollection collection) {
        if (collection != null) {
            try {
                this.insert(collection._list, collection._length, index);
            }
            catch (Exception ex) {
                Log.error("Could not insertRange(int,FloatCollection).", ex);
            }
        }
    }

    public void removeRange(int index, int count) {
        try {
            this.remove(count, index);
        }
        catch (Exception ex) {
            Log.error("Could not removeRange(int,int).", ex);
        }
    }

    public float[] toArray() {
        if (this._list == null) {
            return new float[0];
        }
        if (this._list.length == this._length) {
            return this._list;
        }
        return this.getRange(0, this._length);
    }

    private void append(float value) {
        if (this._list == null) {
            this._list = new float[4];
            this._list[0] = value;
            this._length = 1;
        } else {
            int minLength = this._length + 1;
            if (minLength > this._list.length) {
                float[] newlist = this.createBiggerArray(minLength);
                System.arraycopy(this._list, 0, newlist, 0, this._list.length);
                this._list = newlist;
            }
            this._list[this._length] = value;
            ++this._length;
        }
    }

    private void append(float[] buffer, int length) {
        if (buffer != null) {
            if (this._list == null) {
                this._list = buffer;
                this._length = length;
            } else {
                int minLength = this._length + length;
                if (minLength > this._list.length) {
                    float[] newlist = this.createBiggerArray(minLength);
                    System.arraycopy(this._list, 0, newlist, 0, this._list.length);
                    this._list = newlist;
                }
                System.arraycopy(buffer, 0, this._list, this._length, length);
                this._length += length;
            }
        }
    }

    private void insert(float[] buffer, int length, int position) {
        if (buffer != null) {
            if (this._list == null) {
                this._list = buffer;
                this._length = length;
            } else {
                int bpos = position;
                int blength = this._length - bpos;
                int minLength = this._length + length;
                if (minLength > this._list.length) {
                    int apos = 0;
                    int alength = position;
                    float[] newlist = this.createBiggerArray(minLength);
                    int offset = 0;
                    System.arraycopy(this._list, apos, newlist, offset, alength);
                    System.arraycopy(buffer, 0, newlist, offset += alength, length);
                    System.arraycopy(this._list, bpos, newlist, offset += length, blength);
                    this._list = newlist;
                } else {
                    System.arraycopy(this._list, bpos, this._list, position + length, blength);
                    System.arraycopy(buffer, 0, this._list, position, length);
                }
                this._length += length;
            }
        }
    }

    private void remove(int length, int position) {
        if (this._list != null) {
            int bpos = position + length;
            int blength = this._length - bpos;
            System.arraycopy(this._list, bpos, this._list, position, blength);
            this._length -= length;
        }
    }

    private float[] createBiggerArray(int minLength) {
        int newLength;
        for (newLength = this._list.length; newLength < minLength; newLength *= 2) {
        }
        return new float[newLength];
    }
}

