/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.openh264;

import fm.icelink.Architecture;
import fm.icelink.Future;
import fm.icelink.Global;
import fm.icelink.IAction0;
import fm.icelink.IAction1;
import fm.icelink.ManagedThread;
import fm.icelink.MediaFrame;
import fm.icelink.OperatingSystem;
import fm.icelink.Platform;
import fm.icelink.Promise;
import fm.icelink.VideoBuffer;
import fm.icelink.VideoFormat;
import fm.icelink.VideoFrame;
import fm.icelink.openh264.Decoder;
import fm.icelink.openh264.Encoder;

public class Utility {
    private static void doInitialize(final Encoder encoder, final Decoder decoder, final Promise<Object> promise) {
        decoder.addOnRaiseFrame((IAction1)new IAction1<VideoFrame>(){

            public void invoke(VideoFrame frame) {
                promise.resolve(null);
                ManagedThread.dispatch((IAction0)new IAction0(){

                    public void invoke() {
                        encoder.destroy();
                        decoder.destroy();
                    }
                });
            }
        });
        encoder.addOnRaiseFrame((IAction1)new IAction1<VideoFrame>(){

            public void invoke(VideoFrame encodedFrame) {
                try {
                    decoder.processFrame((MediaFrame)new VideoFrame((VideoBuffer)encodedFrame.getLastBuffer()));
                }
                catch (Exception exception) {
                    promise.reject(exception);
                }
            }
        });
        encoder.processFrame(new VideoFrame(VideoBuffer.createBlack((int)160, (int)120, (String)VideoFormat.getI420Name())));
    }

    public static String getDownloadUrl() {
        OperatingSystem operatingSystem = Platform.getInstance().getOperatingSystem();
        Architecture architecture = Platform.getInstance().getArchitecture();
        OperatingSystem _var0 = operatingSystem;
        if (_var0 == OperatingSystem.Windows) {
            Architecture _var1 = architecture;
            if (_var1 == Architecture.X86) {
                return "http://ciscobinary.openh264.org/openh264-1.7.0-win32.dll.bz2";
            }
            if (_var1 == Architecture.X64) {
                return "http://ciscobinary.openh264.org/openh264-1.7.0-win64.dll.bz2";
            }
            throw new RuntimeException(new Exception("Cisco only distributes x86 and x64 OpenH264 binaries for Windows."));
        }
        if (_var0 == OperatingSystem.Android) {
            if (!Global.equals((Object)architecture, (Object)Architecture.Armv7) && !Global.equals((Object)architecture, (Object)Architecture.Armv8)) {
                throw new RuntimeException(new Exception("Cisco only distributes 32-bit ARM binaries for Android."));
            }
            return "http://ciscobinary.openh264.org/libopenh264-1.7.0-android19.so.bz2";
        }
        if (_var0 == OperatingSystem.MacOS) {
            return Global.equals((Object)architecture, (Object)Architecture.X86) ? "http://ciscobinary.openh264.org/libopenh264-1.7.0-osx32.4.dylib.bz2" : "http://ciscobinary.openh264.org/libopenh264-1.7.0-osx64.4.dylib.bz2";
        }
        throw new RuntimeException(new Exception("Unknown operating system."));
    }

    public static Future<Object> initialize() {
        return Utility.initialize(new Encoder(), new Decoder());
    }

    private static Future<Object> initialize(Encoder encoder, Decoder decoder) {
        Promise promise = new Promise();
        try {
            Utility.doInitialize(encoder, decoder, (Promise<Object>)promise);
        }
        catch (Exception exception) {
            promise.reject(exception);
        }
        return promise;
    }

    public static boolean isSupported() {
        try {
            Utility.getDownloadUrl();
            return true;
        }
        catch (Exception obj1) {
            return false;
        }
    }
}

