/*
 * Decompiled with CFR 0.152.
 */
package fm.websync;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum ConnectionType {
    WebSocket(1),
    LongPolling(2),
    CallbackPolling(3),
    IFrame(4),
    Flash(5),
    Unknown(99);

    private final int value;
    private static final Map<Integer, ConnectionType> lookup;

    private ConnectionType(int value) {
        this.value = value;
    }

    public int getAssignedValue() {
        return this.value;
    }

    public static ConnectionType getByAssignedValue(int value) {
        return lookup.get(value);
    }

    static {
        lookup = new HashMap<Integer, ConnectionType>();
        for (ConnectionType s : EnumSet.allOf(ConnectionType.class)) {
            lookup.put(s.getAssignedValue(), s);
        }
    }
}

