/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.sdp.rtcp;

import fm.icelink.IntegerExtensions;
import fm.icelink.ParseAssistant;
import fm.icelink.StringBuilderExtensions;
import fm.icelink.StringExtensions;
import fm.icelink.sdp.AddressType;
import fm.icelink.sdp.AttributeType;
import fm.icelink.sdp.NetworkType;

public class Attribute
extends fm.icelink.sdp.Attribute {
    private String _addressType;
    private String _connectionAddress;
    private String _networkType;
    private int _port;

    private Attribute() {
        super.setAttributeType(AttributeType.RtcpAttribute);
    }

    public Attribute(int port, String connectionAddress) {
        this();
        if (connectionAddress == null) {
            throw new RuntimeException(new Exception("connectionAddress cannot be null."));
        }
        this.update(port, connectionAddress);
    }

    public static Attribute fromAttributeValue(String value) {
        int index = StringExtensions.indexOf(value, " ");
        int num2 = 0;
        String str = null;
        String str2 = null;
        String str3 = null;
        if (index == -1) {
            num2 = ParseAssistant.parseIntegerValue(value);
        } else {
            num2 = ParseAssistant.parseIntegerValue(StringExtensions.substring(value, 0, index));
            value = value.substring(index + 1);
            index = StringExtensions.indexOf(value, " ");
            str = StringExtensions.substring(value, 0, index);
            value = value.substring(index + 1);
            index = StringExtensions.indexOf(value, " ");
            str2 = StringExtensions.substring(value, 0, index);
            str3 = value = value.substring(index + 1);
        }
        Attribute attribute = new Attribute();
        attribute.setPort(num2);
        attribute.setNetworkType(str);
        attribute.setAddressType(str2);
        attribute.setConnectionAddress(str3);
        return attribute;
    }

    public String getAddressType() {
        return this._addressType;
    }

    @Override
    protected String getAttributeValue() {
        StringBuilder builder = new StringBuilder();
        StringBuilderExtensions.append(builder, IntegerExtensions.toString(this.getPort()));
        if (this.getConnectionAddress() != null) {
            StringBuilderExtensions.append(builder, " ");
            StringBuilderExtensions.append(builder, this.getNetworkType());
            StringBuilderExtensions.append(builder, " ");
            StringBuilderExtensions.append(builder, this.getAddressType());
            StringBuilderExtensions.append(builder, " ");
            StringBuilderExtensions.append(builder, this.getConnectionAddress());
        }
        return builder.toString();
    }

    public String getConnectionAddress() {
        return this._connectionAddress;
    }

    public String getNetworkType() {
        return this._networkType;
    }

    public int getPort() {
        return this._port;
    }

    private void setAddressType(String value) {
        this._addressType = value;
    }

    private void setConnectionAddress(String value) {
        this._connectionAddress = value;
    }

    private void setNetworkType(String value) {
        this._networkType = value;
    }

    private void setPort(int value) {
        this._port = value;
    }

    public void update(int port, String connectionAddress) {
        this.setPort(port);
        this.setNetworkType(NetworkType.getInternet());
        this.setAddressType(AddressType.getAddressTypeForAddress(connectionAddress));
        this.setConnectionAddress(connectionAddress);
    }
}

