/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.sdp.ice;

import fm.icelink.ArrayListExtensions;
import fm.icelink.Global;
import fm.icelink.StringExtensions;
import fm.icelink.sdp.Attribute;
import fm.icelink.sdp.AttributeType;
import fm.icelink.sdp.ice.OptionTag;
import fm.icelink.sdp.ice.OptionTagType;
import fm.icelink.sdp.ice.TrickleIceOptionTag;
import java.util.ArrayList;

public class OptionsAttribute
extends Attribute {
    private ArrayList<OptionTag> _tags;

    public static OptionsAttribute fromAttributeValue(String value) {
        String[] strArray = StringExtensions.split(value, new char[]{' '});
        ArrayList<OptionTag> list = new ArrayList<OptionTag>();
        for (String str : strArray) {
            OptionTag item = OptionTag.parse(str);
            if (item == null) continue;
            list.add(item);
        }
        OptionsAttribute attribute = new OptionsAttribute();
        attribute.setTags(list);
        return attribute;
    }

    @Override
    protected String getAttributeValue() {
        if (this.getTags() == null) {
            return "";
        }
        int count = ArrayListExtensions.getCount(this.getTags());
        String[] strArray = new String[count];
        for (int i = 0; i < count; ++i) {
            strArray[i] = ArrayListExtensions.getItem(this.getTags()).get(i).toString();
        }
        return StringExtensions.join(" ", strArray);
    }

    public ArrayList<OptionTag> getTags() {
        return this._tags;
    }

    public boolean getTrickleOptionSet() {
        for (OptionTag tag : this.getTags()) {
            if (!Global.equals((Object)tag.getType(), (Object)OptionTagType.Trickle)) continue;
            return true;
        }
        return false;
    }

    public OptionsAttribute(ArrayList<OptionTag> tags) {
        if (tags == null) {
            tags = new ArrayList();
        }
        super.setAttributeType(AttributeType.IceOptionsAttribute);
        this.setTags(tags);
    }

    private OptionsAttribute() {
        this.setTags(new ArrayList<OptionTag>());
        super.setAttributeType(AttributeType.IceOptionsAttribute);
    }

    private void setTags(ArrayList<OptionTag> value) {
        this._tags = value;
    }

    public void setTrickleOptionSet(boolean value) {
        if (value) {
            for (OptionTag tag : this.getTags()) {
                if (!Global.equals((Object)tag.getType(), (Object)OptionTagType.Trickle)) continue;
                return;
            }
            this.getTags().add(new TrickleIceOptionTag());
        } else {
            OptionTag item = null;
            for (OptionTag tag : this.getTags()) {
                if (!Global.equals((Object)tag.getType(), (Object)OptionTagType.Trickle)) continue;
                item = tag;
            }
            this.getTags().remove(item);
        }
    }
}

