/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.matroska;

import fm.icelink.ArrayExtensions;
import fm.icelink.AudioBuffer;
import fm.icelink.AudioConfig;
import fm.icelink.AudioDecoder;
import fm.icelink.AudioFormat;
import fm.icelink.AudioFrame;
import fm.icelink.Binary;
import fm.icelink.Constants;
import fm.icelink.DataBuffer;
import fm.icelink.FileStream;
import fm.icelink.FileStreamAccess;
import fm.icelink.Future;
import fm.icelink.Global;
import fm.icelink.IAction0;
import fm.icelink.IAction1;
import fm.icelink.IActionDelegate0;
import fm.icelink.IActionDelegate1;
import fm.icelink.LongExtensions;
import fm.icelink.ManagedStopwatch;
import fm.icelink.ManagedThread;
import fm.icelink.MathAssistant;
import fm.icelink.Promise;
import fm.icelink.SoundConverter;
import fm.icelink.SourceInput;
import fm.icelink.StringExtensions;
import fm.icelink.matroska.Audio;
import fm.icelink.matroska.Block;
import fm.icelink.matroska.BlockGroup;
import fm.icelink.matroska.Cluster;
import fm.icelink.matroska.Element;
import fm.icelink.matroska.File;
import fm.icelink.matroska.Segment;
import fm.icelink.matroska.SegmentInfo;
import fm.icelink.matroska.Track;
import fm.icelink.matroska.TrackEntry;
import fm.icelink.matroska.TrackType;
import fm.icelink.pcm.Format;
import fm.icelink.pcmu.Decoder;
import java.util.ArrayList;
import java.util.List;

public abstract class AudioSource
extends fm.icelink.AudioSource {
    private long __baseTimestamp;
    private int __channelCount;
    private int __clockRate;
    private Cluster[] __clusters;
    private byte[] __data;
    private AudioDecoder __decoder;
    private File __file;
    private long __lastTimestamp = -1L;
    private long __lastTimestampChange = -1L;
    private List<IAction0> __onEnded = new ArrayList<IAction0>();
    private Segment __segment;
    private SegmentInfo __segmentInfo;
    private SoundConverter __soundConverter;
    private ManagedThread __thread;
    private volatile boolean __threadActive = false;
    private volatile boolean __threadExited = false;
    private long __timecodeScale;
    private TrackEntry __trackEntry;
    private long __trackNumber;
    private Track[] __tracks;
    private IAction0 _onEnded = null;
    private String _path;

    public void addOnEnded(IAction0 value) {
        if (value != null) {
            if (this._onEnded == null) {
                this._onEnded = new IAction0(){

                    @Override
                    public void invoke() {
                        for (IAction0 action : new ArrayList(AudioSource.this.__onEnded)) {
                            action.invoke();
                        }
                    }
                };
            }
            this.__onEnded.add(value);
        }
    }

    public AudioSource(String path) {
        super(new Format(48000, 2));
        this.setPath(path);
        this.readFile();
        this.parseFile();
    }

    private void captureLoop(ManagedThread thread) {
        while (this.__threadActive) {
            ManagedStopwatch stopwatch = new ManagedStopwatch();
            stopwatch.start();
            this.__baseTimestamp = this.__lastTimestamp == -1L || this.__lastTimestampChange == -1L ? 0L : this.__lastTimestamp + this.__lastTimestampChange;
            for (Cluster cluster : this.__clusters) {
                if (cluster.getSimpleBlocks() != null) {
                    for (Element element : cluster.getSimpleBlocks()) {
                        if (!this.__threadActive) continue;
                        this.processBlock((Block)element, cluster.getTimecode(), stopwatch.getElapsedTicks());
                    }
                    continue;
                }
                if (cluster.getBlockGroups() == null) continue;
                for (Element element : cluster.getBlockGroups()) {
                    if (!this.__threadActive) continue;
                    this.processBlock(((BlockGroup)element).getBlock(), cluster.getTimecode(), stopwatch.getElapsedTicks());
                }
            }
            stopwatch.stop();
            IAction0 onEnded = this._onEnded;
            if (onEnded == null) continue;
            onEnded.invoke();
        }
        this.__threadExited = true;
    }

    protected abstract AudioDecoder createOpusDecoder(AudioConfig var1);

    protected AudioDecoder createPcmaDecoder(AudioConfig config) {
        return new fm.icelink.pcma.Decoder(config);
    }

    protected AudioDecoder createPcmuDecoder(AudioConfig config) {
        return new Decoder(config);
    }

    @Override
    protected Future<Object> doStart() {
        IAction1<AudioFrame> action = null;
        Promise<Object> promise = new Promise<Object>();
        try {
            this.__trackEntry = null;
            SourceInput input = this.getInput();
            Object[] trackEntries = AudioSource.getTrackEntries(this.__tracks);
            if (ArrayExtensions.getLength(trackEntries) == 0) {
                throw new RuntimeException(new Exception("Matroska file has no matching audio tracks."));
            }
            if (input != null) {
                for (Object entry : trackEntries) {
                    if (!Global.equals(LongExtensions.toString(((TrackEntry)entry).getTrackUid()), input.getId())) continue;
                    this.__trackEntry = entry;
                }
            }
            if (this.__trackEntry == null) {
                this.__trackEntry = trackEntries[0];
            }
            this.__trackNumber = this.__trackEntry.getTrackNumber();
            String codecId = this.__trackEntry.getCodecId();
            if (codecId == null) {
                throw new RuntimeException(new Exception("Matroska audio track has no codec ID."));
            }
            byte[] codecPrivate = this.__trackEntry.getCodecPrivate();
            if (codecPrivate == null) {
                throw new RuntimeException(new Exception("Matroska audio track has no codec-private data."));
            }
            this.__clockRate = (int)Audio.getDefaultSamplingFrequency();
            this.__channelCount = (int)Audio.getDefaultChannels();
            Audio audio = this.__trackEntry.getAudio();
            if (audio != null) {
                this.__clockRate = (int)audio.getSamplingFrequency();
                this.__channelCount = (int)audio.getChannels();
            }
            if (Global.equals(codecId, TrackEntry.getOpusCodecId())) {
                byte num;
                if (ArrayExtensions.getLength(codecPrivate) >= 9 && (num = codecPrivate[8]) == 1) {
                    if (ArrayExtensions.getLength(codecPrivate) >= 10) {
                        this.__channelCount = codecPrivate[9];
                    }
                    if (ArrayExtensions.getLength(codecPrivate) >= 16) {
                        this.__clockRate = (int)Binary.fromBytes32(codecPrivate, 12, true);
                    }
                }
                this.__decoder = this.createOpusDecoder(new AudioConfig(this.__clockRate, this.__channelCount));
            } else {
                if (!Global.equals(codecId, TrackEntry.getPcmCodecId())) {
                    throw new RuntimeException(new Exception("Matroska audio track has unrecognized codec."));
                }
                if (ArrayExtensions.getLength(codecPrivate) >= 4) {
                    this.__channelCount = Binary.fromBytes16(codecPrivate, 2, true);
                }
                if (ArrayExtensions.getLength(codecPrivate) >= 8) {
                    this.__clockRate = Binary.fromBytes16(codecPrivate, 4, true);
                }
                if (ArrayExtensions.getLength(codecPrivate) < 2) {
                    throw new RuntimeException(new Exception("Matroska audio track has unrecognized PCM codec."));
                }
                int num2 = Binary.fromBytes16(codecPrivate, 0, true);
                if (num2 == TrackEntry.getPcmuFormatTag()) {
                    this.__decoder = this.createPcmuDecoder(new AudioConfig(this.__clockRate, this.__channelCount));
                } else {
                    if (num2 != TrackEntry.getPcmaFormatTag()) {
                        throw new RuntimeException(new Exception("Matroska audio track has unrecognized PCM codec."));
                    }
                    this.__decoder = this.createPcmaDecoder(new AudioConfig(this.__clockRate, this.__channelCount));
                }
            }
            if (action == null) {
                action = new IAction1<AudioFrame>(){

                    @Override
                    public void invoke(AudioFrame frame) {
                        IAction1<AudioFrame> action = null;
                        if (!((AudioFormat)((AudioBuffer)frame.getLastBuffer()).getFormat()).isEquivalent(AudioSource.this.getOutputFormat()) && AudioSource.this.__soundConverter == null) {
                            AudioSource.this.__soundConverter = new SoundConverter(((AudioFormat)AudioSource.this.getOutputFormat()).getConfig());
                            if (action == null) {
                                action = new IAction1<AudioFrame>(){

                                    @Override
                                    public void invoke(AudioFrame convertedFrame) {
                                        AudioSource.this.raiseFrame(convertedFrame);
                                    }
                                };
                            }
                            AudioSource.this.__soundConverter.addOnProcessFrame(action);
                        }
                        if (AudioSource.this.__soundConverter == null) {
                            AudioSource.this.raiseFrame(frame);
                        } else {
                            AudioSource.this.__soundConverter.processFrame(frame);
                        }
                    }
                };
            }
            this.__decoder.addOnRaiseFrame(action);
            this.__threadActive = true;
            this.__threadExited = false;
            this.__thread = new ManagedThread((IAction1<ManagedThread>)new IActionDelegate1<ManagedThread>(){

                @Override
                public String getId() {
                    return "fm.icelink.matroska.AudioSource.captureLoop";
                }

                @Override
                public void invoke(ManagedThread thread) {
                    AudioSource.this.captureLoop(thread);
                }
            });
            this.__thread.start();
            promise.resolve(null);
        }
        catch (Exception exception) {
            promise.reject(exception);
        }
        return promise;
    }

    @Override
    protected Future<Object> doStop() {
        Promise<Object> promise = new Promise<Object>();
        try {
            this.__threadActive = false;
            while (!this.__threadExited) {
                ManagedThread.sleep(10);
            }
            promise.resolve(null);
        }
        catch (Exception exception) {
            promise.reject(exception);
        }
        return promise;
    }

    @Override
    public Future<SourceInput[]> getInputs() {
        Promise<SourceInput[]> promise = new Promise<SourceInput[]>();
        try {
            ArrayList<SourceInput> list = new ArrayList<SourceInput>();
            for (TrackEntry entry : AudioSource.getTrackEntries(this.__tracks)) {
                list.add(new SourceInput(LongExtensions.toString(entry.getTrackUid()), entry.getName()));
            }
            promise.resolve(list.toArray(new SourceInput[0]));
        }
        catch (Exception exception) {
            promise.reject(exception);
        }
        return promise;
    }

    @Override
    public String getLabel() {
        return StringExtensions.format("Matroska Audio Source", new Object[0]);
    }

    public String getPath() {
        return this._path;
    }

    private static TrackEntry[] getTrackEntries(Track[] tracks) {
        ArrayList<TrackEntry> list = new ArrayList<TrackEntry>();
        for (Track track : tracks) {
            TrackEntry[] trackEntries = track.getTrackEntries();
            if (trackEntries == null) continue;
            for (TrackEntry entry : trackEntries) {
                if (entry.getTrackType() != TrackType.getAudio()) continue;
                list.add(entry);
            }
        }
        return list.toArray(new TrackEntry[0]);
    }

    private void parseFile() {
        this.__file = new File(this.__data);
        this.__segment = this.__file.getSegment();
        if (this.__segment == null) {
            throw new RuntimeException(new Exception("Matroska file has no segment."));
        }
        this.__segmentInfo = this.__segment.getSegmentInfo();
        this.__timecodeScale = this.__segmentInfo == null ? SegmentInfo.getDefaultTimecodeScale() : this.__segmentInfo.getTimecodeScale();
        this.__tracks = this.__segment.getTracks();
        if (this.__tracks == null) {
            throw new RuntimeException(new Exception("Matroska file has no tracks."));
        }
        this.__clusters = this.__segment.getClusters();
        if (this.__clusters == null) {
            throw new RuntimeException(new Exception("Matroska file has no clusters."));
        }
    }

    private void processBlock(Block block, long clusterTimecode, long elapsedTicks) {
        if (block.getTrackNumber() == this.__trackNumber) {
            long num = (clusterTimecode + (long)block.getTimecode()) * this.__timecodeScale;
            long num2 = num / 100L;
            if (num2 > elapsedTicks) {
                ManagedThread.sleep((int)((num2 - elapsedTicks) / (long)Constants.getTicksPerMillisecond()));
            }
            if (this.__threadActive) {
                long num3 = this.__baseTimestamp + (long)this.__clockRate * num2 / (long)Constants.getTicksPerSecond();
                AudioFrame frame2 = new AudioFrame(-1.0, new AudioBuffer(DataBuffer.wrap(block.getData()), (AudioFormat)this.__decoder.getInputFormat()));
                frame2.setTimestamp(num3);
                AudioFrame frame = frame2;
                this.__decoder.processFrame(frame);
                if (this.__lastTimestamp != -1L) {
                    this.__lastTimestampChange = (int)(num3 - this.__lastTimestamp);
                }
                this.__lastTimestamp = num3;
            }
        }
    }

    private void readFile() {
        FileStream stream = new FileStream(this.getPath());
        stream.open(FileStreamAccess.Read);
        this.__data = new byte[(int)stream.getLength()];
        for (int i = 0; i < ArrayExtensions.getLength(this.__data); i += stream.read(this.__data, i, MathAssistant.min(ArrayExtensions.getLength(this.__data) - i, 8192))) {
        }
        stream.close();
    }

    public void removeOnEnded(IAction0 value) {
        IAction0 match;
        if (value instanceof IActionDelegate0 && (match = Global.findIActionDelegate0WithId(this.__onEnded, ((IActionDelegate0)value).getId())) != null) {
            value = match;
        }
        this.__onEnded.remove(value);
        if (this.__onEnded.size() == 0) {
            this._onEnded = null;
        }
    }

    private void setPath(String value) {
        this._path = value;
    }
}

