/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.Dynamic;
import fm.icelink.Error;
import fm.icelink.Global;
import fm.icelink.Guid;
import fm.icelink.IAction0;
import fm.icelink.IActionDelegate0;
import fm.icelink.IStream;
import fm.icelink.StreamDirection;
import fm.icelink.StreamType;
import fm.icelink.sdp.Attribute;
import fm.icelink.sdp.MediaDescription;
import fm.icelink.sdp.Message;
import fm.icelink.sdp.ice.OptionsAttribute;
import java.util.ArrayList;
import java.util.List;

public abstract class StreamBase
extends Dynamic
implements IStream {
    private List<IAction0> __onDirectionChange = new ArrayList<IAction0>();
    private boolean __remoteSupportsTrickleIce = false;
    private String _id;
    private IAction0 _onDirectionChange = null;
    private String _tag;
    private StreamType _type;

    @Override
    public void addOnDirectionChange(IAction0 value) {
        if (value != null) {
            if (this._onDirectionChange == null) {
                this._onDirectionChange = new IAction0(){

                    @Override
                    public void invoke() {
                        for (IAction0 action : new ArrayList(StreamBase.this.__onDirectionChange)) {
                            action.invoke();
                        }
                    }
                };
            }
            this.__onDirectionChange.add(value);
        }
    }

    @Override
    public abstract Error changeDirection(StreamDirection var1);

    @Override
    public abstract StreamDirection getDirection();

    abstract StreamDirection getDirectionCapabilities();

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public abstract String getLabel();

    @Override
    public abstract StreamDirection getLocalDirection();

    public boolean getLocalReceive() {
        StreamDirection localDirection = this.getLocalDirection();
        return Global.equals((Object)localDirection, (Object)StreamDirection.SendReceive) || Global.equals((Object)localDirection, (Object)StreamDirection.ReceiveOnly);
    }

    public boolean getLocalSend() {
        StreamDirection localDirection = this.getLocalDirection();
        return Global.equals((Object)localDirection, (Object)StreamDirection.SendReceive) || Global.equals((Object)localDirection, (Object)StreamDirection.SendOnly);
    }

    public abstract StreamDirection getRemoteDirection();

    public boolean getRemoteReceive() {
        StreamDirection remoteDirection = this.getRemoteDirection();
        return Global.equals((Object)remoteDirection, (Object)StreamDirection.SendReceive) || Global.equals((Object)remoteDirection, (Object)StreamDirection.ReceiveOnly);
    }

    public boolean getRemoteSend() {
        StreamDirection remoteDirection = this.getRemoteDirection();
        return Global.equals((Object)remoteDirection, (Object)StreamDirection.SendReceive) || Global.equals((Object)remoteDirection, (Object)StreamDirection.SendOnly);
    }

    boolean getRemoteSupportsTrickleIce() {
        return this.__remoteSupportsTrickleIce;
    }

    @Override
    public String getTag() {
        return this._tag;
    }

    @Override
    public StreamType getType() {
        return this._type;
    }

    Error processSdpMediaDescription(Message sdpMessage, MediaDescription sdpMediaDescription, boolean isLocalDescription, boolean isOffer, boolean isRenegotiation) {
        if (!isLocalDescription) {
            boolean flag = this.trickleIceSupported(sdpMessage.getSessionLevelIceOptionAttributes());
            if (!flag) {
                flag = this.trickleIceSupported(sdpMediaDescription.getIceOptionAttributes());
            }
            this.setRemoteSupportsTrickleIce(flag);
        }
        return null;
    }

    void raiseDirectionChange() {
        IAction0 onDirectionChange = this._onDirectionChange;
        if (onDirectionChange != null) {
            onDirectionChange.invoke();
        }
    }

    @Override
    public void removeOnDirectionChange(IAction0 value) {
        IAction0 match;
        if (value instanceof IActionDelegate0 && (match = Global.findIActionDelegate0WithId(this.__onDirectionChange, ((IActionDelegate0)value).getId())) != null) {
            value = match;
        }
        this.__onDirectionChange.remove(value);
        if (this.__onDirectionChange.size() == 0) {
            this._onDirectionChange = null;
        }
    }

    @Override
    public void setId(String value) {
        this._id = value;
    }

    @Override
    public abstract void setLocalDirection(StreamDirection var1);

    public void setLocalReceive(boolean value) {
        StreamDirection localDirection = this.getLocalDirection();
        StreamDirection _var0 = localDirection;
        if (_var0 == StreamDirection.SendReceive) {
            if (!value) {
                this.setLocalDirection(StreamDirection.SendOnly);
            }
        } else if (_var0 == StreamDirection.Inactive || _var0 == StreamDirection.Unset) {
            if (value) {
                this.setLocalDirection(StreamDirection.ReceiveOnly);
            }
        } else if (_var0 == StreamDirection.SendOnly) {
            if (value) {
                this.setLocalDirection(StreamDirection.SendReceive);
            }
        } else if (Global.equals((Object)localDirection, (Object)StreamDirection.ReceiveOnly) && !value) {
            this.setLocalDirection(StreamDirection.Inactive);
        }
    }

    public void setLocalSend(boolean value) {
        StreamDirection localDirection = this.getLocalDirection();
        StreamDirection _var0 = localDirection;
        if (_var0 == StreamDirection.SendReceive) {
            if (!value) {
                this.setLocalDirection(StreamDirection.ReceiveOnly);
            }
        } else if (_var0 == StreamDirection.Inactive || _var0 == StreamDirection.Unset) {
            if (value) {
                this.setLocalDirection(StreamDirection.SendOnly);
            }
        } else if (_var0 == StreamDirection.ReceiveOnly) {
            if (value) {
                this.setLocalDirection(StreamDirection.SendReceive);
            }
        } else if (Global.equals((Object)localDirection, (Object)StreamDirection.SendOnly) && !value) {
            this.setLocalDirection(StreamDirection.Inactive);
        }
    }

    protected abstract void setRemoteDirection(StreamDirection var1);

    void setRemoteSupportsTrickleIce(boolean value) {
        this.__remoteSupportsTrickleIce = value;
    }

    @Override
    public void setTag(String value) {
        this._tag = value;
    }

    private void setType(StreamType value) {
        this._type = value;
    }

    public StreamBase(StreamType type) {
        this.setId(Guid.newGuid().toString().replace("-", ""));
        this.setType(type);
    }

    public String toString() {
        return this.getLabel();
    }

    private boolean trickleIceSupported(Attribute[] iceOptions) {
        OptionsAttribute attribute = null;
        boolean flag = false;
        if (iceOptions != null) {
            for (int i = 0; !flag && i < ArrayExtensions.getLength(iceOptions); ++i) {
                attribute = (OptionsAttribute)iceOptions[i];
                flag = flag || attribute.getTrickleOptionSet();
            }
        }
        return flag;
    }
}

