/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.DateExtensions;
import fm.icelink.Future;
import fm.icelink.HashMapExtensions;
import fm.icelink.Holder;
import fm.icelink.IAction1;
import fm.icelink.IActionDelegate1;
import fm.icelink.ManagedCondition;
import fm.icelink.ManagedThread;
import fm.icelink.MathAssistant;
import fm.icelink.Promise;
import fm.icelink.ScheduledItem;
import fm.icelink.TimeSpan;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;

class Scheduler {
    private volatile boolean __active = false;
    private ManagedCondition __condition = new ManagedCondition();
    private Promise<Object> __exited;
    private Object __lock;
    private HashMap<String, ScheduledItem> __scheduledItems = new HashMap();
    private boolean __started = false;
    private ManagedThread __thread;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(ScheduledItem item) {
        ManagedCondition managedCondition = this.__condition;
        synchronized (managedCondition) {
            if (this.__scheduledItems.containsKey(item.getId())) {
                if (item.getNextInvocationTime() > Scheduler.getCurrentTime() + (long)item.getDelay()) {
                    item.setNextInvocationTime(Scheduler.getCurrentTime() + (long)item.getDelay());
                }
            } else {
                item.setNextInvocationTime(Scheduler.getCurrentTime() + (long)item.getDelay());
                HashMapExtensions.set(HashMapExtensions.getItem(this.__scheduledItems), item.getId(), item);
                item.setOnSuspendStatusChanged((IAction1<ScheduledItem>)new IActionDelegate1<ScheduledItem>(){

                    @Override
                    public String getId() {
                        return "fm.icelink.Scheduler.processSuspendedStatusChanged";
                    }

                    @Override
                    public void invoke(ScheduledItem item) {
                        Scheduler.this.processSuspendedStatusChanged(item);
                    }
                });
            }
            if (!item.getSuspended()) {
                this.__condition.pulse();
            }
        }
    }

    public static long getCurrentTime() {
        Date time = DateExtensions.createDate(1970, 1, 1, 0, 0, 0);
        TimeSpan span = new TimeSpan(DateExtensions.getTicks(DateExtensions.getUtcNow()) - DateExtensions.getTicks(time));
        return (long)span.getTotalMilliseconds();
    }

    private static int getUnset() {
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean itemIsScheduled(ScheduledItem item) {
        ManagedCondition managedCondition = this.__condition;
        synchronized (managedCondition) {
            return this.__scheduledItems.containsKey(item.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loop(ManagedThread thread) {
        ScheduledItem item = null;
        ArrayList<ScheduledItem> list = new ArrayList<ScheduledItem>();
        ArrayList<ScheduledItem> list2 = new ArrayList<ScheduledItem>();
        ArrayList<ScheduledItem> list3 = new ArrayList<ScheduledItem>();
        while (this.__active) {
            IAction1<ScheduledItem> defaultCallback;
            long currentTime;
            thread.loopBegin();
            Iterator iterator = this.__condition;
            synchronized (iterator) {
                currentTime = Scheduler.getCurrentTime();
                int unset = Scheduler.getUnset();
                for (String str : HashMapExtensions.getKeys(this.__scheduledItems)) {
                    Holder<Object> _var0 = new Holder<Object>(item);
                    boolean _var1 = HashMapExtensions.tryGetValue(this.__scheduledItems, str, _var0);
                    item = _var0.getValue();
                    if (!_var1 || item == null || item.getSuspended()) continue;
                    int num3 = MathAssistant.max(0, (int)(item.getNextInvocationTime() - currentTime));
                    if (unset != Scheduler.getUnset() && unset <= num3) continue;
                    unset = num3;
                }
                if (unset != Scheduler.getUnset()) {
                    this.__condition.halt(unset);
                } else {
                    this.__condition.halt();
                }
                if (!this.__active) {
                    this.__exited.resolve(null);
                    return;
                }
                currentTime = Scheduler.getCurrentTime();
                list.clear();
                list2.clear();
                for (String str : HashMapExtensions.getKeys(this.__scheduledItems)) {
                    boolean flag8;
                    boolean flag7;
                    Holder<ScheduledItem> _var2 = new Holder<ScheduledItem>(item);
                    boolean _var3 = HashMapExtensions.tryGetValue(this.__scheduledItems, str, _var2);
                    item = _var2.getValue();
                    if (!_var3 || item == null || item.getSuspended()) continue;
                    boolean flag2 = item.getInvocationCount() == 0;
                    boolean flag3 = item.getInvocationCountLimit() != ScheduledItem.getUnset();
                    boolean flag4 = !flag3 || item.getInvocationCountLimit() > item.getInvocationCount();
                    boolean flag5 = !flag3 || item.getInvocationCountLimit() > item.getInvocationCount() + 1;
                    boolean flag6 = item.getInvocationLifetimeLimit() != ScheduledItem.getUnset();
                    boolean bl = flag7 = !flag6 || flag2 || currentTime - item.getOriginalInvocationTime() - item.getTotalSuspendedDuration() < (long)item.getInvocationLifetimeLimit();
                    if (!flag4 || !flag7) {
                        list3.add(item);
                        item.setLastDefaultInvocationOccurred(true);
                        if (flag7) continue;
                        list2.add(item);
                        continue;
                    }
                    if (item.getNextInvocationTime() > currentTime) continue;
                    list.add(item);
                    if (flag2) {
                        item.setOriginalInvocationTime(currentTime);
                    }
                    item.setInterval((int)MathAssistant.floor((float)item.getInterval() * item.getIntervalBackoffMultiplier()));
                    int num4 = item.getInvocationCount() + 1;
                    item.setInvocationCount(num4);
                    boolean bl2 = flag8 = !flag6 || currentTime - item.getOriginalInvocationTime() - item.getTotalSuspendedDuration() <= (long)(item.getInvocationLifetimeLimit() - item.getInterval());
                    if (flag8 && flag5) {
                        item.setNextInvocationTime(currentTime + (long)item.getInterval());
                        continue;
                    }
                    if (!flag8) {
                        item.setLastDefaultInvocationOccurred(true);
                        item.setNextInvocationTime(item.getOriginalInvocationTime() + (long)item.getInvocationLifetimeLimit() + 1L);
                        continue;
                    }
                    if (flag5) continue;
                    list3.add(item);
                    item.setLastDefaultInvocationOccurred(true);
                }
                for (ScheduledItem item2 : list3) {
                    this.remove(item2);
                }
                list3.clear();
            }
            for (ScheduledItem item2 : list) {
                if (item2 == null) continue;
                defaultCallback = item2.getDefaultCallback();
                if (defaultCallback != null) {
                    try {
                        defaultCallback.invoke(item2);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                item2.setLastInvocationTime(currentTime);
                if (!item2.getRecordDetailedInvocationTimes()) continue;
                item2.setInvocationTime(item2.getInvocationCount(), currentTime);
            }
            list.clear();
            for (ScheduledItem item2 : list2) {
                if (item2 == null || (defaultCallback = item2.getTimeoutCallback()) == null) continue;
                try {
                    defaultCallback.invoke(item2);
                }
                catch (Exception exception) {}
            }
            list2.clear();
            thread.loopEnd();
        }
        this.__exited.resolve(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSuspendedStatusChanged(ScheduledItem item) {
        if (item.getSuspended()) {
            item.setLastSuspendedTime(Scheduler.getCurrentTime());
        } else {
            ManagedCondition managedCondition = this.__condition;
            synchronized (managedCondition) {
                long num;
                item.setLastResumedTime(Scheduler.getCurrentTime());
                if (item.getLastSuspendedTime() != (long)ScheduledItem.getUnset() && (num = item.getLastResumedTime() - item.getLastSuspendedTime()) > 0L && item.getInvocationCount() > 0) {
                    item.setTotalSuspendedDuration(item.getTotalSuspendedDuration() + num);
                    item.setNextInvocationTime(item.getNextInvocationTime() + num);
                }
                this.__condition.pulse();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(ScheduledItem item) {
        if (item != null) {
            ManagedCondition managedCondition = this.__condition;
            synchronized (managedCondition) {
                String id = item.getId();
                Holder<ScheduledItem> _var0 = new Holder<ScheduledItem>(item);
                boolean _var1 = HashMapExtensions.tryGetValue(this.__scheduledItems, id, _var0);
                item = _var0.getValue();
                if (_var1) {
                    item.setOnSuspendStatusChanged(null);
                    HashMapExtensions.remove(this.__scheduledItems, id);
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    public Scheduler(Object lockObject) {
        this.__lock = lockObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean start() {
        Object object = this.__lock;
        synchronized (object) {
            if (this.__started) {
                return false;
            }
            this.__started = true;
        }
        this.__active = true;
        this.__thread = new ManagedThread((IAction1<ManagedThread>)new IActionDelegate1<ManagedThread>(){

            @Override
            public String getId() {
                return "fm.icelink.Scheduler.loop";
            }

            @Override
            public void invoke(ManagedThread thread) {
                Scheduler.this.loop(thread);
            }
        });
        this.__thread.start();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<Object> stop() {
        Object object = this.__lock;
        synchronized (object) {
            if (!this.__started) {
                Promise<Object> promise = new Promise<Object>();
                promise.reject(new Exception("Scheduler has never been started."));
                return promise;
            }
        }
        object = this.__condition;
        synchronized (object) {
            if (!this.__active) {
                Promise<Object> promise = new Promise<Object>();
                promise.reject(new Exception("Scheduler has already been stopped."));
                return promise;
            }
            this.__exited = new Promise();
            this.__active = false;
            this.__condition.pulse();
        }
        return this.__exited;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trigger(ScheduledItem item) {
        ManagedCondition managedCondition = this.__condition;
        synchronized (managedCondition) {
            this.remove(item);
            item.setDelay(0);
            this.add(item);
        }
    }
}

