/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.Binary;
import fm.icelink.BitAssistant;
import fm.icelink.ByteCollection;
import fm.icelink.DataBuffer;
import fm.icelink.Encoding;
import fm.icelink.ReliableChannelType;
import fm.icelink.ReliableRtcDcepMessage;

class ReliableRtcDcepDataChannelOpen
extends ReliableRtcDcepMessage {
    private int _channelPriority;
    private ReliableChannelType _channelType;
    private String _label;
    private long _reliabilityParameter;
    private String _subProtocol;

    public static byte[] getBytes(ReliableRtcDcepDataChannelOpen message) {
        ByteCollection bytes = new ByteCollection();
        bytes.add(BitAssistant.castByte(message.getMessageType()));
        bytes.add(BitAssistant.castByte(ReliableRtcDcepMessage.getByteFromChannelType(message.getChannelType())));
        bytes.addRange(Binary.toBytes16(message.getChannelPriority(), false));
        bytes.addRange(Binary.toBytes32(message.getReliabilityParameter(), false));
        byte[] buffer = Encoding.getUtf8().getBytes(message.getLabel());
        byte[] buffer2 = Encoding.getUtf8().getBytes(message.getSubProtocol());
        bytes.addRange(Binary.toBytes16(ArrayExtensions.getLength(buffer), false));
        bytes.addRange(Binary.toBytes16(ArrayExtensions.getLength(buffer2), false));
        bytes.addRange(buffer);
        bytes.addRange(buffer2);
        return bytes.toArray();
    }

    @Override
    public byte[] getBytes() {
        return ReliableRtcDcepDataChannelOpen.getBytes(this);
    }

    public int getChannelPriority() {
        return this._channelPriority;
    }

    public ReliableChannelType getChannelType() {
        return this._channelType;
    }

    public String getLabel() {
        return this._label;
    }

    public long getReliabilityParameter() {
        return this._reliabilityParameter;
    }

    public String getSubProtocol() {
        return this._subProtocol;
    }

    public static ReliableRtcDcepDataChannelOpen parseBytes(DataBuffer buffer) {
        try {
            ReliableChannelType requestedChannelType = ReliableRtcDcepMessage.parseChannelTypeByte(buffer.read8(1));
            int length = buffer.read16(8);
            int num2 = buffer.read16(10);
            String channelLabel = buffer.readUtf8String(12, length);
            return new ReliableRtcDcepDataChannelOpen(requestedChannelType, channelLabel, buffer.readUtf8String(12 + length, num2));
        }
        catch (Exception exception1) {
            return null;
        }
    }

    public ReliableRtcDcepDataChannelOpen(ReliableChannelType requestedChannelType) {
        this(requestedChannelType, "", "");
    }

    public ReliableRtcDcepDataChannelOpen(ReliableChannelType requestedChannelType, String channelLabel, String subprotocol) {
        this.setChannelType(requestedChannelType);
        this.setSubProtocol(subprotocol);
        super.setMessageType(3);
        this.setLabel(channelLabel);
        this.setChannelPriority(256);
        this.setReliabilityParameter(0L);
    }

    private void setChannelPriority(int value) {
        this._channelPriority = value;
    }

    private void setChannelType(ReliableChannelType value) {
        this._channelType = value;
    }

    private void setLabel(String value) {
        this._label = value;
    }

    private void setReliabilityParameter(long value) {
        this._reliabilityParameter = value;
    }

    private void setSubProtocol(String value) {
        this._subProtocol = value;
    }
}

