/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.CandidateType;
import fm.icelink.Error;
import fm.icelink.ErrorCode;
import fm.icelink.Global;
import fm.icelink.Guid;
import fm.icelink.IAction1;
import fm.icelink.IActionDelegate1;
import fm.icelink.IceCandidate;
import fm.icelink.IceDatagramSocketManager;
import fm.icelink.IceLocalCandidateState;
import fm.icelink.IceLocalRelayedCandidateState;
import fm.icelink.IceSendMessageArgs;
import fm.icelink.IceSendRequestFailureArgs;
import fm.icelink.IceSendRequestSuccessArgs;
import fm.icelink.IceTransactionManager;
import fm.icelink.IntegerExtensions;
import fm.icelink.Log;
import fm.icelink.LongExtensions;
import fm.icelink.MathAssistant;
import fm.icelink.ProtocolType;
import fm.icelink.ScheduledItem;
import fm.icelink.Scheduler;
import fm.icelink.StringExtensions;
import fm.icelink.TransportAddress;
import fm.icelink.stun.MessageIntegrityAttribute;
import fm.icelink.stun.NonceAttribute;
import fm.icelink.stun.RealmAttribute;
import fm.icelink.stun.StaleNonceError;
import fm.icelink.stun.UsernameAttribute;
import fm.icelink.stun.Utility;
import fm.icelink.stun.turn.CreatePermissionRequest;
import fm.icelink.stun.turn.LifetimeAttribute;
import fm.icelink.stun.turn.RefreshRequest;
import fm.icelink.stun.turn.RefreshResponse;
import fm.icelink.stun.turn.XorPeerAddressAttribute;

class IceLocalRelayedCandidate
extends IceCandidate {
    private ScheduledItem __deallocateItem;
    private long __expires;
    private int __hashCode;
    private ScheduledItem __refreshItem;
    private boolean __refreshScheduled;
    private IceLocalRelayedCandidateState __relayState;
    private int __smoothedRelayServerRoundTripTime = -1;
    private int __stunRequestTimeout = ScheduledItem.getUnset();
    private IceTransactionManager __transactionManager;
    private String __turnPassword;
    private String __turnRealm;
    private TransportAddress __turnServer;
    private String __turnUsername;
    private int _lastRelayServerRoundTripTime;
    private String _nonce;
    private IAction1<IceLocalRelayedCandidate> _onRelayStateChanged;

    public void deallocate() {
        this.setRelayState(IceLocalRelayedCandidateState.Closing);
        RefreshRequest message = new RefreshRequest();
        message.setLifetime(new LifetimeAttribute(0L));
        message.setUsername(new UsernameAttribute(this.__turnUsername));
        message.setRealm(new RealmAttribute(this.__turnRealm));
        message.setNonce(new NonceAttribute(this.getNonce()));
        message.setMessageIntegrity(new MessageIntegrityAttribute(Utility.createLongTermKey(this.__turnUsername, this.__turnRealm, this.__turnPassword)));
        IceSendMessageArgs args2 = new IceSendMessageArgs(message, this.getTurnServer());
        args2.setRelayPassword(this.__turnPassword);
        args2.setOnResponse((IAction1<IceSendRequestSuccessArgs>)new IActionDelegate1<IceSendRequestSuccessArgs>(){

            @Override
            public String getId() {
                return "fm.icelink.IceLocalRelayedCandidate.processDeallocateResponse";
            }

            @Override
            public void invoke(IceSendRequestSuccessArgs e) {
                IceLocalRelayedCandidate.this.processDeallocateResponse(e);
            }
        });
        args2.setOnFailure((IAction1<IceSendRequestFailureArgs>)new IActionDelegate1<IceSendRequestFailureArgs>(){

            @Override
            public String getId() {
                return "fm.icelink.IceLocalRelayedCandidate.processDeallocateExecutionFailed";
            }

            @Override
            public void invoke(IceSendRequestFailureArgs e) {
                IceLocalRelayedCandidate.this.processDeallocateExecutionFailed(e);
            }
        });
        IceSendMessageArgs args = args2;
        this.__transactionManager.remove(this.__refreshItem, (Object)this);
        this.__refreshScheduled = false;
        ScheduledItem item = new ScheduledItem((IAction1<ScheduledItem>)new IActionDelegate1<ScheduledItem>(){

            @Override
            public String getId() {
                return "fm.icelink.IceCandidate.sendStunMessage";
            }

            @Override
            public void invoke(ScheduledItem item) {
                IceLocalRelayedCandidate.this.sendStunMessage(item);
            }
        }, 0, 100, this.__stunRequestTimeout, ScheduledItem.getUnset());
        item.setState(args);
        item.setIntervalBackoffMultiplier(2.0f);
        item.setTimeoutCallback((IAction1<ScheduledItem>)new IActionDelegate1<ScheduledItem>(){

            @Override
            public String getId() {
                return "fm.icelink.IceLocalRelayedCandidate.processDeallocateTimedout";
            }

            @Override
            public void invoke(ScheduledItem item) {
                IceLocalRelayedCandidate.this.processDeallocateTimedout(item);
            }
        });
        this.__deallocateItem = item;
        this.__transactionManager.addTransaction(this.__deallocateItem, this);
    }

    private ScheduledItem generateAllocationRefreshScheduledItem() {
        RefreshRequest message = new RefreshRequest();
        message.setUsername(new UsernameAttribute(this.__turnUsername));
        message.setRealm(new RealmAttribute(this.__turnRealm));
        message.setNonce(new NonceAttribute(this.getNonce()));
        message.setMessageIntegrity(new MessageIntegrityAttribute(Utility.createLongTermKey(this.__turnUsername, this.__turnRealm, this.__turnPassword)));
        IceSendMessageArgs args2 = new IceSendMessageArgs(message, this.getTurnServer());
        args2.setRelayPassword(this.__turnPassword);
        args2.setOnResponse((IAction1<IceSendRequestSuccessArgs>)new IActionDelegate1<IceSendRequestSuccessArgs>(){

            @Override
            public String getId() {
                return "fm.icelink.IceLocalRelayedCandidate.processRefreshResponse";
            }

            @Override
            public void invoke(IceSendRequestSuccessArgs e) {
                IceLocalRelayedCandidate.this.processRefreshResponse(e);
            }
        });
        args2.setOnFailure((IAction1<IceSendRequestFailureArgs>)new IActionDelegate1<IceSendRequestFailureArgs>(){

            @Override
            public String getId() {
                return "fm.icelink.IceLocalRelayedCandidate.processRefreshExecutionFailed";
            }

            @Override
            public void invoke(IceSendRequestFailureArgs e) {
                IceLocalRelayedCandidate.this.processRefreshExecutionFailed(e);
            }
        });
        IceSendMessageArgs args = args2;
        int delay = MathAssistant.max(0, (int)(this.getExpires() - Scheduler.getCurrentTime() - 60000L));
        ScheduledItem item2 = new ScheduledItem((IAction1<ScheduledItem>)new IActionDelegate1<ScheduledItem>(){

            @Override
            public String getId() {
                return "fm.icelink.IceCandidate.sendStunAndInsertAttemptMessage";
            }

            @Override
            public void invoke(ScheduledItem item) {
                IceLocalRelayedCandidate.this.sendStunAndInsertAttemptMessage(item);
            }
        }, delay, 100, 15000, ScheduledItem.getUnset());
        item2.setState(args);
        item2.setIntervalBackoffMultiplier(2.0f);
        item2.setTimeoutCallback((IAction1<ScheduledItem>)new IActionDelegate1<ScheduledItem>(){

            @Override
            public String getId() {
                return "fm.icelink.IceLocalRelayedCandidate.processRefreshTimedout";
            }

            @Override
            public void invoke(ScheduledItem item) {
                IceLocalRelayedCandidate.this.processRefreshTimedout(item);
            }
        });
        return item2;
    }

    CreatePermissionRequest generatePermissionRequest(String ipAddress) {
        CreatePermissionRequest request = new CreatePermissionRequest();
        request.setXorPeerAddress(new XorPeerAddressAttribute(ipAddress, 0, request.getTransactionId()));
        request.setUsername(new UsernameAttribute(this.__turnUsername));
        request.setRealm(new RealmAttribute(this.__turnRealm));
        request.setNonce(new NonceAttribute(this.getNonce()));
        request.setMessageIntegrity(new MessageIntegrityAttribute(Utility.createLongTermKey(this.__turnUsername, this.__turnRealm, this.__turnPassword)));
        return request;
    }

    private long getExpires() {
        return this.__expires;
    }

    public int getLastRelayServerRoundTripTime() {
        return this._lastRelayServerRoundTripTime;
    }

    String getNonce() {
        return this._nonce;
    }

    public IAction1<IceLocalRelayedCandidate> getOnRelayStateChanged() {
        return this._onRelayStateChanged;
    }

    public boolean getOpen() {
        return Global.equals((Object)this.__relayState, (Object)IceLocalRelayedCandidateState.Allocated) || Global.equals((Object)this.__relayState, (Object)IceLocalRelayedCandidateState.Refreshing);
    }

    public IceLocalRelayedCandidateState getRelayState() {
        return this.__relayState;
    }

    public int getSmoothedRelayServerRoundTripTime() {
        return this.__smoothedRelayServerRoundTripTime;
    }

    public TransportAddress getTurnServer() {
        return this.__turnServer;
    }

    @Override
    public int hashCode() {
        return this.__hashCode;
    }

    public IceLocalRelayedCandidate(Object lockObject, String foundation, ProtocolType protocol, String address, int port, String relatedAddress, int relatedPort, long lifetime, String turnUserName, String turnPassword, String nonce, String turnRealm, TransportAddress server, IceTransactionManager manager, int stunRequestTimeout) {
        super(lockObject, foundation, protocol, address, port, CandidateType.Relayed, relatedAddress, relatedPort);
        this.__expires = Scheduler.getCurrentTime() + lifetime * 1000L;
        if (lifetime > 0L) {
            this.setRelayState(IceLocalRelayedCandidateState.Allocated);
        } else {
            this.setRelayState(IceLocalRelayedCandidateState.Closed);
        }
        this.__turnServer = server;
        this.__turnUsername = turnUserName;
        this.__turnPassword = turnPassword;
        this.setNonce(nonce);
        this.__turnRealm = turnRealm;
        this.__transactionManager = manager;
        this.__hashCode = Guid.newGuid().hashCode();
        this.__stunRequestTimeout = stunRequestTimeout;
    }

    private void processDeallocateExecutionFailed(IceSendRequestFailureArgs e) {
        if (Log.getIsWarnEnabled()) {
            Log.warn(StringExtensions.format("Deallocate timed out for {0}.", this.toString()));
        }
        this.__transactionManager.remove(this.__deallocateItem, (Object)this);
        this.setRelayState(IceLocalRelayedCandidateState.Closed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDeallocateResponse(IceSendRequestSuccessArgs e) {
        if (e.getResponse() instanceof RefreshResponse) {
            ScheduledItem item = e.getItem();
            IceSendMessageArgs state = (IceSendMessageArgs)item.getState();
            int num = (int)((long)item.getInvocationLifetimeLimit() + item.getOriginalInvocationTime() - Scheduler.getCurrentTime());
            Error error = IceDatagramSocketManager.validateResponse(state, e.getResponse(), e.getRemoteAddress());
            if (error == null) {
                this.__transactionManager.remove(item, (Object)this);
                Log.debug(StringExtensions.format("Local relayed candidate {0} was successfully deallocated on the relay server.", this.toString()));
                this.setRelayState(IceLocalRelayedCandidateState.Closed);
            } else {
                if (Global.equals((Object)error.getErrorCode(), (Object)ErrorCode.StunStaleNonce)) {
                    StaleNonceError error2 = (StaleNonceError)error;
                    this.setNonce(error2.getNonce().getValue());
                    IceSendMessageArgs args2 = (IceSendMessageArgs)item.getState();
                    args2.getMessage().setNonce(new NonceAttribute(this.getNonce()));
                } else if (!Global.equals((Object)error.getErrorCode(), (Object)ErrorCode.StunServerError)) {
                    if (Global.equals((Object)error.getErrorCode(), (Object)ErrorCode.StunTurnAllocationMismatch)) {
                        this.__transactionManager.remove(item, (Object)this);
                        this.setRelayState(IceLocalRelayedCandidateState.Closed);
                        return;
                    }
                    if (error != null) {
                        if (Log.getIsDebugEnabled()) {
                            Log.debug(StringExtensions.format("Deallocate failed for {0}. {1}", this.toString(), error.getDescription()));
                        }
                        this.__transactionManager.remove(item, (Object)this);
                        this.setRelayState(IceLocalRelayedCandidateState.Closed);
                        return;
                    }
                }
                if (num <= 0) {
                    if (Log.getIsWarnEnabled()) {
                        Log.warn(StringExtensions.format("Deallocate failed for {0} after several attempts. {1}", this.toString(), error.getDescription()));
                    }
                    Object object = super.getLock();
                    synchronized (object) {
                        this.setRelayState(IceLocalRelayedCandidateState.Closed);
                    }
                } else {
                    this.__transactionManager.remove(item, (Object)this);
                    item.setInvocationLifetimeLimit(num);
                    item.setDelay(20);
                    this.__transactionManager.addTransaction(item, this);
                }
            }
        }
    }

    private void processDeallocateTimedout(ScheduledItem item) {
        if (Log.getIsWarnEnabled()) {
            Log.warn(StringExtensions.format("Deallocate timed out for {0} after several attempts.", this.toString()));
        }
        this.__transactionManager.remove(item, (Object)this);
        this.setRelayState(IceLocalRelayedCandidateState.Closed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processDSMFailure() {
        Object object = super.getLock();
        synchronized (object) {
            if (this.__transactionManager != null) {
                this.__transactionManager.remove(this);
                this.__refreshScheduled = false;
            }
            this.setRelayState(IceLocalRelayedCandidateState.Closed);
        }
    }

    private void processRefreshExecutionFailed(IceSendRequestFailureArgs e) {
        Error error = e.getError();
        String str = error != null ? error.getDescription() : "";
        Log.error(StringExtensions.format(StringExtensions.format("Refresh request failed for {0}. {1}", this.toString(), str), new Object[0]));
        this.processRefreshFailure(error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRefreshFailure(Error error) {
        Object object = super.getLock();
        synchronized (object) {
            if (this.__refreshScheduled) {
                if (this.__transactionManager != null) {
                    this.__transactionManager.remove(this.__refreshItem, (Object)this);
                    this.__refreshScheduled = false;
                }
                super.setError(error);
                this.setRelayState(IceLocalRelayedCandidateState.Failed);
            }
        }
    }

    private void processRefreshResponse(IceSendRequestSuccessArgs e) {
        if (e.getResponse() instanceof RefreshResponse) {
            ScheduledItem item = e.getItem();
            IceSendMessageArgs state = (IceSendMessageArgs)item.getState();
            int num = (int)((long)item.getInvocationLifetimeLimit() + item.getOriginalInvocationTime() - Scheduler.getCurrentTime());
            Error error = IceDatagramSocketManager.validateResponse(state, e.getResponse(), e.getRemoteAddress());
            int instanteneousRtt = this.__transactionManager.calculateInstanteneousRtt(e, true);
            if (instanteneousRtt > 0) {
                this.setLastRelayServerRoundTripTime(this.__transactionManager.calculateInstanteneousRtt(e, true));
                this.setSmoothedRelayServerRoundTripTime(IceTransactionManager.calculateSmoothedRtt(instanteneousRtt, this.getSmoothedRelayServerRoundTripTime()));
            }
            if (error == null) {
                LifetimeAttribute lifetime = e.getResponse().getLifetime();
                if (lifetime != null && this.__refreshScheduled) {
                    if (Log.getIsDebugEnabled()) {
                        Log.debug(StringExtensions.format("Allocation extended by {0} seconds for {1}.", LongExtensions.toString(lifetime.getLifetime()), this.toString()));
                    }
                    this.setExpires(Scheduler.getCurrentTime() + lifetime.getLifetime() * 1000L);
                }
                this.__transactionManager.remove(item, (Object)this);
            } else {
                if (Global.equals((Object)error.getErrorCode(), (Object)ErrorCode.StunStaleNonce)) {
                    StaleNonceError error2 = (StaleNonceError)error;
                    this.setNonce(error2.getNonce().getValue());
                } else if (!Global.equals((Object)error.getErrorCode(), (Object)ErrorCode.StunServerError)) {
                    String message = StringExtensions.format("Refresh request failed for {0}. {1}", this.toString(), error.getDescription());
                    Error error3 = new Error(ErrorCode.IceRefreshError, new Exception(message));
                    Log.error(StringExtensions.format(message, new Object[0]));
                    this.processRefreshFailure(error3);
                    return;
                }
                if (num > 0 && this.__refreshScheduled) {
                    this.__transactionManager.remove(item, (Object)this);
                    this.__refreshItem = this.generateAllocationRefreshScheduledItem();
                    this.__refreshItem.setInvocationLifetimeLimit(num);
                    this.__refreshItem.setDelay(20);
                    this.__transactionManager.addTransaction(this.__refreshItem, this);
                } else {
                    this.processRefreshTimedout(item);
                }
            }
        }
    }

    private void processRefreshTimedout(ScheduledItem item) {
        IceSendMessageArgs state = (IceSendMessageArgs)item.getState();
        this.__transactionManager.remove(item, (Object)this);
        TransportAddress transportAddress = super.getTransportAddress();
        String str = transportAddress == null ? StringExtensions.empty : transportAddress.toString();
        String message = StringExtensions.format("Refresh request request from {2} to {0}:{1} timed out.", state.getAddress().getIPAddress(), IntegerExtensions.toString(state.getAddress().getPort()), str);
        Log.error(message);
        Error error = new Error(ErrorCode.IceRefreshTimeout, new Exception(message));
        this.processRefreshFailure(error);
    }

    private void setExpires(long value) {
        if (value != this.__expires) {
            this.__expires = value;
            if (this.__refreshItem != null) {
                this.__transactionManager.remove(this.__refreshItem, (Object)this);
            }
            this.__refreshItem = this.generateAllocationRefreshScheduledItem();
            this.__transactionManager.addTransaction(this.__refreshItem, this);
        }
    }

    void setLastRelayServerRoundTripTime(int value) {
        this._lastRelayServerRoundTripTime = value;
    }

    void setNonce(String value) {
        this._nonce = value;
    }

    public void setOnRelayStateChanged(IAction1<IceLocalRelayedCandidate> value) {
        this._onRelayStateChanged = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRelayState(IceLocalRelayedCandidateState value) {
        Object object = super.getLock();
        synchronized (object) {
            if (!Global.equals((Object)value, (Object)this.__relayState)) {
                this.__relayState = value;
                IAction1<IceLocalRelayedCandidate> onRelayStateChanged = this.getOnRelayStateChanged();
                if (onRelayStateChanged != null) {
                    onRelayStateChanged.invoke(this);
                }
                if (Global.equals((Object)this.__relayState, (Object)IceLocalRelayedCandidateState.Closing) || Global.equals((Object)this.__relayState, (Object)IceLocalRelayedCandidateState.Closed)) {
                    if (Global.equals((Object)super.getState(), (Object)IceLocalCandidateState.Ready)) {
                        super.setState(IceLocalCandidateState.Closed);
                    }
                } else if (Global.equals((Object)this.__relayState, (Object)IceLocalRelayedCandidateState.Failed)) {
                    if (Global.equals((Object)super.getState(), (Object)IceLocalCandidateState.Ready)) {
                        super.setState(IceLocalCandidateState.Failed);
                    }
                } else if (Global.equals((Object)this.__relayState, (Object)IceLocalRelayedCandidateState.Refreshing) || Global.equals((Object)this.__relayState, (Object)IceLocalRelayedCandidateState.Allocated)) {
                    // empty if block
                }
            }
        }
    }

    public void setSmoothedRelayServerRoundTripTime(int value) {
        this.__smoothedRelayServerRoundTripTime = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startScheduleRefreshTransactions() {
        Object object = super.getLock();
        synchronized (object) {
            if (!(this.__refreshScheduled && this.getOpen() || !Global.equals((Object)this.getRelayState(), (Object)IceLocalRelayedCandidateState.Allocated))) {
                this.__refreshItem = this.generateAllocationRefreshScheduledItem();
                this.__transactionManager.addTransaction(this.__refreshItem, this);
                this.__refreshScheduled = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopRelayTransactions(boolean deallocate) {
        Object object = super.getLock();
        synchronized (object) {
            if (!this.__refreshScheduled) {
                if (Global.equals((Object)this.getRelayState(), (Object)IceLocalRelayedCandidateState.Allocated)) {
                    this.setRelayState(IceLocalRelayedCandidateState.Closed);
                } else if (Global.equals((Object)this.getRelayState(), (Object)IceLocalRelayedCandidateState.Refreshing)) {
                    throw new RuntimeException(new Exception(StringExtensions.format("Inconsistent state {0} of the local relayed candidate when stop request received.", this.getRelayState().toString())));
                }
            } else {
                if (this.__transactionManager != null) {
                    this.__transactionManager.remove(this.__refreshItem, (Object)this);
                    this.__refreshScheduled = false;
                }
                if (deallocate) {
                    this.deallocate();
                } else {
                    this.setRelayState(IceLocalRelayedCandidateState.Closing);
                    this.setRelayState(IceLocalRelayedCandidateState.Closed);
                }
            }
        }
    }
}

