/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.BitAssistant;
import fm.icelink.DataBuffer;
import fm.icelink.DataBufferPooled;
import fm.icelink.Holder;
import fm.icelink.IFunction1;
import fm.icelink.IFunctionDelegate1;
import fm.icelink.ILog;
import fm.icelink.Log;
import fm.icelink.LogLevel;
import fm.icelink.ManagedConcurrentDictionary;
import fm.icelink.ManagedConcurrentStack;
import fm.icelink.PoolStatistics;

public class DataBufferPool {
    private ManagedConcurrentDictionary<Integer, ManagedConcurrentStack<byte[]>> __pools;
    private static DataBufferPool __singleton = null;
    private boolean _disabled;
    private boolean _enableStatistics;
    private ILog _log = Log.getLogger("DataBufferPool", LogLevel.Info);
    private PoolStatistics _statistics;

    private ManagedConcurrentStack<byte[]> createStack(int size) {
        if (this.getEnableStatistics()) {
            this.getStatistics().__creates.increment();
        }
        return new ManagedConcurrentStack<byte[]>();
    }

    public DataBufferPool() {
        this.__pools = new ManagedConcurrentDictionary();
        this.setEnableStatistics(false);
        this.setStatistics(new PoolStatistics());
    }

    public boolean getDisabled() {
        return this._disabled;
    }

    public boolean getEnableStatistics() {
        return this._enableStatistics;
    }

    public static DataBufferPool getInstance() {
        return __singleton;
    }

    public PoolStatistics getStatistics() {
        return this._statistics;
    }

    private static int padToBlock(int size) {
        int num = size + 128 - 1;
        return num - (num & 0x7F);
    }

    void returnBuffer(DataBufferPooled buffer) {
        if (!this.getDisabled()) {
            int num = buffer.decrementRetain();
            if (num == 0) {
                byte[] item = buffer.invalidate();
                ManagedConcurrentStack stack = null;
                Holder<Object> _var0 = new Holder<Object>(stack);
                boolean _var1 = this.__pools.tryGetValue(ArrayExtensions.getLength(item), _var0);
                stack = _var0.getValue();
                if (!_var1) {
                    throw new RuntimeException(new Exception("Cannot return a buffer to the pool that was not taken from the pool."));
                }
                stack.push(item);
                if (this.getEnableStatistics()) {
                    this.getStatistics().__pendingPoolSize.add(ArrayExtensions.getLength(item));
                }
            } else if (num < 0) {
                this._log.warn("Cannot return a buffer to the pool with a negative retain count.");
            }
        }
    }

    public void setDisabled(boolean value) {
        this._disabled = value;
    }

    public void setEnableStatistics(boolean value) {
        this._enableStatistics = value;
    }

    private void setStatistics(PoolStatistics value) {
        this._statistics = value;
    }

    public DataBuffer take(int size, boolean littleEndian) {
        return this.take(size, littleEndian, false);
    }

    public DataBuffer take(int size) {
        return this.take(size, false, false);
    }

    public DataBuffer take(int size, boolean littleEndian, boolean clearBytes) {
        if (this.getDisabled()) {
            return DataBuffer.allocate(size, littleEndian);
        }
        int key = DataBufferPool.padToBlock(size);
        ManagedConcurrentStack<byte[]> orAdd = this.__pools.getOrAdd(key, (IFunction1<Integer, ManagedConcurrentStack<byte[]>>)new IFunctionDelegate1<Integer, ManagedConcurrentStack<byte[]>>(){

            @Override
            public String getId() {
                return "fm.icelink.DataBufferPool.createStack";
            }

            @Override
            public ManagedConcurrentStack<byte[]> invoke(Integer size) {
                return DataBufferPool.this.createStack(size);
            }
        });
        if (this.getEnableStatistics()) {
            this.getStatistics().__paddingWasted.add(key - size);
        }
        byte[] result = null;
        Holder<Object> _var0 = new Holder<Object>(result);
        boolean _var1 = orAdd.tryPop(_var0);
        result = _var0.getValue();
        if (_var1) {
            if (clearBytes) {
                BitAssistant.set(result, 0, ArrayExtensions.getLength(result), 0);
            }
            if (this.getEnableStatistics()) {
                this.getStatistics().__hits.increment();
                this.getStatistics().__pendingPoolSize.subtract(ArrayExtensions.getLength(result));
            }
            return new DataBufferPooled(this, result, size, littleEndian);
        }
        if (this.getEnableStatistics()) {
            this.getStatistics().__misses.increment();
            this.getStatistics().__totalPoolSize.add(key);
        }
        return new DataBufferPooled(this, new byte[key], size, littleEndian);
    }

    static {
        __singleton = new DataBufferPool();
    }
}

