/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.MathAssistant;

public class Color {
    private int _b;
    private int _g;
    private int _r;

    public Color(int r, int g, int b) {
        this.setR(MathAssistant.max(0, MathAssistant.min(255, r)));
        this.setG(MathAssistant.max(0, MathAssistant.min(255, g)));
        this.setB(MathAssistant.max(0, MathAssistant.min(255, b)));
    }

    public static Color fromHsb(double hue, double saturation, double brightness) {
        hue = MathAssistant.max(0.0, MathAssistant.min(359.0, hue));
        saturation = MathAssistant.max(0.0, MathAssistant.min(1.0, saturation));
        brightness = MathAssistant.max(0.0, MathAssistant.min(1.0, brightness));
        if (saturation == 0.0) {
            int r = (int)(brightness * 255.0 + 0.5);
            return new Color(r, r, r);
        }
        double num2 = (hue - MathAssistant.floor(hue)) * 6.0;
        double num3 = num2 - MathAssistant.floor(num2);
        double num4 = brightness * (1.0 - saturation);
        double num5 = brightness * (1.0 - saturation * num3);
        double num6 = brightness * (1.0 - saturation * (1.0 - num3));
        int _var0 = (int)num2;
        if (_var0 == 0) {
            return new Color((int)(brightness * 255.0 + 0.5), (int)(num6 * 255.0 + 0.5), (int)(num4 * 255.0 + 0.5));
        }
        if (_var0 == 1) {
            return new Color((int)(num5 * 255.0 + 0.5), (int)(brightness * 255.0 + 0.5), (int)(num4 * 255.0 + 0.5));
        }
        if (_var0 == 2) {
            return new Color((int)(num4 * 255.0 + 0.5), (int)(brightness * 255.0 + 0.5), (int)(num6 * 255.0 + 0.5));
        }
        if (_var0 == 3) {
            return new Color((int)(num4 * 255.0 + 0.5), (int)(num5 * 255.0 + 0.5), (int)(brightness * 255.0 + 0.5));
        }
        if (_var0 == 4) {
            return new Color((int)(num6 * 255.0 + 0.5), (int)(num4 * 255.0 + 0.5), (int)(brightness * 255.0 + 0.5));
        }
        return new Color((int)(brightness * 255.0 + 0.5), (int)(num4 * 255.0 + 0.5), (int)(num5 * 255.0 + 0.5));
    }

    public int getB() {
        return this._b;
    }

    public static Color getBlack() {
        return new Color(0, 0, 0);
    }

    public static Color getBlue() {
        return new Color(0, 0, 255);
    }

    public static Color getCyan() {
        return new Color(0, 255, 255);
    }

    public static Color getDarkBlue() {
        return new Color(0, 0, 127);
    }

    public static Color getDarkGreen() {
        return new Color(0, 127, 0);
    }

    public static Color getDarkRed() {
        return new Color(127, 0, 0);
    }

    public int getG() {
        return this._g;
    }

    public static Color getGray() {
        return new Color(127, 127, 127);
    }

    public static Color getGreen() {
        return new Color(0, 255, 0);
    }

    public static Color getMagenta() {
        return new Color(255, 0, 255);
    }

    public static Color getOlive() {
        return new Color(127, 127, 0);
    }

    public static Color getPurple() {
        return new Color(127, 0, 127);
    }

    public int getR() {
        return this._r;
    }

    public static Color getRed() {
        return new Color(255, 0, 0);
    }

    public static Color getTeal() {
        return new Color(0, 127, 127);
    }

    public static Color getWhite() {
        return new Color(255, 255, 255);
    }

    public static Color getYellow() {
        return new Color(255, 255, 0);
    }

    private void setB(int value) {
        this._b = value;
    }

    private void setG(int value) {
        this._g = value;
    }

    private void setR(int value) {
        this._r = value;
    }
}

