/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.AecPipe;
import fm.icelink.AudioConfig;
import fm.icelink.AudioMixer;
import fm.icelink.AudioPipe;
import fm.icelink.AudioSink;
import fm.icelink.AudioTrack;

public abstract class AecContext {
    private boolean _destroyed = false;
    private Object _destroyLock = new Object();
    private AudioPipe _outputMixer;
    private AudioSink _outputMixerSink;
    private AudioTrack _outputTrack;
    private AecPipe _processor;

    public AecContext() {
        this.setProcessor(this.createProcessor());
        if (this.getProcessor() == null) {
            throw new RuntimeException(new Exception("AEC processor cannot be null."));
        }
        this.setOutputMixerSink(this.createOutputMixerSink(this.getProcessor().getConfig()));
        if (this.getOutputMixerSink() == null) {
            throw new RuntimeException(new Exception("AEC output mixer sink cannot be null."));
        }
        this.setOutputMixer(this.createOutputMixer(this.getProcessor().getConfig()));
        if (this.getOutputMixer() == null) {
            throw new RuntimeException(new Exception("AEC output mixer cannot be null."));
        }
        this.setOutputTrack((AudioTrack)new AudioTrack(this.getOutputMixer()).next(this.getOutputMixerSink()));
        this.getOutputTrack().setPersistent(true);
        this.getProcessor().setSpeaker(this.getOutputMixerSink());
    }

    protected AudioPipe createOutputMixer(AudioConfig config) {
        return new AudioMixer(config);
    }

    protected abstract AudioSink createOutputMixerSink(AudioConfig var1);

    protected abstract AecPipe createProcessor();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean destroy() {
        Object object = this._destroyLock;
        synchronized (object) {
            if (this._destroyed) {
                return false;
            }
            this._destroyed = true;
        }
        this.getProcessor().destroy();
        this.getOutputTrack().destroy();
        return true;
    }

    public AudioConfig getConfig() {
        return this.getProcessor().getConfig();
    }

    public AudioPipe getOutputMixer() {
        return this._outputMixer;
    }

    public AudioSink getOutputMixerSink() {
        return this._outputMixerSink;
    }

    AudioTrack getOutputTrack() {
        return this._outputTrack;
    }

    public AecPipe getProcessor() {
        return this._processor;
    }

    private void setOutputMixer(AudioPipe value) {
        this._outputMixer = value;
    }

    private void setOutputMixerSink(AudioSink value) {
        this._outputMixerSink = value;
    }

    private void setOutputTrack(AudioTrack value) {
        this._outputTrack = value;
    }

    private void setProcessor(AecPipe value) {
        this._processor = value;
    }
}

