/*
 * Decompiled with CFR 0.152.
 */
package fm;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum LogLevel {
    Debug(1),
    Info(2),
    Warn(3),
    Error(4),
    Fatal(5),
    None(6);

    private final int value;
    private static final Map<Integer, LogLevel> lookup;

    private LogLevel(int value) {
        this.value = value;
    }

    public int getAssignedValue() {
        return this.value;
    }

    public static LogLevel getByAssignedValue(int value) {
        return lookup.get(value);
    }

    static {
        lookup = new HashMap<Integer, LogLevel>();
        for (LogLevel s : EnumSet.allOf(LogLevel.class)) {
            lookup.put(s.getAssignedValue(), s);
        }
    }
}

