/*
 * Decompiled with CFR 0.152.
 */
package fm.websync;

import fm.HttpRequestArgs;
import fm.HttpRequestCreatedArgs;
import fm.HttpResponseArgs;
import fm.HttpResponseReceivedArgs;
import fm.SingleAction;
import fm.WebSocketOpenFailureArgs;
import fm.WebSocketOpenSuccessArgs;
import fm.WebSocketStreamFailureArgs;
import fm.WebSocketTransfer;
import fm.WebSocketTransferFactory;
import fm.websync.MessageRequestArgs;
import fm.websync.MessageResponseArgs;
import fm.websync.MessageTransfer;
import java.util.HashMap;

public class WebSocketMessageTransfer
extends MessageTransfer {
    private String _callbackKey = "fm.websync.webSocketMessageTransfer.callback";
    private String _url;
    private WebSocketTransfer _webSocketTransfer;

    public int getHandshakeTimeout() {
        return this._webSocketTransfer.getHandshakeTimeout();
    }

    public SingleAction<WebSocketOpenFailureArgs> getOnOpenFailure() {
        return this._webSocketTransfer.getOnOpenFailure();
    }

    public SingleAction<WebSocketOpenSuccessArgs> getOnOpenSuccess() {
        return this._webSocketTransfer.getOnOpenSuccess();
    }

    public SingleAction<HttpRequestCreatedArgs> getOnRequestCreated() {
        return this._webSocketTransfer.getOnRequestCreated();
    }

    public SingleAction<HttpResponseReceivedArgs> getOnResponseReceived() {
        return this._webSocketTransfer.getOnResponseReceived();
    }

    public SingleAction<WebSocketStreamFailureArgs> getOnStreamFailure() {
        return this._webSocketTransfer.getOnStreamFailure();
    }

    public Object getSender() {
        return this._webSocketTransfer.getSender();
    }

    public int getStreamTimeout() {
        return this._webSocketTransfer.getHandshakeTimeout();
    }

    public String getUrl() {
        return this._url;
    }

    public void open(HashMap<String, String> headers) throws Exception {
        this._webSocketTransfer.open(headers);
    }

    @Override
    public MessageResponseArgs sendMessages(MessageRequestArgs requestArgs) throws Exception {
        HttpRequestArgs args = super.messageRequestArgsToHttpRequestArgs(requestArgs);
        HttpResponseArgs httpResponseArgs = this._webSocketTransfer.send(args);
        return super.httpResponseArgsToMessageResponseArgs(httpResponseArgs);
    }

    @Override
    public void sendMessagesAsync(MessageRequestArgs requestArgs, SingleAction<MessageResponseArgs> callback) throws Exception {
        HttpRequestArgs args = super.messageRequestArgsToHttpRequestArgs(requestArgs);
        args.setDynamicValue(this._callbackKey, callback);
        final WebSocketMessageTransfer _var0 = this;
        this._webSocketTransfer.sendAsync(args, (SingleAction)new SingleAction<HttpResponseArgs>(){

            public void invoke(HttpResponseArgs httpResponseArgs) {
                try {
                    _var0.sendMessagesAsyncCallback(httpResponseArgs);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    private void sendMessagesAsyncCallback(HttpResponseArgs httpResponseArgs) throws Exception {
        SingleAction dynamicValue;
        HttpRequestArgs requestArgs;
        if (httpResponseArgs != null && (requestArgs = httpResponseArgs.getRequestArgs()) != null && (dynamicValue = (SingleAction)requestArgs.getDynamicValue(this._callbackKey)) != null) {
            requestArgs.unsetDynamicValue(this._callbackKey);
            dynamicValue.invoke((Object)super.httpResponseArgsToMessageResponseArgs(httpResponseArgs));
        }
    }

    public void setHandshakeTimeout(int value) {
        this._webSocketTransfer.setHandshakeTimeout(value);
    }

    public void setOnOpenFailure(SingleAction<WebSocketOpenFailureArgs> value) {
        this._webSocketTransfer.setOnOpenFailure(value);
    }

    public void setOnOpenSuccess(SingleAction<WebSocketOpenSuccessArgs> value) {
        this._webSocketTransfer.setOnOpenSuccess(value);
    }

    public void setOnRequestCreated(SingleAction<HttpRequestCreatedArgs> value) {
        this._webSocketTransfer.setOnRequestCreated(value);
    }

    public void setOnResponseReceived(SingleAction<HttpResponseReceivedArgs> value) {
        this._webSocketTransfer.setOnResponseReceived(value);
    }

    public void setOnStreamFailure(SingleAction<WebSocketStreamFailureArgs> value) {
        this._webSocketTransfer.setOnStreamFailure(value);
    }

    public void setSender(Object value) {
        this._webSocketTransfer.setSender(value);
    }

    public void setStreamTimeout(int value) {
        this._webSocketTransfer.setHandshakeTimeout(value);
    }

    public void setUrl(String value) {
        this._url = value;
    }

    @Override
    public void shutdown() {
        try {
            this._webSocketTransfer.shutdown();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public WebSocketMessageTransfer(String url) {
        this();
        this.setUrl(url);
        this._webSocketTransfer = WebSocketTransferFactory.getWebSocketTransfer((String)this.getUrl());
    }

    private WebSocketMessageTransfer() {
    }
}

