/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.matroska;

import fm.icelink.ArrayExtensions;
import fm.icelink.BitAssistant;
import fm.icelink.ByteOutputStream;
import fm.icelink.IntegerHolder;
import fm.icelink.Log;
import fm.icelink.StringExtensions;
import fm.icelink.matroska.Ebml;
import fm.icelink.matroska.Element;
import fm.icelink.matroska.Segment;

public class File {
    private Ebml _ebml;
    private Segment _segment;

    public File(byte[] bytes) {
        this();
        int offset = 0;
        while (offset < ArrayExtensions.getLength(bytes)) {
            IntegerHolder _var0 = new IntegerHolder(offset);
            byte[] _var1 = Element.readId(bytes, offset, _var0);
            offset = _var0.getValue();
            byte[] buffer = _var1;
            IntegerHolder _var2 = new IntegerHolder(offset);
            byte[] _var3 = Element.readValue(bytes, offset, _var2);
            offset = _var2.getValue();
            byte[] buffer2 = _var3;
            if (Element.compare(buffer, Ebml.getEbmlId())) {
                this.setEbml(new Ebml(buffer2));
                continue;
            }
            if (Element.compare(buffer, Segment.getEbmlId())) {
                this.setSegment(new Segment(buffer2));
                continue;
            }
            Log.warn(StringExtensions.concat("Unrecognized ID in MatroskaFile: ", BitAssistant.getHexString(buffer)));
        }
    }

    public File() {
    }

    public byte[] getBytes() {
        ByteOutputStream stream = new ByteOutputStream();
        if (this.getEbml() != null) {
            stream.writeBuffer(this.getEbml().getBytes());
        }
        if (this.getSegment() != null) {
            stream.writeBuffer(this.getSegment().getBytes());
        }
        return stream.toArray();
    }

    public Ebml getEbml() {
        return this._ebml;
    }

    public Segment getSegment() {
        return this._segment;
    }

    public void merge(File file) {
        if (file != null) {
            if (this.getEbml() == null) {
                this.setEbml(file.getEbml());
            } else {
                this.getEbml().merge(file.getEbml());
            }
            if (this.getSegment() == null) {
                this.setSegment(file.getSegment());
            } else {
                this.getSegment().merge(file.getSegment());
            }
        }
    }

    public void setEbml(Ebml value) {
        this._ebml = value;
    }

    public void setSegment(Segment value) {
        this._segment = value;
    }
}

