/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.h264;

import fm.icelink.Binary;
import fm.icelink.DataBuffer;
import fm.icelink.IntegerExtensions;
import fm.icelink.StringExtensions;
import fm.icelink.h264.NaluType;

public class Nalu {
    private static DataBuffer __startCode;
    private int _bottomFieldFlag;
    private DataBuffer _buffer;
    private int[] _deltaPicOrderCnt;
    private int _fieldPicFlag;
    private int _firstMbInSlice;
    private int _frameNum;
    private int _idrPicFlag;
    private int _idrPicId;
    private int _picOrderCntLsb;
    private int _picOrderCntType;
    private int _ppsId;
    private int _sliceType;
    private int _spsId;

    public static int findNalu(DataBuffer encodedData) {
        return Nalu.findNextNalu(encodedData, 0);
    }

    public static int findNextNalu(DataBuffer encodedData, int start) {
        boolean flag2;
        int offset = start;
        int num2 = encodedData.getLength() - 3;
        boolean flag = offset >= num2;
        boolean bl = flag2 = encodedData.read24(offset) == 1;
        while (!flag && !flag2) {
            flag = ++offset >= num2;
            flag2 = encodedData.read24(offset) == 1;
        }
        if (flag) {
            return -1;
        }
        return offset + 3;
    }

    protected int getBottomFieldFlag() {
        return this._bottomFieldFlag;
    }

    public DataBuffer getBuffer() {
        return this._buffer;
    }

    public DataBuffer getBytes() {
        return this.getBuffer();
    }

    protected int[] getDeltaPicOrderCnt() {
        return this._deltaPicOrderCnt;
    }

    public boolean getFBit() {
        return (this.getBuffer().read8(0) & Nalu.getFBitMask()) == 1;
    }

    public static int getFBitMask() {
        return 128;
    }

    protected int getFieldPicFlag() {
        return this._fieldPicFlag;
    }

    protected int getFirstMbInSlice() {
        return this._firstMbInSlice;
    }

    protected int getFrameNum() {
        return this._frameNum;
    }

    public int getHeader() {
        return this.getNalRefIdc() + this.getType();
    }

    protected int getIdrPicFlag() {
        return this._idrPicFlag;
    }

    protected int getIdrPicId() {
        return this._idrPicId;
    }

    public int getNalRefIdc() {
        return this.getBuffer().read8(0) & Nalu.getNriMask();
    }

    public static Nalu getNalu(DataBuffer encodedData, int nalStart) {
        if (nalStart > encodedData.getLength()) {
            return null;
        }
        int length = Nalu.findNextNalu(encodedData, nalStart);
        length = length < 0 ? encodedData.getLength() : (length -= Nalu.getStartCode().getLength());
        Nalu nalu = new Nalu(encodedData.subset(nalStart, length - nalStart));
        if (nalu.getFBit() || nalu.getType() == 0) {
            return Nalu.getNalu(encodedData, length + Nalu.getStartCode().getLength());
        }
        return nalu;
    }

    public static Nalu getNalu(DataBuffer encodedData) {
        return Nalu.getNalu(encodedData, 0);
    }

    private String getNaluKey() {
        return StringExtensions.concat(new String[]{IntegerExtensions.toString(this.getFrameNum()), ".", IntegerExtensions.toString(this.getPpsId()), ".", IntegerExtensions.toString(this.getFieldPicFlag()), ".", IntegerExtensions.toString(this.getBottomFieldFlag()), ".", IntegerExtensions.toString(this.getNalRefIdc()), ".", IntegerExtensions.toString(this.getPicOrderCntType()), ".", IntegerExtensions.toString(this.getIdrPicFlag())});
    }

    public static int getNriMask() {
        return 96;
    }

    public DataBuffer getPayload() {
        return this.getBuffer().subset(1);
    }

    protected int getPicOrderCntLsb() {
        return this._picOrderCntLsb;
    }

    protected int getPicOrderCntType() {
        return this._picOrderCntType;
    }

    protected int getPpsId() {
        return this._ppsId;
    }

    public DataBuffer getShortLength() {
        return DataBuffer.wrap(Binary.toBytes16(this.getBuffer().getLength(), false));
    }

    protected int getSliceType() {
        return this._sliceType;
    }

    protected int getSpsId() {
        return this._spsId;
    }

    public static DataBuffer getStartCode() {
        return __startCode;
    }

    public int getType() {
        return NaluType.getNaluType(this.getBuffer().read8(0));
    }

    public static int getTypeMask() {
        return 31;
    }

    public Nalu(DataBuffer naluBytes) {
        this.setBuffer(naluBytes);
    }

    public Nalu() {
    }

    private void setBottomFieldFlag(int value) {
        this._bottomFieldFlag = value;
    }

    private void setBuffer(DataBuffer value) {
        this._buffer = value;
    }

    private void setDeltaPicOrderCnt(int[] value) {
        this._deltaPicOrderCnt = value;
    }

    private void setFieldPicFlag(int value) {
        this._fieldPicFlag = value;
    }

    private void setFirstMbInSlice(int value) {
        this._firstMbInSlice = value;
    }

    private void setFrameNum(int value) {
        this._frameNum = value;
    }

    private void setIdrPicFlag(int value) {
        this._idrPicFlag = value;
    }

    private void setIdrPicId(int value) {
        this._idrPicId = value;
    }

    private void setPicOrderCntLsb(int value) {
        this._picOrderCntLsb = value;
    }

    private void setPicOrderCntType(int value) {
        this._picOrderCntType = value;
    }

    private void setPpsId(int value) {
        this._ppsId = value;
    }

    private void setSliceType(int value) {
        this._sliceType = value;
    }

    private void setSpsId(int value) {
        this._spsId = value;
    }

    static {
        byte[] data = new byte[4];
        data[3] = 1;
        __startCode = DataBuffer.wrap(data);
    }
}

