/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.ArrayListExtensions;
import fm.icelink.Holder;
import fm.icelink.IAction1;
import fm.icelink.IActionDelegate1;
import fm.icelink.IntegerHolder;
import fm.icelink.TransportAddress;
import fm.icelink.VirtualNatMapping;
import fm.icelink.VirtualNatMode;
import java.util.ArrayList;

class VirtualNat {
    private int __mappedPortIndex = 0;
    private int[] __mappedPorts;
    private ArrayList<VirtualNatMapping> __mappings = new ArrayList();
    private Object __mappingsLock = new Object();
    private VirtualNatMode _mode;
    private int _timeout;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean addForwarding(int port, String internalIPAddress) {
        Object object = this.__mappingsLock;
        synchronized (object) {
            if (!this.retainPort(port)) {
                return false;
            }
            VirtualNatMapping mapping2 = new VirtualNatMapping(0, null);
            mapping2.setInternalAddress(new TransportAddress(internalIPAddress, port));
            mapping2.setPort(port);
            mapping2.setIsForwarding(true);
            VirtualNatMapping item = mapping2;
            this.__mappings.add(item);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addMapping(IntegerHolder port, String internalIPAddress, int internalPort, String externalIPAddress, int externalPort) {
        TransportAddress internalAddress = new TransportAddress(internalIPAddress, internalPort);
        TransportAddress externalAddress = new TransportAddress(externalIPAddress, externalPort);
        Object object = this.__mappingsLock;
        synchronized (object) {
            boolean _var0 = this.reuseMapping(port, internalAddress, externalAddress);
            if (!_var0) {
                port.setValue(this.retainPort());
                VirtualNatMapping mapping2 = new VirtualNatMapping(this.getTimeout(), (IAction1<VirtualNatMapping>)new IActionDelegate1<VirtualNatMapping>(){

                    @Override
                    public String getId() {
                        return "fm.icelink.VirtualNat.removeMapping";
                    }

                    @Override
                    public void invoke(VirtualNatMapping mapping) {
                        VirtualNat.this.removeMapping(mapping);
                    }
                });
                mapping2.setInternalAddress(internalAddress);
                mapping2.setPort(port.getValue());
                VirtualNatMapping item = mapping2;
                item.addExternalPermission(externalAddress, this.getMode());
                this.__mappings.add(item);
            }
        }
    }

    public boolean getMapping(int port, Holder<String> internalIPAddress, IntegerHolder internalPort, String externalIPAddress, int externalPort) {
        TransportAddress externalAddress = new TransportAddress(externalIPAddress, externalPort);
        for (VirtualNatMapping mapping : this.getMappings()) {
            if (mapping.getPort() != port || !mapping.getIsForwarding() && !mapping.checkExternalPermission(externalAddress, this.getMode())) continue;
            internalIPAddress.setValue(mapping.getInternalAddress().getIPAddress());
            internalPort.setValue(mapping.getInternalAddress().getPort());
            return true;
        }
        internalIPAddress.setValue(null);
        internalPort.setValue(0);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VirtualNatMapping[] getMappings() {
        Object object = this.__mappingsLock;
        synchronized (object) {
            return this.__mappings.toArray(new VirtualNatMapping[0]);
        }
    }

    public VirtualNatMode getMode() {
        return this._mode;
    }

    public int getTimeout() {
        return this._timeout;
    }

    private void releasePort(int port) {
        this.__mappedPorts[port - 1024] = port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeForwarding(int port) {
        Object object = this.__mappingsLock;
        synchronized (object) {
            this.releasePort(port);
            VirtualNatMapping item = null;
            for (int i = 0; !(i >= ArrayListExtensions.getCount(this.__mappings) || (item = ArrayListExtensions.getItem(this.__mappings).get(i)).getIsForwarding() && item.getPort() == port); ++i) {
            }
            return item == null && this.__mappings.remove(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeMapping(VirtualNatMapping mapping) {
        Object object = this.__mappingsLock;
        synchronized (object) {
            this.__mappings.remove(mapping);
        }
    }

    private boolean retainPort(int port) {
        if (this.__mappedPorts[port - 1024] == 0) {
            return false;
        }
        this.__mappedPorts[port - 1024] = 0;
        return true;
    }

    private int retainPort() {
        int num2;
        int num;
        for (num = this.__mappedPortIndex; num < ArrayExtensions.getLength(this.__mappedPorts); ++num) {
            num2 = this.__mappedPorts[num];
            if (num2 <= 0) continue;
            this.__mappedPorts[num] = 0;
            this.__mappedPortIndex = num;
            return num2;
        }
        for (num = 0; num < this.__mappedPortIndex; ++num) {
            num2 = this.__mappedPorts[num];
            if (num2 <= 0) continue;
            this.__mappedPorts[num] = 0;
            this.__mappedPortIndex = num;
            return num2;
        }
        throw new RuntimeException(new Exception("All ports in use!"));
    }

    private boolean reuseMapping(IntegerHolder port, TransportAddress internalAddress, TransportAddress externalAddress) {
        for (VirtualNatMapping mapping : this.__mappings) {
            if (!mapping.tryReuse(internalAddress, externalAddress, this.getMode())) continue;
            port.setValue(mapping.getPort());
            return true;
        }
        port.setValue(0);
        return false;
    }

    private void setMode(VirtualNatMode value) {
        this._mode = value;
    }

    public void setTimeout(int value) {
        this._timeout = value;
    }

    public VirtualNat(VirtualNatMode mode) {
        this.__mappedPorts = new int[64512];
        this.setMode(mode);
        this.setTimeout(60000);
        for (int i = 1024; i < 65536; ++i) {
            this.__mappedPorts[i - 1024] = i;
        }
    }
}

