/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.AtomicLong;
import fm.icelink.IVideoOutput;
import fm.icelink.MediaTrackStats;
import fm.icelink.VideoFormat;
import fm.icelink.VideoFrame;
import fm.icelink.VideoPipe;

public abstract class VideoPacketizer
extends VideoPipe {
    private AtomicLong __framesSent = new AtomicLong();

    private static VideoFormat cloneFormat(VideoFormat format, boolean isPacketized) {
        VideoFormat format2 = format.clone();
        format2.setIsPacketized(isPacketized);
        return format2;
    }

    @Override
    protected void doProcessStatsFromOutput(MediaTrackStats stats) {
        super.doProcessStatsFromOutput(stats);
        stats.setFramesSent(this.getFramesSent());
    }

    public long getFramesSent() {
        return this.__framesSent.getValue();
    }

    @Override
    public boolean processFrame(VideoFrame frame) {
        this.__framesSent.increment();
        return super.processFrame(frame);
    }

    public VideoPacketizer(IVideoOutput input) {
        this((VideoFormat)input.getOutputFormat());
        super.addInput(input);
    }

    public VideoPacketizer(VideoFormat format) {
        this(format, format);
    }

    public VideoPacketizer(VideoFormat inputFormat, VideoFormat outputFormat) {
        super(inputFormat == null ? inputFormat : VideoPacketizer.cloneFormat(inputFormat, false), outputFormat == null ? null : VideoPacketizer.cloneFormat(outputFormat, true));
    }
}

