/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.AddressType;
import fm.icelink.ArrayListExtensions;
import fm.icelink.Base64;
import fm.icelink.BitAssistant;
import fm.icelink.BooleanHolder;
import fm.icelink.DataBuffer;
import fm.icelink.DataBufferPool;
import fm.icelink.DatagramSocket;
import fm.icelink.DatagramSocketCreateArgs;
import fm.icelink.Global;
import fm.icelink.Guid;
import fm.icelink.HashMapExtensions;
import fm.icelink.Holder;
import fm.icelink.IAction1;
import fm.icelink.IAction3;
import fm.icelink.IActionDelegate1;
import fm.icelink.IActionDelegate3;
import fm.icelink.IFunction1;
import fm.icelink.IntegerExtensions;
import fm.icelink.IntegerHolder;
import fm.icelink.License;
import fm.icelink.LocalNetwork;
import fm.icelink.LockedRandomizer;
import fm.icelink.Log;
import fm.icelink.LongExtensions;
import fm.icelink.MathAssistant;
import fm.icelink.ProtocolType;
import fm.icelink.ServerAddress;
import fm.icelink.StreamSocket;
import fm.icelink.StreamSocketCreateArgs;
import fm.icelink.StringExtensions;
import fm.icelink.StunServer;
import fm.icelink.TcpSocket;
import fm.icelink.TimeoutTimer;
import fm.icelink.TransportAddress;
import fm.icelink.TurnAllocation;
import fm.icelink.TurnAuthArgs;
import fm.icelink.TurnAuthOperation;
import fm.icelink.TurnAuthResult;
import fm.icelink.TurnUdpAllocation;
import fm.icelink.UdpSocket;
import fm.icelink.stun.Attribute;
import fm.icelink.stun.BadRequestError;
import fm.icelink.stun.Error;
import fm.icelink.stun.FingerprintAttribute;
import fm.icelink.stun.MappedAddressAttribute;
import fm.icelink.stun.Message;
import fm.icelink.stun.MessageIntegrityAttribute;
import fm.icelink.stun.NonceAttribute;
import fm.icelink.stun.RealmAttribute;
import fm.icelink.stun.ServerError;
import fm.icelink.stun.StaleNonceError;
import fm.icelink.stun.TransactionTransmitCounterAttribute;
import fm.icelink.stun.UnauthorizedStunError;
import fm.icelink.stun.UsernameAttribute;
import fm.icelink.stun.Utility;
import fm.icelink.stun.XorMappedAddressAttribute;
import fm.icelink.stun.turn.AllocateRequest;
import fm.icelink.stun.turn.AllocateResponse;
import fm.icelink.stun.turn.AllocationMismatchError;
import fm.icelink.stun.turn.ChannelBindRequest;
import fm.icelink.stun.turn.ChannelBindResponse;
import fm.icelink.stun.turn.ChannelNumberAttribute;
import fm.icelink.stun.turn.CreatePermissionRequest;
import fm.icelink.stun.turn.CreatePermissionResponse;
import fm.icelink.stun.turn.DataAttribute;
import fm.icelink.stun.turn.DataIndication;
import fm.icelink.stun.turn.EvenPortAttribute;
import fm.icelink.stun.turn.LifetimeAttribute;
import fm.icelink.stun.turn.RefreshRequest;
import fm.icelink.stun.turn.RefreshResponse;
import fm.icelink.stun.turn.RequestedTransportAttribute;
import fm.icelink.stun.turn.ReservationTokenAttribute;
import fm.icelink.stun.turn.SendIndication;
import fm.icelink.stun.turn.UnsupportedTransportProtocolError;
import fm.icelink.stun.turn.WrongCredentialsError;
import fm.icelink.stun.turn.XorPeerAddressAttribute;
import fm.icelink.stun.turn.XorRelayedAddressAttribute;
import java.util.ArrayList;
import java.util.HashMap;

public class TurnServer
extends StunServer {
    private int __allocationPortMax = 65535;
    private int __allocationPortMin = 49152;
    private long __defaultAllocateLifetime = 600L;
    private long __defaultRefreshLifetime = 600L;
    private long __maxAllocateLifetime = 3600L;
    private long __maxRefreshLifetime = 3600L;
    private HashMap<String, TurnAllocation> _allocationsByClientAddress;
    private HashMap<Integer, TurnAllocation> _allocationsByLocalPort;
    private Object _allocationsLock;
    private IFunction1<TurnAuthArgs, TurnAuthResult> _authCallback = null;
    private boolean _disableBypass;
    private boolean _forceDefaultAllocateLifetime;
    private boolean _forceDefaultRefreshLifetime;
    private int _nextTcpPort = 0;
    private static Object _nextTcpPortLock;
    private int _nextUdpPort = 0;
    private static Object _nextUdpPortLock;
    private String _nonce;
    private TimeoutTimer _nonceTimer;
    private String _realm;
    private byte _requestBitmask = BitAssistant.castByte(192);
    private HashMap<String, DatagramSocket> _reservations;
    private Object _reservationsLock;
    private boolean _staleNonceSecurity;

    private void allocateTcpSocket(ServerAddress localAddress, TransportAddress remoteAddress, Holder<StreamSocket> socket) {
        boolean _var0;
        while (!(_var0 = this.tryAllocateTcpSocket(localAddress, remoteAddress, socket))) {
        }
    }

    private void allocateUdpSocket(ServerAddress localAddress, EvenPortAttribute evenPort, TransportAddress remoteAddress, Holder<DatagramSocket> socket, Holder<DataBuffer> reservation) {
        boolean _var0;
        while (!(_var0 = this.tryAllocateUdpSocket(localAddress, evenPort, remoteAddress, socket, reservation))) {
        }
    }

    Error authenticate(Message request, TransportAddress remoteAddress, TurnAuthOperation operation, Holder<byte[]> longTermKeyBytes) {
        boolean missingCredentials = false;
        BooleanHolder _var0 = new BooleanHolder(missingCredentials);
        boolean _var1 = this.tryAuthenticate(request, operation, _var0, longTermKeyBytes);
        missingCredentials = _var0.getValue();
        if (!_var1) {
            if (!missingCredentials && Log.getIsWarnEnabled()) {
                Log.warn(StringExtensions.format("Could not process {0} request for {1} - authentication failed.", this.getOperationName(operation), remoteAddress.toString()));
            }
            return new UnauthorizedStunError();
        }
        return null;
    }

    private boolean authorize(TurnAllocation allocation, Message request) {
        UsernameAttribute username = request.getUsername();
        RealmAttribute realm = request.getRealm();
        MessageIntegrityAttribute messageIntegrity = request.getMessageIntegrity();
        if (username == null || realm == null || messageIntegrity == null) {
            return false;
        }
        return Global.equals(allocation.getUsername(), username.getValue()) && Global.equals(allocation.getRealm(), realm.getValue());
    }

    Error checkNonce(Message request, TransportAddress remoteAddress, TurnAuthOperation operation) {
        boolean missingNonce = false;
        BooleanHolder _var0 = new BooleanHolder(missingNonce);
        boolean _var1 = this.checkNonce(request, _var0);
        missingNonce = _var0.getValue();
        if (!_var1) {
            if (missingNonce) {
                if (Log.getIsDebugEnabled()) {
                    Log.debug(StringExtensions.format("Could not process {0} request for {1} - missing nonce.", this.getOperationName(operation), remoteAddress.toString()));
                }
                return new UnauthorizedStunError();
            }
            if (Log.getIsDebugEnabled()) {
                Log.debug(StringExtensions.format("Could not process {0} request for {1} - stale nonce.", this.getOperationName(operation), remoteAddress.toString()));
            }
            return new StaleNonceError();
        }
        return null;
    }

    boolean checkNonce(Message request, BooleanHolder missingNonce) {
        if (!this.getStaleNonceSecurity()) {
            missingNonce.setValue(false);
            return true;
        }
        NonceAttribute nonce = request.getNonce();
        if (nonce == null) {
            missingNonce.setValue(true);
            return false;
        }
        missingNonce.setValue(false);
        return Global.equals(nonce.getValue(), this.getNonce());
    }

    private AllocateResponse createAllocateResponse(AllocateRequest request, TurnAllocation allocation, TransportAddress remoteAddress) {
        AllocateResponse response = new AllocateResponse(request.getTransactionId(), true);
        String ipAddress = allocation.getPublicIPAddress() != null ? allocation.getPublicIPAddress() : allocation.getLocalIPAddress();
        int localPort = allocation.getLocalPort();
        response.setXorRelayedAddress(new XorRelayedAddressAttribute(ipAddress, localPort, request.getTransactionId()));
        response.setLifetime(new LifetimeAttribute(allocation.getLastLifetime()));
        if (allocation.getReservation() != null) {
            response.setReservationToken(new ReservationTokenAttribute(allocation.getReservation()));
        }
        response.setXorMappedAddress(new XorMappedAddressAttribute(remoteAddress.getIPAddress(), remoteAddress.getPort(), request.getTransactionId()));
        response.setMappedAddress(new MappedAddressAttribute(remoteAddress.getIPAddress(), remoteAddress.getPort()));
        return response;
    }

    @Override
    protected Message createExceptionResponse(Message request, TransportAddress remoteAddress, Error error) {
        Message message = super.createExceptionResponse(request, remoteAddress, error);
        int _var0 = error.getStunErrorCode();
        if (_var0 == 401 || _var0 == 438) {
            if (this.getNonce() != null) {
                message.setNonce(new NonceAttribute(this.getNonce()));
            }
            if (this.getRealm() != null) {
                message.setRealm(new RealmAttribute(this.getRealm()));
            }
        }
        return message;
    }

    private void createTcpSocket(ServerAddress address, Holder<StreamSocket> socket) {
        boolean server = true;
        boolean flag2 = Global.equals((Object)LocalNetwork.getAddressType(address.getIPAddress()), (Object)AddressType.IPv6);
        boolean secure = false;
        socket.setValue(null);
        if (super.getCreateStreamSocket() != null) {
            socket.setValue(super.getCreateStreamSocket().invoke(new StreamSocketCreateArgs(server, flag2, secure)));
        }
        if (socket.getValue() == null) {
            socket.setValue(new TcpSocket(server, flag2, secure));
        }
        socket.getValue().setPublicIPAddress(address.getPublicIPAddress());
        boolean addressInUse = false;
        BooleanHolder _var0 = new BooleanHolder(addressInUse);
        boolean _var1 = socket.getValue().bind(address.getIPAddress(), address.getPort(), _var0);
        addressInUse = _var0.getValue();
        if (!_var1) {
            try {
                socket.getValue().close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            socket.setValue(null);
            if (addressInUse) {
                Log.warn("Could not bind TCP allocation socket. Socket address is in use.");
            } else {
                Log.warn("Could not bind TCP allocation socket.");
            }
        }
    }

    private void createUdpSocket(ServerAddress address, Holder<DatagramSocket> socket) {
        boolean flag = Global.equals((Object)LocalNetwork.getAddressType(address.getIPAddress()), (Object)AddressType.IPv6);
        socket.setValue(null);
        if (super.getCreateDatagramSocket() != null) {
            socket.setValue(super.getCreateDatagramSocket().invoke(new DatagramSocketCreateArgs(flag)));
        }
        if (socket.getValue() == null) {
            socket.setValue(new UdpSocket(flag));
        }
        socket.getValue().setPublicIPAddress(address.getPublicIPAddress());
        boolean addressInUse = false;
        BooleanHolder _var0 = new BooleanHolder(addressInUse);
        boolean _var1 = socket.getValue().bind(address.getIPAddress(), address.getPort(), _var0);
        addressInUse = _var0.getValue();
        if (!_var1) {
            try {
                socket.getValue().close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            socket.setValue(null);
            if (addressInUse) {
                Log.warn("Could not bind UDP allocation socket. Socket address is in use.");
            } else {
                Log.warn("Could not bind UDP allocation socket.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expireReservedUdpSocket(Object state) {
        String key = (String)state;
        DatagramSocket socket = null;
        Object object = this._reservationsLock;
        synchronized (object) {
            Holder<Object> _var0 = new Holder<Object>(socket);
            boolean _var1 = HashMapExtensions.tryGetValue(this._reservations, key, _var0);
            socket = _var0.getValue();
            if (_var1) {
                HashMapExtensions.remove(this._reservations, key);
            }
        }
        if (socket != null) {
            try {
                socket.close();
            }
            catch (Exception exception) {
            }
            finally {
                if (Log.getIsWarnEnabled()) {
                    Log.warn(StringExtensions.format("UDP socket reservation {0} has expired and been removed.", key));
                }
            }
        }
    }

    private String generateNonce() {
        return Base64.encode(Guid.newGuid().toByteArray());
    }

    private String generateRealm() {
        return StringExtensions.substring(Base64.encode(Guid.newGuid().toByteArray()), 0, 16);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAllocationCount() {
        Object object = this._allocationsLock;
        synchronized (object) {
            return HashMapExtensions.getCount(this._allocationsByClientAddress);
        }
    }

    public int getAllocationPortMax() {
        return this.__allocationPortMax;
    }

    public int getAllocationPortMin() {
        return this.__allocationPortMin;
    }

    public long getDefaultAllocateLifetime() {
        return this.__defaultAllocateLifetime;
    }

    public long getDefaultRefreshLifetime() {
        return this.__defaultRefreshLifetime;
    }

    public boolean getDisableBypass() {
        return this._disableBypass;
    }

    public boolean getForceDefaultAllocateLifetime() {
        return this._forceDefaultAllocateLifetime;
    }

    public boolean getForceDefaultRefreshLifetime() {
        return this._forceDefaultRefreshLifetime;
    }

    @Override
    protected String getLabel() {
        return "TURN";
    }

    public long getMaxAllocateLifetime() {
        return this.__maxAllocateLifetime;
    }

    public long getMaxRefreshLifetime() {
        return this.__maxRefreshLifetime;
    }

    public long getMinAllocateLifetime() {
        return 600L;
    }

    public long getMinRefreshLifetime() {
        return 600L;
    }

    public String getNonce() {
        return this._nonce;
    }

    private String getOperationName(TurnAuthOperation operation) {
        TurnAuthOperation _var0 = operation;
        if (_var0 == TurnAuthOperation.Allocate) {
            return "Allocate";
        }
        if (_var0 == TurnAuthOperation.CreatePermission) {
            return "Create-Permission";
        }
        if (_var0 == TurnAuthOperation.Refresh) {
            return "Refresh";
        }
        return "Unknown";
    }

    public String getRealm() {
        return this._realm;
    }

    public boolean getStaleNonceSecurity() {
        return this._staleNonceSecurity;
    }

    private void nonceTimerCallback(Object state) {
        this.processNonce();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onAllocationExpired(TransportAddress remoteAddress) {
        Object object = this._allocationsLock;
        synchronized (object) {
            TurnAllocation allocation = null;
            Holder<Object> _var0 = new Holder<Object>(allocation);
            boolean _var1 = HashMapExtensions.tryGetValue(this._allocationsByClientAddress, remoteAddress.toString(), _var0);
            allocation = _var0.getValue();
            if (_var1) {
                this.removeAllocation(allocation);
                if (Log.getIsDebugEnabled()) {
                    Log.debug(StringExtensions.format("Socket allocation for {0} has expired and been removed.", remoteAddress.toString()));
                }
            }
        }
    }

    private void onPacketDataReceived(TurnUdpAllocation allocation, TransportAddress remoteAddress, DataBuffer buffer) {
        DatagramSocket udpServerSocket = allocation.getUdpServerSocket();
        StreamSocket tcpServerSocket = allocation.getTcpServerSocket();
        int num = allocation.hasChannelBindingAddress(remoteAddress);
        if (num != 0) {
            int num3;
            int size = 4 + buffer.getLength();
            if (tcpServerSocket != null && (num3 = size % 4) > 0) {
                size += 4 - num3;
            }
            DataBuffer buffer2 = DataBufferPool.getInstance().take(size, false);
            buffer2.write16(num, 0);
            buffer2.write16(buffer.getLength(), 2);
            buffer2.write(buffer, 4);
            if (udpServerSocket != null) {
                udpServerSocket.send(buffer2, allocation.getClientAddress().getIPAddress(), allocation.getClientAddress().getPort());
            } else if (tcpServerSocket != null) {
                tcpServerSocket.sendAsync(buffer2, super.getStreamSendTimeout(), null, null);
            }
            buffer2.free();
        } else if (allocation.hasPermission(remoteAddress.getIPAddress())) {
            DataIndication indication = new DataIndication();
            indication.setXorPeerAddress(new XorPeerAddressAttribute(remoteAddress.getIPAddress(), remoteAddress.getPort(), indication.getTransactionId()));
            indication.setData(new DataAttribute(buffer));
            int length = indication.getLength();
            DataBuffer buffer3 = DataBufferPool.getInstance().take(length);
            indication.writeTo(buffer3, 0);
            if (udpServerSocket != null) {
                udpServerSocket.send(buffer3, allocation.getClientAddress().getIPAddress(), allocation.getClientAddress().getPort());
            } else if (tcpServerSocket != null) {
                tcpServerSocket.sendAsync(buffer3, super.getStreamSendTimeout(), null, null);
            }
            buffer3.free();
        }
    }

    private void onUdpDataReceived(TurnUdpAllocation allocation, TransportAddress remoteAddress, DataBuffer buffer) {
        this.onPacketDataReceived(allocation, remoteAddress, buffer);
    }

    @Override
    protected Message process(Message request, DatagramSocket udpServerSocket, StreamSocket tcpServerSocket, ServerAddress localAddress, TransportAddress remoteAddress) {
        TransactionTransmitCounterAttribute transactionTransmitCounter;
        String str = tcpServerSocket == null ? "[UDP] " : "[TCP] ";
        String str2 = StringExtensions.empty;
        Message message = null;
        try {
            byte[] longTermKeyBytes = null;
            if (request instanceof SendIndication) {
                this.processSendIndication((SendIndication)request, remoteAddress);
            } else if (request instanceof AllocateRequest) {
                if (Log.getIsDebugEnabled()) {
                    Log.debug(StringExtensions.format("{0}Processing UDP allocate request from {1}{2}.", str, remoteAddress.toString(), str2));
                }
                Holder<Object> _var0 = new Holder<Object>(longTermKeyBytes);
                Message _var1 = this.processAllocateRequest((AllocateRequest)request, ProtocolType.Udp, udpServerSocket, tcpServerSocket, localAddress, remoteAddress, _var0);
                longTermKeyBytes = _var0.getValue();
                message = _var1;
                if (Log.getIsDebugEnabled()) {
                    Log.debug(StringExtensions.format("{0}Processed UDP allocate request from {1}{2}.", str, remoteAddress.toString(), str2));
                }
            } else if (request instanceof RefreshRequest) {
                if (Log.getIsDebugEnabled()) {
                    Log.debug(StringExtensions.format("{0}Processing UDP refresh request from {1}{2}.", str, remoteAddress.toString(), str2));
                }
                Holder<Object> _var2 = new Holder<Object>(longTermKeyBytes);
                Message _var3 = this.processRefreshRequest((RefreshRequest)request, remoteAddress, _var2);
                longTermKeyBytes = _var2.getValue();
                message = _var3;
                if (Log.getIsDebugEnabled()) {
                    Log.debug(StringExtensions.format("{0}Processed UDP refresh request from {1}{2}.", str, remoteAddress.toString(), str2));
                }
            } else if (request instanceof CreatePermissionRequest) {
                if (Log.getIsDebugEnabled()) {
                    Log.debug(StringExtensions.format("{0}Processing UDP create-permission request from {1}{2}.", str, remoteAddress.toString(), str2));
                }
                Holder<Object> _var4 = new Holder<Object>(longTermKeyBytes);
                Message _var5 = this.processCreatePermissionRequest((CreatePermissionRequest)request, remoteAddress, _var4);
                longTermKeyBytes = _var4.getValue();
                message = _var5;
                if (Log.getIsDebugEnabled()) {
                    Log.debug(StringExtensions.format("{0}Processed UDP create-permission request from {1}{2}.", str, remoteAddress.toString(), str2));
                }
            } else if (request instanceof ChannelBindRequest) {
                if (Log.getIsDebugEnabled()) {
                    Log.debug(StringExtensions.format("{0}Processing UDP channel-bind request from {1}{2}.", str, remoteAddress.toString(), str2));
                }
                Holder<Object> _var6 = new Holder<Object>(longTermKeyBytes);
                Message _var7 = this.processChannelBindRequest((ChannelBindRequest)request, remoteAddress, _var6);
                longTermKeyBytes = _var6.getValue();
                message = _var7;
                if (Log.getIsDebugEnabled()) {
                    Log.debug(StringExtensions.format("{0}Processed UDP channel-bind request from {1}{2}.", str, remoteAddress.toString(), str2));
                }
            } else {
                message = super.process(request, udpServerSocket, tcpServerSocket, localAddress, remoteAddress);
            }
            if (longTermKeyBytes != null) {
                message.setMessageIntegrity(new MessageIntegrityAttribute(longTermKeyBytes));
                message.setFingerprint(new FingerprintAttribute());
            }
        }
        catch (Exception exception) {
            message = this.createExceptionResponse(request, remoteAddress, new ServerError(exception.getMessage()));
        }
        if (message != null && (transactionTransmitCounter = request.getTransactionTransmitCounter()) != null) {
            message.setTransactionTransmitCounter(transactionTransmitCounter);
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message processAllocateRequest(AllocateRequest request, ProtocolType protocolType, DatagramSocket udpServerSocket, StreamSocket tcpServerSocket, ServerAddress localAddress, TransportAddress remoteAddress, Holder<byte[]> longTermKeyBytes, Holder<TurnAllocation> allocation) {
        Error error = null;
        longTermKeyBytes.setValue(null);
        allocation.setValue(null);
        error = this.checkNonce(request, remoteAddress, TurnAuthOperation.Allocate);
        if (error != null) {
            return this.createExceptionResponse(request, remoteAddress, error);
        }
        Error _var0 = this.authenticate(request, remoteAddress, TurnAuthOperation.Allocate, longTermKeyBytes);
        error = _var0;
        if (error != null) {
            return this.createExceptionResponse(request, remoteAddress, error);
        }
        RequestedTransportAttribute requestedTransport = request.getRequestedTransport();
        ReservationTokenAttribute reservationToken = request.getReservationToken();
        EvenPortAttribute evenPort = request.getEvenPort();
        LifetimeAttribute lifetime = request.getLifetime();
        UsernameAttribute username = request.getUsername();
        RealmAttribute realm = request.getRealm();
        request.getMessageIntegrity();
        Object object = this._allocationsLock;
        synchronized (object) {
            TurnUdpAllocation allocation3;
            TurnAllocation allocation2 = null;
            Holder<Object> _var1 = new Holder<Object>(allocation2);
            boolean _var2 = this.tryGetAllocationByClientAddress(remoteAddress, _var1);
            allocation2 = _var1.getValue();
            if (_var2) {
                if (!allocation2.getTransactionId().sequenceEquals(request.getTransactionId())) {
                    String str = StringExtensions.format("Could not process allocate request for {0} - allocation already exists (mismatch).", remoteAddress.toString());
                    if (Log.getIsErrorEnabled()) {
                        Log.error(str);
                    }
                    error = new AllocationMismatchError(str);
                    return this.createExceptionResponse(request, remoteAddress, error);
                }
                int localPort = allocation2.getLocalPort();
                if (Log.getIsDebugEnabled()) {
                    Log.debug(StringExtensions.format("Socket already allocated on port {0} for {1}.", IntegerExtensions.toString(localPort), remoteAddress.toString()));
                }
                allocation.setValue(allocation2);
                return this.createAllocateResponse(request, allocation2, remoteAddress);
            }
            if (requestedTransport == null) {
                if (Log.getIsErrorEnabled()) {
                    Log.error(StringExtensions.format("Could not process allocate request for {0} - no requested transport.", remoteAddress.toString()));
                }
                return this.createExceptionResponse(request, remoteAddress, new BadRequestError());
            }
            if (requestedTransport.getProtocol() != RequestedTransportAttribute.getUdpProtocol()) {
                String str = StringExtensions.format("Could not process allocate request for {0} - requested transport protocol is not UDP.", remoteAddress.toString());
                if (Log.getIsErrorEnabled()) {
                    Log.error(str);
                }
                return this.createExceptionResponse(request, remoteAddress, new UnsupportedTransportProtocolError(str));
            }
            if (reservationToken != null && evenPort != null) {
                if (Log.getIsErrorEnabled()) {
                    Log.error(StringExtensions.format("Could not process allocate request for {0} - reservation token cannot be sent with even-port attribute.", remoteAddress.toString()));
                }
                return this.createExceptionResponse(request, remoteAddress, new BadRequestError());
            }
            long defaultAllocateLifetime = this.getDefaultAllocateLifetime();
            if (lifetime != null && !this.getForceDefaultAllocateLifetime()) {
                defaultAllocateLifetime = MathAssistant.min(this.getMaxAllocateLifetime(), MathAssistant.max(this.getMinAllocateLifetime(), lifetime.getLifetime()));
            }
            DatagramSocket socket = null;
            if (reservationToken != null) {
                String key = Base64.encodeBuffer(reservationToken.getToken());
                Object object2 = this._reservationsLock;
                synchronized (object2) {
                    Holder<Object> _var3 = new Holder<Object>(socket);
                    boolean _var4 = HashMapExtensions.tryGetValue(this._reservations, key, _var3);
                    socket = _var3.getValue();
                    if (_var4) {
                        HashMapExtensions.remove(this._reservations, key);
                    }
                }
            }
            DataBuffer reservation = null;
            if (socket == null) {
                Holder<Object> _var5 = new Holder<Object>(socket);
                Holder<Object> _var6 = new Holder<Object>(reservation);
                this.allocateUdpSocket(localAddress, evenPort, remoteAddress, _var5, _var6);
                socket = _var5.getValue();
                reservation = _var6.getValue();
            }
            if (Global.equals((Object)protocolType, (Object)ProtocolType.Tcp)) {
                allocation3 = new TurnUdpAllocation(udpServerSocket, tcpServerSocket, request.getTransactionId(), reservation, socket, remoteAddress, username.getValue(), realm.getValue(), defaultAllocateLifetime, (IAction3<TurnUdpAllocation, TransportAddress, DataBuffer>)new IActionDelegate3<TurnUdpAllocation, TransportAddress, DataBuffer>(){

                    @Override
                    public String getId() {
                        return "fm.icelink.TurnServer.onUdpDataReceived";
                    }

                    @Override
                    public void invoke(TurnUdpAllocation allocation, TransportAddress remoteAddress, DataBuffer buffer) {
                        TurnServer.this.onUdpDataReceived(allocation, remoteAddress, buffer);
                    }
                }, (IAction1<TransportAddress>)new IActionDelegate1<TransportAddress>(){

                    @Override
                    public String getId() {
                        return "fm.icelink.TurnServer.onAllocationExpired";
                    }

                    @Override
                    public void invoke(TransportAddress remoteAddress) {
                        TurnServer.this.onAllocationExpired(remoteAddress);
                    }
                });
                allocation.setValue(allocation3);
            } else {
                allocation3 = new TurnUdpAllocation(udpServerSocket, tcpServerSocket, request.getTransactionId(), reservation, socket, remoteAddress, username.getValue(), realm.getValue(), defaultAllocateLifetime, (IAction3<TurnUdpAllocation, TransportAddress, DataBuffer>)new IActionDelegate3<TurnUdpAllocation, TransportAddress, DataBuffer>(){

                    @Override
                    public String getId() {
                        return "fm.icelink.TurnServer.onUdpDataReceived";
                    }

                    @Override
                    public void invoke(TurnUdpAllocation allocation, TransportAddress remoteAddress, DataBuffer buffer) {
                        TurnServer.this.onUdpDataReceived(allocation, remoteAddress, buffer);
                    }
                }, (IAction1<TransportAddress>)new IActionDelegate1<TransportAddress>(){

                    @Override
                    public String getId() {
                        return "fm.icelink.TurnServer.onAllocationExpired";
                    }

                    @Override
                    public void invoke(TransportAddress remoteAddress) {
                        TurnServer.this.onAllocationExpired(remoteAddress);
                    }
                });
                allocation.setValue(allocation3);
            }
            HashMapExtensions.set(HashMapExtensions.getItem(this._allocationsByClientAddress), remoteAddress.toString(), allocation.getValue());
            HashMapExtensions.set(HashMapExtensions.getItem(this._allocationsByLocalPort), allocation.getValue().getLocalPort(), allocation.getValue());
            allocation3.startReceiving();
            return this.createAllocateResponse(request, allocation.getValue(), remoteAddress);
        }
    }

    private Message processAllocateRequest(AllocateRequest request, ProtocolType protocolType, DatagramSocket udpServerSocket, StreamSocket tcpServerSocket, ServerAddress localAddress, TransportAddress remoteAddress, Holder<byte[]> longTermKeyBytes) {
        TurnAllocation allocation = null;
        Holder<Object> _var0 = new Holder<Object>(allocation);
        Message _var1 = this.processAllocateRequest(request, protocolType, udpServerSocket, tcpServerSocket, localAddress, remoteAddress, longTermKeyBytes, _var0);
        allocation = _var0.getValue();
        return _var1;
    }

    @Override
    protected boolean processBuffer(DataBuffer buffer, DatagramSocket udpServerSocket, StreamSocket tcpServerSocket, ServerAddress localAddress, TransportAddress remoteAddress, IntegerHolder readLength) {
        if (buffer.getLength() > 0) {
            int num = buffer.read8(0) & this._requestBitmask;
            if (num == 64 && buffer.getLength() >= 4) {
                int num5;
                int channelNumber = buffer.read16(0);
                int length = buffer.read16(2);
                int num4 = length + 4;
                if (num4 <= buffer.getLength()) {
                    this.processChannelData(buffer.subset(4, length), channelNumber, remoteAddress);
                }
                readLength.setValue(num4);
                if (tcpServerSocket != null && (num5 = readLength.getValue() % 4) > 0) {
                    readLength.setValue(readLength.getValue() + (4 - num5));
                }
                return true;
            }
            if (num == 0) {
                boolean _var0 = super.processBuffer(buffer, udpServerSocket, tcpServerSocket, localAddress, remoteAddress, readLength);
                return _var0;
            }
        }
        readLength.setValue(0);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Message processChannelBindRequest(ChannelBindRequest request, TransportAddress remoteAddress, Holder<byte[]> longTermKeyBytes) {
        Error error = null;
        longTermKeyBytes.setValue(null);
        error = this.checkNonce(request, remoteAddress, TurnAuthOperation.ChannelBind);
        if (error != null) {
            return this.createExceptionResponse(request, remoteAddress, error);
        }
        Error _var0 = this.authenticate(request, remoteAddress, TurnAuthOperation.ChannelBind, longTermKeyBytes);
        error = _var0;
        if (error != null) {
            return this.createExceptionResponse(request, remoteAddress, error);
        }
        XorPeerAddressAttribute xorPeerAddress = request.getXorPeerAddress();
        if (xorPeerAddress == null) {
            if (Log.getIsErrorEnabled()) {
                Log.error(StringExtensions.format("Could not process channel-bind request for {0} - no peer addresses.", remoteAddress.toString()));
            }
            return this.createExceptionResponse(request, remoteAddress, new BadRequestError());
        }
        ChannelNumberAttribute channelNumber = request.getChannelNumber();
        if (channelNumber == null) {
            if (Log.getIsErrorEnabled()) {
                Log.error(StringExtensions.format("Could not process channel-bind request for {0} - no channel number.", remoteAddress.toString()));
            }
            return this.createExceptionResponse(request, remoteAddress, new BadRequestError());
        }
        if (channelNumber.getChannelNumber() < 16384 || channelNumber.getChannelNumber() > 32766) {
            if (Log.getIsErrorEnabled()) {
                Log.error(StringExtensions.format("Could not process channel-bind request for {0} - invalid channel number.", remoteAddress.toString()));
            }
            return this.createExceptionResponse(request, remoteAddress, new BadRequestError());
        }
        TurnAllocation allocation = null;
        Object object = this._allocationsLock;
        synchronized (object) {
            Holder<Object> _var1 = new Holder<Object>(allocation);
            boolean _var2 = this.tryGetAllocationByClientAddress(remoteAddress, _var1);
            allocation = _var1.getValue();
            if (!_var2) {
                String str = StringExtensions.format("Could not process channel-bind request for {0} - allocation does not exist (mismatch).", remoteAddress.toString());
                error = new AllocationMismatchError(str);
                if (Log.getIsErrorEnabled()) {
                    Log.error(str);
                }
                return this.createExceptionResponse(request, remoteAddress, error);
            }
            if (!this.authorize(allocation, request)) {
                String str = StringExtensions.format("Could not process channel-bind request for {0} - authorization failed.", remoteAddress.toString());
                error = new WrongCredentialsError(str);
                if (Log.getIsDebugEnabled()) {
                    Log.error(str);
                }
                return this.createExceptionResponse(request, remoteAddress, error);
            }
            error = allocation.addChannelBinding(new TransportAddress(xorPeerAddress.getIPAddress(), xorPeerAddress.getPort()), channelNumber.getChannelNumber(), remoteAddress);
            if (error != null) {
                return this.createExceptionResponse(request, remoteAddress, error);
            }
        }
        return new ChannelBindResponse(request.getTransactionId(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processChannelData(DataBuffer buffer, int channelNumber, TransportAddress remoteAddress) {
        TurnAllocation allocation = null;
        Object object = this._allocationsLock;
        synchronized (object) {
            Holder<Object> _var0 = new Holder<Object>(allocation);
            boolean _var1 = this.tryGetAllocationByClientAddress(remoteAddress, _var0);
            allocation = _var0.getValue();
            if (!_var1) {
                allocation = null;
            }
        }
        if (allocation != null) {
            TransportAddress peerAddress = allocation.hasChannelBindingNumber(channelNumber);
            if (peerAddress != null) {
                this.sendDataToPeer(buffer, peerAddress, allocation, remoteAddress, true);
            } else if (Log.getIsWarnEnabled()) {
                Log.warn(StringExtensions.format("Could not channel-send {0} data for {1} - no channel binding.", peerAddress.toString(), remoteAddress.toString()));
            }
        } else if (Log.getIsWarnEnabled()) {
            Log.warn(StringExtensions.format("Could not channel-send data for {0} - no allocation.", remoteAddress.toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Message processCreatePermissionRequest(CreatePermissionRequest request, TransportAddress remoteAddress, Holder<byte[]> longTermKeyBytes) {
        Error error = null;
        Message message = null;
        longTermKeyBytes.setValue(null);
        error = this.checkNonce(request, remoteAddress, TurnAuthOperation.CreatePermission);
        if (error != null) {
            return this.createExceptionResponse(request, remoteAddress, error);
        }
        Error _var0 = this.authenticate(request, remoteAddress, TurnAuthOperation.CreatePermission, longTermKeyBytes);
        error = _var0;
        if (error != null) {
            return this.createExceptionResponse(request, remoteAddress, error);
        }
        ArrayList<XorPeerAddressAttribute> list = new ArrayList<XorPeerAddressAttribute>();
        for (Attribute attribute : request.getAttributes()) {
            if (!Global.equals(attribute.getClass(), XorPeerAddressAttribute.class)) continue;
            list.add((XorPeerAddressAttribute)attribute);
        }
        if (ArrayListExtensions.getCount(list) == 0) {
            if (Log.getIsErrorEnabled()) {
                Log.error(StringExtensions.format("Could not process create-permission request for {0} - no peer addresses.", remoteAddress.toString()));
            }
            return this.createExceptionResponse(request, remoteAddress, new BadRequestError());
        }
        TurnAllocation allocation = null;
        Object object = this._allocationsLock;
        synchronized (object) {
            Holder<Object> _var1 = new Holder<Object>(allocation);
            boolean _var2 = this.tryGetAllocationByClientAddress(remoteAddress, _var1);
            allocation = _var1.getValue();
            if (!_var2) {
                String str = StringExtensions.format("Could not process create-permission request for {0} - allocation does not exist (mismatch).", remoteAddress.toString());
                error = new AllocationMismatchError(str);
                if (Log.getIsErrorEnabled()) {
                    Log.error(str);
                }
                return this.createExceptionResponse(request, remoteAddress, error);
            }
            if (!this.authorize(allocation, request)) {
                String str = StringExtensions.format("Could not process create-permission request for {0} - authorization failed.", remoteAddress.toString());
                error = new WrongCredentialsError(str);
                if (Log.getIsDebugEnabled()) {
                    Log.error(str);
                }
                message = this.createExceptionResponse(request, remoteAddress, error);
            }
            for (XorPeerAddressAttribute attribute2 : list) {
                if (allocation.addPermission(attribute2.getIPAddress())) {
                    if (!Log.getIsDebugEnabled()) continue;
                    Log.debug(StringExtensions.format("Adding {0}:{1} allocation permission for {2}.", attribute2.getIPAddress(), IntegerExtensions.toString(attribute2.getPort()), remoteAddress.toString()));
                    continue;
                }
                if (!Log.getIsDebugEnabled()) continue;
                Log.debug(StringExtensions.format("Extending {0}:{1} allocation permission for {2}.", attribute2.getIPAddress(), IntegerExtensions.toString(attribute2.getPort()), remoteAddress.toString()));
            }
        }
        return new CreatePermissionResponse(request.getTransactionId(), true);
    }

    private void processNonce() {
        this.setNonce(this.generateNonce());
        if (Log.getIsInfoEnabled() && this.getStaleNonceSecurity()) {
            Log.info(StringExtensions.format("Nonce updated. ({0})", this.getNonce()));
        }
        this._nonceTimer = new TimeoutTimer((IAction1<Object>)new IActionDelegate1<Object>(){

            @Override
            public String getId() {
                return "fm.icelink.TurnServer.nonceTimerCallback";
            }

            @Override
            public void invoke(Object state) {
                TurnServer.this.nonceTimerCallback(state);
            }
        }, null);
        try {
            this._nonceTimer.start(3600000);
        }
        catch (Exception exception) {
            Log.error("Could not start nonce timer.", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Message processRefreshRequest(RefreshRequest request, TransportAddress remoteAddress, Holder<byte[]> longTermKeyBytes) {
        Error error = null;
        Message message = null;
        longTermKeyBytes.setValue(null);
        error = this.checkNonce(request, remoteAddress, TurnAuthOperation.Refresh);
        if (error != null) {
            return this.createExceptionResponse(request, remoteAddress, error);
        }
        Error _var0 = this.authenticate(request, remoteAddress, TurnAuthOperation.Refresh, longTermKeyBytes);
        error = _var0;
        if (error != null) {
            return this.createExceptionResponse(request, remoteAddress, error);
        }
        LifetimeAttribute lifetime = request.getLifetime();
        boolean flag = lifetime != null && lifetime.getLifetime() == 0L;
        TurnAllocation allocation = null;
        Object object = this._allocationsLock;
        synchronized (object) {
            Holder<Object> _var1 = new Holder<Object>(allocation);
            boolean _var2 = this.tryGetAllocationByClientAddress(remoteAddress, _var1);
            allocation = _var1.getValue();
            if (!_var2) {
                String str = StringExtensions.format("Could not process refresh request for {0} - allocation does not exist (mismatch).", remoteAddress.toString());
                error = new AllocationMismatchError(str);
                if (!flag && Log.getIsWarnEnabled()) {
                    Log.warn(str);
                }
                return this.createExceptionResponse(request, remoteAddress, error);
            }
            if (!this.authorize(allocation, request)) {
                String str = StringExtensions.format("Could not process refresh request for {0} - authorization failed.", remoteAddress.toString());
                error = new WrongCredentialsError(str);
                if (Log.getIsDebugEnabled()) {
                    Log.error(str);
                }
                message = this.createExceptionResponse(request, remoteAddress, error);
            }
            if (flag) {
                if (Log.getIsDebugEnabled()) {
                    Log.debug(StringExtensions.format("Deallocating socket for {0} by request.", remoteAddress.toString()));
                }
                this.removeAllocation(allocation);
            }
        }
        if (!flag) {
            long defaultRefreshLifetime = this.getDefaultRefreshLifetime();
            if (lifetime != null && !this.getForceDefaultRefreshLifetime()) {
                defaultRefreshLifetime = MathAssistant.min(this.getMaxRefreshLifetime(), MathAssistant.max(this.getMinRefreshLifetime(), (long)((int)lifetime.getLifetime())));
            }
            if (Log.getIsDebugEnabled()) {
                Log.debug(StringExtensions.format("Extending allocation expiration for {0} by {1} seconds.", remoteAddress.toString(), LongExtensions.toString(defaultRefreshLifetime)));
            }
            allocation.refresh(defaultRefreshLifetime);
        }
        RefreshResponse response = new RefreshResponse(request.getTransactionId(), true);
        if (!flag) {
            response.setLifetime(new LifetimeAttribute(allocation.getLastLifetime()));
        } else {
            response.setLifetime(new LifetimeAttribute(0L));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TurnAllocation processSendIndication(SendIndication indication, TransportAddress remoteAddress) {
        TurnAllocation allocation = null;
        XorPeerAddressAttribute xorPeerAddress = indication.getXorPeerAddress();
        DataAttribute data = indication.getData();
        if (xorPeerAddress != null && data != null) {
            Object object = this._allocationsLock;
            synchronized (object) {
                Holder<Object> _var0 = new Holder<Object>(allocation);
                boolean _var1 = this.tryGetAllocationByClientAddress(remoteAddress, _var0);
                allocation = _var0.getValue();
                if (!_var1) {
                    allocation = null;
                }
            }
            if (allocation != null) {
                this.sendDataToPeer(data.getData(), new TransportAddress(xorPeerAddress.getIPAddress(), xorPeerAddress.getPort()), allocation, remoteAddress, false);
                return allocation;
            }
            if (Log.getIsWarnEnabled()) {
                Log.warn(StringExtensions.format("Could not send data for {0} - no allocation.", remoteAddress.toString()));
            }
        }
        return allocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAllocation(TurnAllocation allocation) {
        Object object = this._allocationsLock;
        synchronized (object) {
            HashMapExtensions.remove(this._allocationsByClientAddress, allocation.getClientAddress().toString());
            HashMapExtensions.remove(this._allocationsByLocalPort, allocation.getLocalPort());
            try {
                allocation.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAllocations() {
        Object object = this._allocationsLock;
        synchronized (object) {
            ArrayList<String> list = new ArrayList<String>();
            for (String str : HashMapExtensions.getKeys(this._allocationsByClientAddress)) {
                list.add(str);
            }
            for (String str : list) {
                this.removeAllocation(HashMapExtensions.getItem(this._allocationsByClientAddress).get(str));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeReservations() {
        Object object = this._reservationsLock;
        synchronized (object) {
            ArrayList<String> list = new ArrayList<String>();
            for (String str : HashMapExtensions.getKeys(this._reservations)) {
                list.add(str);
            }
            for (String str : list) {
                try {
                    HashMapExtensions.getItem(this._reservations).get(str).close();
                }
                catch (Exception exception) {}
            }
            this._reservations.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendDataToPeer(DataBuffer buffer, TransportAddress peerAddress, TurnAllocation allocation, TransportAddress remoteAddress, boolean channel) {
        Exception exception = null;
        TurnAllocation allocation2 = null;
        Object object = this._allocationsLock;
        synchronized (object) {
            Holder<Object> _var0 = new Holder<Object>(allocation2);
            boolean _var1 = this.tryGetAllocationByServerAddress(peerAddress, _var0);
            allocation2 = _var0.getValue();
            if (!_var1) {
                allocation2 = null;
            }
        }
        TransportAddress address = new TransportAddress(allocation.getPublicIPAddress() != null ? allocation.getPublicIPAddress() : allocation.getLocalIPAddress(), allocation.getLocalPort());
        if (!this.getDisableBypass() && allocation2 != null) {
            this.onPacketDataReceived((TurnUdpAllocation)allocation2, address, buffer);
        } else {
            Holder<Object> _var2 = new Holder<Object>(exception);
            boolean _var3 = ((TurnUdpAllocation)allocation).sendData(buffer, peerAddress, _var2);
            exception = _var2.getValue();
            if (!_var3 && Log.getIsWarnEnabled()) {
                if (channel) {
                    Log.warn(StringExtensions.format("Could not channel-send {0} data for {1}).", peerAddress.toString(), remoteAddress.toString()), exception);
                } else {
                    Log.warn(StringExtensions.format("Could not send {0} data for {1}.", peerAddress.toString(), remoteAddress.toString()), exception);
                }
            }
        }
    }

    public void setAllocationPortMax(int value) {
        if (value <= 0 || value >= 65535) {
            throw new RuntimeException(new Exception("Value must be greater than 0 and less than 65,535."));
        }
        this.__allocationPortMax = value;
    }

    public void setAllocationPortMin(int value) {
        if (value <= 0 || value >= 65535) {
            throw new RuntimeException(new Exception("Value must be greater than 0 and less than 65,535."));
        }
        this.__allocationPortMin = value;
    }

    public void setDefaultAllocateLifetime(long value) {
        this.__defaultAllocateLifetime = MathAssistant.min(this.getMaxAllocateLifetime(), MathAssistant.max(this.getMinAllocateLifetime(), value));
    }

    public void setDefaultRefreshLifetime(long value) {
        this.__defaultRefreshLifetime = MathAssistant.min(this.getMaxRefreshLifetime(), MathAssistant.max(this.getMinRefreshLifetime(), value));
    }

    public void setDisableBypass(boolean value) {
        this._disableBypass = value;
    }

    public void setForceDefaultAllocateLifetime(boolean value) {
        this._forceDefaultAllocateLifetime = value;
    }

    public void setForceDefaultRefreshLifetime(boolean value) {
        this._forceDefaultRefreshLifetime = value;
    }

    public void setMaxAllocateLifetime(long value) {
        this.__maxAllocateLifetime = MathAssistant.max(this.getMinAllocateLifetime(), value);
    }

    public void setMaxRefreshLifetime(long value) {
        this.__maxRefreshLifetime = MathAssistant.max(this.getMinRefreshLifetime(), value);
    }

    private void setNonce(String value) {
        this._nonce = value;
    }

    public void setRealm(String value) {
        this._realm = value;
    }

    public void setStaleNonceSecurity(boolean value) {
        this._staleNonceSecurity = value;
    }

    @Override
    public boolean start(ServerAddress[] udpAddresses, ServerAddress[] tcpAddresses) {
        if (this.getAllocationPortMin() > this.getAllocationPortMax()) {
            throw new RuntimeException(new Exception("AllocationPortMin cannot be greater than AllocationPortMax."));
        }
        if (super.start(udpAddresses, tcpAddresses)) {
            this.processNonce();
            return true;
        }
        return false;
    }

    @Override
    public boolean stop() {
        if (super.stop()) {
            this._nonceTimer.stop();
            this.removeReservations();
            this.removeAllocations();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryAllocateTcpSocket(ServerAddress localAddress, TransportAddress remoteAddress, Holder<StreamSocket> socket) {
        int port = 0;
        Object object = _nextTcpPortLock;
        synchronized (object) {
            if (this._nextTcpPort == 0) {
                this._nextTcpPort = this.getAllocationPortMin();
            }
            if (this._nextTcpPort > this.getAllocationPortMax()) {
                this._nextTcpPort = this.getAllocationPortMin();
            }
            port = this._nextTcpPort++;
        }
        this.createTcpSocket(new ServerAddress(localAddress.getIPAddress(), port, localAddress.getPublicIPAddress()), socket);
        if (socket.getValue() == null) {
            return false;
        }
        if (Log.getIsDebugEnabled()) {
            Log.debug(StringExtensions.format("TCP socket allocated on port {0} for {1}.", IntegerExtensions.toString(port), remoteAddress.toString()));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryAllocateUdpSocket(ServerAddress localAddress, EvenPortAttribute evenPort, TransportAddress remoteAddress, Holder<DatagramSocket> socket, Holder<DataBuffer> reservation) {
        int port = 0;
        Object object = _nextUdpPortLock;
        synchronized (object) {
            if (this._nextUdpPort == 0) {
                this._nextUdpPort = this.getAllocationPortMin();
            }
            if (evenPort != null && this._nextUdpPort % 2 != 0) {
                ++this._nextUdpPort;
            }
            if (this._nextUdpPort > this.getAllocationPortMax()) {
                this._nextUdpPort = this.getAllocationPortMin();
            }
            port = this._nextUdpPort++;
        }
        this.createUdpSocket(new ServerAddress(localAddress.getIPAddress(), port, localAddress.getPublicIPAddress()), socket);
        if (socket.getValue() == null) {
            reservation.setValue(null);
            return false;
        }
        if (Log.getIsDebugEnabled()) {
            Log.debug(StringExtensions.format("UDP socket allocated on port {0} for {1}.", IntegerExtensions.toString(port), remoteAddress.toString()));
        }
        if (evenPort == null || !evenPort.getReserveNextHigher()) {
            reservation.setValue(null);
            return true;
        }
        boolean _var0 = this.tryAllocateUdpSocketReservation(localAddress, remoteAddress, port + 1, socket.getValue(), reservation);
        return _var0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryAllocateUdpSocketReservation(ServerAddress localAddress, TransportAddress remoteAddress, int port, DatagramSocket socket, Holder<DataBuffer> reservation) {
        DatagramSocket socket2 = null;
        Holder<Object> _var0 = new Holder<Object>(socket2);
        this.createUdpSocket(new ServerAddress(localAddress.getIPAddress(), port, localAddress.getPublicIPAddress()), _var0);
        socket2 = _var0.getValue();
        if (socket2 == null) {
            try {
                socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            reservation.setValue(null);
            return false;
        }
        reservation.setValue(DataBuffer.allocate(8, false));
        LockedRandomizer.nextBytes(reservation.getValue().getData());
        String str = Base64.encodeBuffer(reservation.getValue());
        if (Log.getIsDebugEnabled()) {
            Log.debug(StringExtensions.format("UDP socket reservation {0} created on port {1} for {2}.", str, IntegerExtensions.toString(port), remoteAddress.toString()));
        }
        Object object = this._reservationsLock;
        synchronized (object) {
            HashMapExtensions.set(HashMapExtensions.getItem(this._reservations), str, socket2);
        }
        new TimeoutTimer((IAction1<Object>)new IActionDelegate1<Object>(){

            @Override
            public String getId() {
                return "fm.icelink.TurnServer.expireReservedUdpSocket";
            }

            @Override
            public void invoke(Object state) {
                TurnServer.this.expireReservedUdpSocket(state);
            }
        }, str).start(30000);
        return true;
    }

    boolean tryAuthenticate(Message request, TurnAuthOperation operation, BooleanHolder missingCredentials, Holder<byte[]> longTermKeyBytes) {
        UsernameAttribute username = request.getUsername();
        RealmAttribute realm = request.getRealm();
        MessageIntegrityAttribute messageIntegrity = request.getMessageIntegrity();
        if (username == null || realm == null || messageIntegrity == null) {
            missingCredentials.setValue(true);
            longTermKeyBytes.setValue(null);
            return false;
        }
        missingCredentials.setValue(false);
        IFunction1<TurnAuthArgs, TurnAuthResult> authCallback = this._authCallback;
        if (authCallback != null) {
            TurnAuthArgs p = new TurnAuthArgs(username.getValue(), realm.getValue(), operation);
            TurnAuthResult result = authCallback.invoke(p);
            if (result == null) {
                longTermKeyBytes.setValue(null);
                return false;
            }
            if (result.getPassword() != null) {
                longTermKeyBytes.setValue(Utility.createLongTermKey(username.getValue(), realm.getValue(), result.getPassword()));
            } else {
                longTermKeyBytes.setValue(result.getLongTermKeyBytes());
            }
            return messageIntegrity.isValid(longTermKeyBytes.getValue());
        }
        longTermKeyBytes.setValue(null);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryGetAllocationByClientAddress(TransportAddress clientAddress, Holder<TurnAllocation> allocation) {
        Object object = this._allocationsLock;
        synchronized (object) {
            boolean _var0 = HashMapExtensions.tryGetValue(this._allocationsByClientAddress, clientAddress.toString(), allocation);
            if (_var0) {
                if (allocation.getValue().getIsExpired()) {
                    this.removeAllocation(allocation.getValue());
                    if (Log.getIsWarnEnabled()) {
                        Log.warn(StringExtensions.format("Socket allocation for {0} has expired and been removed.", allocation.getValue().getClientAddress().toString()));
                    }
                    allocation.setValue(null);
                    return false;
                }
                return true;
            }
        }
        allocation.setValue(null);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryGetAllocationByServerAddress(TransportAddress serverAddress, Holder<TurnAllocation> allocation) {
        Object object = this._allocationsLock;
        synchronized (object) {
            boolean _var0 = HashMapExtensions.tryGetValue(this._allocationsByLocalPort, Integer.valueOf(serverAddress.getPort()), allocation);
            if (_var0) {
                if (allocation.getValue().getIsExpired()) {
                    this.removeAllocation(allocation.getValue());
                    if (Log.getIsWarnEnabled()) {
                        Log.warn(StringExtensions.format("Socket allocation for {0} has expired and been removed.", allocation.getValue().getClientAddress().toString()));
                    }
                    allocation.setValue(null);
                    return false;
                }
                String publicIPAddress = allocation.getValue().getPublicIPAddress();
                if (publicIPAddress == null) {
                    publicIPAddress = allocation.getValue().getLocalIPAddress();
                }
                if (Global.equals(serverAddress.getIPAddress(), publicIPAddress)) {
                    return true;
                }
            }
        }
        allocation.setValue(null);
        return false;
    }

    public TurnServer(IFunction1<TurnAuthArgs, TurnAuthResult> authCallback) {
        this._allocationsByLocalPort = new HashMap();
        this._allocationsByClientAddress = new HashMap();
        this._allocationsLock = new Object();
        this._reservations = new HashMap();
        this._reservationsLock = new Object();
        License.checkKey();
        this.setRealm(this.generateRealm());
        this._authCallback = authCallback;
    }

    static {
        _nextUdpPortLock = new Object();
        _nextTcpPortLock = new Object();
    }
}

