/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.Binary;
import fm.icelink.ByteCollection;
import fm.icelink.IntegerHolder;
import fm.icelink.Log;
import fm.icelink.NullableLong;
import fm.icelink.SctpErrorCause;
import fm.icelink.StringExtensions;

class SctpStaleCookieError
extends SctpErrorCause {
    private long _measureOfStaleness;

    @Override
    public byte[] getBytes() {
        return SctpStaleCookieError.getBytes(this);
    }

    public static byte[] getBytes(SctpStaleCookieError cause) {
        ByteCollection bytes = new ByteCollection();
        bytes.addRange(Binary.toBytes16(cause.getCauseCode(), false));
        bytes.addRange(Binary.toBytes16(8, false));
        bytes.addRange(Binary.toBytes32(cause.getMeasureOfStaleness(), false));
        return bytes.toArray();
    }

    public long getMeasureOfStaleness() {
        return this._measureOfStaleness;
    }

    public static SctpStaleCookieError parseBytes(byte[] bytes, IntegerHolder offsetPlus) {
        try {
            offsetPlus.setValue(8);
            return new SctpStaleCookieError(new NullableLong(Binary.fromBytes32(bytes, 4, false)));
        }
        catch (Exception exception1) {
            offsetPlus.setValue(0);
            return null;
        }
    }

    public SctpStaleCookieError(NullableLong staleTime) {
        super.setCauseCode(3);
        NullableLong nullable = staleTime;
        this.setMeasureOfStaleness(nullable.getHasValue() ? nullable.getValueOrDefault() : 0L);
        Log.debug(StringExtensions.format("SCTP Error: stale cookie by {0}", staleTime.toString()));
    }

    public void setMeasureOfStaleness(long value) {
        this._measureOfStaleness = value;
    }
}

