/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.Binary;
import fm.icelink.ByteCollection;
import fm.icelink.IntegerHolder;
import fm.icelink.Log;
import fm.icelink.SctpTlvParameter;

class SctpPadChunkParameter
extends SctpTlvParameter {
    private int __length = 4;

    public static byte[] getBytes(SctpPadChunkParameter parameter) {
        ByteCollection bytes = new ByteCollection();
        bytes.addRange(Binary.toBytes16(32773, false));
        bytes.addRange(Binary.toBytes16(parameter.__length, false));
        byte[] buffer = new byte[4];
        for (int num = parameter.__length - 4; num > 0; num -= 4) {
            bytes.addRange(buffer);
        }
        return bytes.toArray();
    }

    @Override
    public byte[] getBytes() {
        return SctpPadChunkParameter.getBytes(this);
    }

    public static SctpPadChunkParameter parseBytes(byte[] bytes, IntegerHolder offsetPlus) {
        try {
            int length = Binary.fromBytes16(bytes, 2, false);
            offsetPlus.setValue(length);
            return new SctpPadChunkParameter(length);
        }
        catch (Exception exception1) {
            offsetPlus.setValue(0);
            Log.debug("Could not read PadChunkParameter.");
            return null;
        }
    }

    public SctpPadChunkParameter(int length) {
        if (this.__length <= 3 || this.__length >= 65536 || this.__length % 4 != 0) {
            throw new RuntimeException(new Exception("Valid padding parameter size is between 4 and 65536 bytes"));
        }
        this.__length = length;
        super.setType(32773);
    }
}

