/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.Constants;

public class ManagedStopwatch {
    private long startTime = 0L;
    private long stopTime = 0L;

    public static long getTimestamp() {
        return System.nanoTime() * (long)Constants.getTicksPerMillisecond() / 1000000L;
    }

    public long getElapsedTicks() {
        if (this.startTime == 0L) {
            return 0L;
        }
        if (this.stopTime == 0L) {
            return (System.nanoTime() - this.startTime) * (long)Constants.getTicksPerMillisecond() / 1000000L;
        }
        return (this.stopTime - this.startTime) * (long)Constants.getTicksPerMillisecond() / 1000000L;
    }

    public long getElapsedMilliseconds() {
        return this.getElapsedTicks() / (long)Constants.getTicksPerMillisecond();
    }

    public void start() {
        this.startTime = System.nanoTime();
        this.stopTime = 0L;
    }

    public void stop() {
        this.stopTime = System.nanoTime();
    }

    public void restart() {
        this.start();
    }
}

