/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.ArrayListExtensions;
import fm.icelink.AudioSource;
import fm.icelink.AudioTrack;
import fm.icelink.Future;
import fm.icelink.Global;
import fm.icelink.IAction0;
import fm.icelink.IAction1;
import fm.icelink.IActionDelegate0;
import fm.icelink.ILocalMedia;
import fm.icelink.IMedia;
import fm.icelink.LocalMediaBase;
import fm.icelink.MediaSourceBase;
import fm.icelink.Promise;
import fm.icelink.SourceInput;
import fm.icelink.VideoSource;
import fm.icelink.VideoTrack;
import java.util.ArrayList;
import java.util.List;

public class LocalMedia
extends LocalMediaBase<LocalMedia, AudioTrack, VideoTrack>
implements ILocalMedia<LocalMedia, AudioTrack, VideoTrack>,
IMedia<AudioTrack, VideoTrack> {
    private List<IAction0> __onAudioStarted = new ArrayList<IAction0>();
    private List<IAction0> __onAudioStopped = new ArrayList<IAction0>();
    private List<IAction0> __onVideoStarted = new ArrayList<IAction0>();
    private List<IAction0> __onVideoStopped = new ArrayList<IAction0>();
    private IAction0 _onAudioStarted = null;
    private IAction0 _onAudioStopped = null;
    private IAction0 _onVideoStarted = null;
    private IAction0 _onVideoStopped = null;

    @Override
    protected void addAudioTrack(AudioTrack audioTrack) {
        if (audioTrack != null && ArrayExtensions.getLength(this.getAudioTracks()) == 0) {
            audioTrack.addOnStarted(new IActionDelegate0(){

                @Override
                public String getId() {
                    return "fm.icelink.LocalMedia.audioTrack_OnStarted";
                }

                @Override
                public void invoke() {
                    LocalMedia.this.audioTrack_OnStarted();
                }
            });
            audioTrack.addOnStopped(new IActionDelegate0(){

                @Override
                public String getId() {
                    return "fm.icelink.LocalMedia.audioTrack_OnStopped";
                }

                @Override
                public void invoke() {
                    LocalMedia.this.audioTrack_OnStopped();
                }
            });
        }
        super.addAudioTrack(audioTrack);
    }

    @Override
    public void addOnAudioStarted(IAction0 value) {
        if (value != null) {
            if (this._onAudioStarted == null) {
                this._onAudioStarted = new IAction0(){

                    @Override
                    public void invoke() {
                        for (IAction0 action : new ArrayList(LocalMedia.this.__onAudioStarted)) {
                            action.invoke();
                        }
                    }
                };
            }
            this.__onAudioStarted.add(value);
        }
    }

    @Override
    public void addOnAudioStopped(IAction0 value) {
        if (value != null) {
            if (this._onAudioStopped == null) {
                this._onAudioStopped = new IAction0(){

                    @Override
                    public void invoke() {
                        for (IAction0 action : new ArrayList(LocalMedia.this.__onAudioStopped)) {
                            action.invoke();
                        }
                    }
                };
            }
            this.__onAudioStopped.add(value);
        }
    }

    @Override
    public void addOnVideoStarted(IAction0 value) {
        if (value != null) {
            if (this._onVideoStarted == null) {
                this._onVideoStarted = new IAction0(){

                    @Override
                    public void invoke() {
                        for (IAction0 action : new ArrayList(LocalMedia.this.__onVideoStarted)) {
                            action.invoke();
                        }
                    }
                };
            }
            this.__onVideoStarted.add(value);
        }
    }

    @Override
    public void addOnVideoStopped(IAction0 value) {
        if (value != null) {
            if (this._onVideoStopped == null) {
                this._onVideoStopped = new IAction0(){

                    @Override
                    public void invoke() {
                        for (IAction0 action : new ArrayList(LocalMedia.this.__onVideoStopped)) {
                            action.invoke();
                        }
                    }
                };
            }
            this.__onVideoStopped.add(value);
        }
    }

    @Override
    protected void addVideoTrack(VideoTrack videoTrack) {
        if (videoTrack != null && ArrayExtensions.getLength(this.getVideoTracks()) == 0) {
            videoTrack.addOnStarted(new IActionDelegate0(){

                @Override
                public String getId() {
                    return "fm.icelink.LocalMedia.videoTrack_OnStarted";
                }

                @Override
                public void invoke() {
                    LocalMedia.this.videoTrack_OnStarted();
                }
            });
            videoTrack.addOnStopped(new IActionDelegate0(){

                @Override
                public String getId() {
                    return "fm.icelink.LocalMedia.videoTrack_OnStopped";
                }

                @Override
                public void invoke() {
                    LocalMedia.this.videoTrack_OnStopped();
                }
            });
        }
        super.addVideoTrack(videoTrack);
    }

    protected AudioTrack[] arrayFromAudioTracks(ArrayList<AudioTrack> tracks) {
        return tracks.toArray(new AudioTrack[0]);
    }

    protected VideoTrack[] arrayFromVideoTracks(ArrayList<VideoTrack> tracks) {
        return tracks.toArray(new VideoTrack[0]);
    }

    private void audioTrack_OnStarted() {
        IAction0 onAudioStarted = this._onAudioStarted;
        if (onAudioStarted != null) {
            onAudioStarted.invoke();
        }
    }

    private void audioTrack_OnStopped() {
        IAction0 onAudioStopped = this._onAudioStopped;
        if (onAudioStopped != null) {
            onAudioStopped.invoke();
        }
    }

    @Override
    public Future<Object> changeAudioSourceInput(SourceInput audioSourceInput) {
        AudioTrack audioTrack = (AudioTrack)super.getAudioTrack();
        if (audioTrack != null) {
            return audioTrack.changeSourceInput(audioSourceInput);
        }
        Promise<Object> promise = new Promise<Object>();
        promise.reject(new Exception("No audio track."));
        return promise;
    }

    @Override
    public Future<Object> changeVideoSourceInput(SourceInput videoSourceInput) {
        VideoTrack videoTrack = (VideoTrack)super.getVideoTrack();
        if (videoTrack != null) {
            return videoTrack.changeSourceInput(videoSourceInput);
        }
        Promise<Object> promise = new Promise<Object>();
        promise.reject(new Exception("No video track."));
        return promise;
    }

    @Override
    protected ArrayList<AudioTrack> createAudioTrackCollection() {
        return new ArrayList<AudioTrack>();
    }

    @Override
    protected ArrayList<VideoTrack> createVideoTrackCollection() {
        return new ArrayList<VideoTrack>();
    }

    @Override
    protected Future<LocalMedia> doStart() {
        Promise<LocalMedia> promise = new Promise<LocalMedia>();
        Object[] mediaSources = this.getMediaSources();
        if (ArrayExtensions.getLength(mediaSources) > 0) {
            this.doStartSource(promise, (MediaSourceBase[])mediaSources, 0);
            return promise;
        }
        promise.resolve(this);
        return promise;
    }

    private void doStartSource(final Promise<LocalMedia> promise, final MediaSourceBase[] mediaSources, final int index) {
        IAction1<Object> resolveAction = null;
        IAction1<Exception> rejectAction = null;
        if (index < ArrayExtensions.getLength(mediaSources)) {
            if (resolveAction == null) {
                resolveAction = new IAction1<Object>(){

                    @Override
                    public void invoke(Object o) {
                        LocalMedia.this.doStartSource(promise, mediaSources, index + 1);
                    }
                };
            }
            if (rejectAction == null) {
                rejectAction = new IAction1<Exception>(){

                    @Override
                    public void invoke(Exception ex) {
                        LocalMedia.this.abortStart(promise, ex);
                    }
                };
            }
            mediaSources[index].start().then(resolveAction, rejectAction);
        } else {
            promise.resolve(this);
        }
    }

    @Override
    protected Future<LocalMedia> doStop() {
        Promise<LocalMedia> promise = new Promise<LocalMedia>();
        Object[] mediaSources = this.getMediaSources();
        if (ArrayExtensions.getLength(mediaSources) > 0) {
            this.doStopSource(promise, (MediaSourceBase[])mediaSources, 0);
            return promise;
        }
        promise.resolve(this);
        return promise;
    }

    private void doStopSource(final Promise<LocalMedia> promise, final MediaSourceBase[] mediaSources, final int index) {
        IAction1<Object> resolveAction = null;
        IAction1<Exception> rejectAction = null;
        if (index < ArrayExtensions.getLength(mediaSources)) {
            if (resolveAction == null) {
                resolveAction = new IAction1<Object>(){

                    @Override
                    public void invoke(Object result) {
                        LocalMedia.this.doStopSource(promise, mediaSources, index + 1);
                    }
                };
            }
            if (rejectAction == null) {
                rejectAction = new IAction1<Exception>(){

                    @Override
                    public void invoke(Exception ex) {
                        promise.reject(ex);
                    }
                };
            }
            mediaSources[index].stop().then(resolveAction, rejectAction);
        } else {
            promise.resolve(this);
        }
    }

    public AudioSource getAudioSource() {
        Object[] audioSources = this.getAudioSources();
        if (audioSources == null || ArrayExtensions.getLength(audioSources) == 0) {
            return null;
        }
        return audioSources[0];
    }

    @Override
    public SourceInput getAudioSourceInput() {
        AudioTrack audioTrack = (AudioTrack)super.getAudioTrack();
        if (audioTrack != null) {
            return audioTrack.getSourceInput();
        }
        return null;
    }

    @Override
    public Future<SourceInput[]> getAudioSourceInputs() {
        AudioTrack audioTrack = (AudioTrack)super.getAudioTrack();
        if (audioTrack != null) {
            return audioTrack.getSourceInputs();
        }
        Promise<SourceInput[]> promise = new Promise<SourceInput[]>();
        promise.resolve(new SourceInput[0]);
        return promise;
    }

    public AudioSource[] getAudioSources() {
        ArrayList list = new ArrayList();
        for (AudioTrack track : this.getAudioTracks()) {
            if (track.getSource() == null) continue;
            list.add(track.getSource());
        }
        return list.toArray(new AudioSource[0]);
    }

    public MediaSourceBase[] getMediaSources() {
        ArrayList list = new ArrayList();
        ArrayListExtensions.addRange(list, this.getAudioSources());
        ArrayListExtensions.addRange(list, this.getVideoSources());
        return list.toArray(new MediaSourceBase[0]);
    }

    public VideoSource getVideoSource() {
        Object[] videoSources = this.getVideoSources();
        if (videoSources == null || ArrayExtensions.getLength(videoSources) == 0) {
            return null;
        }
        return videoSources[0];
    }

    @Override
    public SourceInput getVideoSourceInput() {
        VideoTrack videoTrack = (VideoTrack)super.getVideoTrack();
        if (videoTrack != null) {
            return videoTrack.getSourceInput();
        }
        return null;
    }

    @Override
    public Future<SourceInput[]> getVideoSourceInputs() {
        VideoTrack videoTrack = (VideoTrack)super.getVideoTrack();
        if (videoTrack != null) {
            return videoTrack.getSourceInputs();
        }
        Promise<SourceInput[]> promise = new Promise<SourceInput[]>();
        promise.resolve(new SourceInput[0]);
        return promise;
    }

    public VideoSource[] getVideoSources() {
        ArrayList list = new ArrayList();
        for (VideoTrack track : this.getVideoTracks()) {
            if (track.getSource() == null) continue;
            list.add(track.getSource());
        }
        return list.toArray(new VideoSource[0]);
    }

    @Override
    protected boolean removeAudioTrack(AudioTrack audioTrack) {
        if (audioTrack != null) {
            audioTrack.removeOnStarted(new IActionDelegate0(){

                @Override
                public String getId() {
                    return "fm.icelink.LocalMedia.audioTrack_OnStarted";
                }

                @Override
                public void invoke() {
                    LocalMedia.this.audioTrack_OnStarted();
                }
            });
            audioTrack.removeOnStopped(new IActionDelegate0(){

                @Override
                public String getId() {
                    return "fm.icelink.LocalMedia.audioTrack_OnStopped";
                }

                @Override
                public void invoke() {
                    LocalMedia.this.audioTrack_OnStopped();
                }
            });
        }
        return super.removeAudioTrack(audioTrack);
    }

    @Override
    public void removeOnAudioStarted(IAction0 value) {
        IAction0 match;
        if (value instanceof IActionDelegate0 && (match = Global.findIActionDelegate0WithId(this.__onAudioStarted, ((IActionDelegate0)value).getId())) != null) {
            value = match;
        }
        this.__onAudioStarted.remove(value);
        if (this.__onAudioStarted.size() == 0) {
            this._onAudioStarted = null;
        }
    }

    @Override
    public void removeOnAudioStopped(IAction0 value) {
        IAction0 match;
        if (value instanceof IActionDelegate0 && (match = Global.findIActionDelegate0WithId(this.__onAudioStopped, ((IActionDelegate0)value).getId())) != null) {
            value = match;
        }
        this.__onAudioStopped.remove(value);
        if (this.__onAudioStopped.size() == 0) {
            this._onAudioStopped = null;
        }
    }

    @Override
    public void removeOnVideoStarted(IAction0 value) {
        IAction0 match;
        if (value instanceof IActionDelegate0 && (match = Global.findIActionDelegate0WithId(this.__onVideoStarted, ((IActionDelegate0)value).getId())) != null) {
            value = match;
        }
        this.__onVideoStarted.remove(value);
        if (this.__onVideoStarted.size() == 0) {
            this._onVideoStarted = null;
        }
    }

    @Override
    public void removeOnVideoStopped(IAction0 value) {
        IAction0 match;
        if (value instanceof IActionDelegate0 && (match = Global.findIActionDelegate0WithId(this.__onVideoStopped, ((IActionDelegate0)value).getId())) != null) {
            value = match;
        }
        this.__onVideoStopped.remove(value);
        if (this.__onVideoStopped.size() == 0) {
            this._onVideoStopped = null;
        }
    }

    @Override
    protected boolean removeVideoTrack(VideoTrack videoTrack) {
        if (videoTrack != null) {
            videoTrack.removeOnStarted(new IActionDelegate0(){

                @Override
                public String getId() {
                    return "fm.icelink.LocalMedia.videoTrack_OnStarted";
                }

                @Override
                public void invoke() {
                    LocalMedia.this.videoTrack_OnStarted();
                }
            });
            videoTrack.removeOnStopped(new IActionDelegate0(){

                @Override
                public String getId() {
                    return "fm.icelink.LocalMedia.videoTrack_OnStopped";
                }

                @Override
                public void invoke() {
                    LocalMedia.this.videoTrack_OnStopped();
                }
            });
        }
        return super.removeVideoTrack(videoTrack);
    }

    @Override
    public void setAudioSourceInput(SourceInput value) {
        AudioTrack audioTrack = (AudioTrack)super.getAudioTrack();
        if (audioTrack != null) {
            audioTrack.setSourceInput(value);
        }
    }

    @Override
    public void setVideoSourceInput(SourceInput value) {
        VideoTrack videoTrack = (VideoTrack)super.getVideoTrack();
        if (videoTrack != null) {
            videoTrack.setSourceInput(value);
        }
    }

    private void videoTrack_OnStarted() {
        IAction0 onVideoStarted = this._onVideoStarted;
        if (onVideoStarted != null) {
            onVideoStarted.invoke();
        }
    }

    private void videoTrack_OnStopped() {
        IAction0 onVideoStopped = this._onVideoStopped;
        if (onVideoStopped != null) {
            onVideoStopped.invoke();
        }
    }
}

