/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.DataBuffer;
import fm.icelink.IntegerExtensions;
import fm.icelink.MediaControlFrame;
import fm.icelink.StringExtensions;

public abstract class FeedbackControlFrame
extends MediaControlFrame {
    public FeedbackControlFrame(int feedbackMessageType, int payloadType, DataBuffer buffer) {
        super(buffer);
        if (buffer.getLength() < MediaControlFrame.getFixedHeaderLength() + FeedbackControlFrame.getFixedPayloadHeaderLength()) {
            int num = MediaControlFrame.getFixedHeaderLength() + FeedbackControlFrame.getFixedPayloadHeaderLength();
            throw new RuntimeException(new Exception(StringExtensions.concat("DataBuffer must be at least ", IntegerExtensions.toString(num), " bytes.")));
        }
        this.setFeedbackMessageType(feedbackMessageType);
        super.setPayloadType(payloadType);
    }

    public FeedbackControlFrame(int feedbackMessageType, int payloadType) {
        this(feedbackMessageType, payloadType, DataBuffer.allocate(MediaControlFrame.getFixedHeaderLength() + FeedbackControlFrame.getFixedPayloadHeaderLength()));
        super.setPayloadLengthWithPadding(FeedbackControlFrame.getFixedPayloadHeaderLength());
    }

    public FeedbackControlFrame(int feedbackMessageType, int payloadType, long senderSynchronizationSource, long mediaSynchronizationSource) {
        this(feedbackMessageType, payloadType, DataBuffer.allocate(MediaControlFrame.getFixedHeaderLength() + FeedbackControlFrame.getFixedPayloadHeaderLength()));
        this.setPacketSenderSynchronizationSource(senderSynchronizationSource);
        this.setMediaSourceSynchronizationSource(mediaSynchronizationSource);
        super.setPayloadLengthWithPadding(FeedbackControlFrame.getFixedPayloadHeaderLength());
    }

    public FeedbackControlFrame(int feedbackMessageType, int payloadType, long senderSynchronizationSource, long mediaSynchronizationSource, DataBuffer feedbackControlInformation) {
        this(feedbackMessageType, payloadType, DataBuffer.allocate(MediaControlFrame.getFixedHeaderLength() + FeedbackControlFrame.getFixedPayloadHeaderLength() + feedbackControlInformation.getLength()));
        this.setPacketSenderSynchronizationSource(senderSynchronizationSource);
        this.setMediaSourceSynchronizationSource(mediaSynchronizationSource);
        this.setFeedbackControlInformation(feedbackControlInformation);
        super.setPayloadLengthWithPadding(FeedbackControlFrame.getFixedPayloadHeaderLength() + feedbackControlInformation.getLength());
    }

    public DataBuffer getFeedbackControlInformation() {
        return super.getDataBuffer().subset(this.getFeedbackControlInformationOffset(), super.getPayload().getLength() - FeedbackControlFrame.getFixedPayloadHeaderLength());
    }

    public int getFeedbackControlInformationOffset() {
        return MediaControlFrame.getFixedHeaderLength() + FeedbackControlFrame.getFixedPayloadHeaderLength();
    }

    public int getFeedbackMessageType() {
        return super.getByte1Last5Bits();
    }

    public static int getFixedPayloadHeaderLength() {
        return 8;
    }

    public long getMediaSourceSynchronizationSource() {
        return super.getDataBuffer().read32(MediaControlFrame.getFixedHeaderLength() + 4);
    }

    public long getPacketSenderSynchronizationSource() {
        return super.getDataBuffer().read32(MediaControlFrame.getFixedHeaderLength());
    }

    private void setFeedbackControlInformation(DataBuffer value) {
        super.getDataBuffer().write(value, this.getFeedbackControlInformationOffset());
    }

    public void setFeedbackMessageType(int value) {
        super.setByte1Last5Bits(value);
    }

    public void setMediaSourceSynchronizationSource(long value) {
        super.getDataBuffer().write32(value, MediaControlFrame.getFixedHeaderLength() + 4);
    }

    public void setPacketSenderSynchronizationSource(long value) {
        super.getDataBuffer().write32(value, MediaControlFrame.getFixedHeaderLength());
    }
}

